/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.Bonus;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Delta;

public abstract class BonusObj
implements Serializable,
Cloneable {
    private List bonusInfo = new LinkedList();
    private List prereqList = null;
    private Map dependMap = new HashMap();
    private Object bonusValue = null;
    private Object creatorObj = null;
    private Object targetObj = null;
    private String bonusName = "";
    private String bonusType = "";
    private String choiceString = "";
    private String varPart = "";
    private boolean isApplied = false;
    private boolean valueIsStatic = true;
    private int pcLevel = -1;
    private int typeOfBonus = -1;
    private String stringRepresentation = null;

    public void setApplied(boolean aBool) {
        this.isApplied = aBool;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    public String getBonusInfo() {
        StringBuffer sb = new StringBuffer(50);
        if (this.bonusInfo.size() > 0) {
            for (int i = 0; i < this.bonusInfo.size(); ++i) {
                sb.append(i == 0 ? "" : ",").append(this.unparseToken(this.bonusInfo.get(i)));
            }
        } else {
            sb.append("|ERROR");
        }
        return sb.toString().toUpperCase();
    }

    public List getBonusInfoList() {
        return this.bonusInfo;
    }

    public String getBonusName() {
        return this.bonusName;
    }

    public void setChoiceString(String aString) {
        this.choiceString = aString.toUpperCase();
    }

    public String getChoiceString() {
        return this.choiceString;
    }

    public void setCreatorObject(Object anObj) {
        this.creatorObj = anObj;
    }

    public Object getCreatorObject() {
        return this.creatorObj;
    }

    public boolean getDependsOn(String aString) {
        return this.dependMap.containsKey(aString);
    }

    public String getName() {
        StringBuffer b = new StringBuffer();
        if (this.creatorObj instanceof PlayerCharacter) {
            b.append(((PlayerCharacter)this.creatorObj).getName());
        } else if (this.creatorObj instanceof PObject) {
            b.append(this.creatorObj.toString());
        } else {
            b.append("NONE");
        }
        b.append(" [");
        if (this.targetObj instanceof PlayerCharacter) {
            b.append("PC");
        } else if (this.targetObj instanceof Equipment) {
            b.append(((Equipment)this.targetObj).getName());
        } else {
            b.append("NONE");
        }
        b.append("]");
        return b.toString();
    }

    public void setPCLevel(int anInt) {
        this.pcLevel = anInt;
    }

    public int getPCLevel() {
        return this.pcLevel;
    }

    public List getPrereqList() {
        return this.prereqList;
    }

    public List getClonePrereqList() throws CloneNotSupportedException {
        LinkedList<Prerequisite> newList = new LinkedList<Prerequisite>();
        Iterator iter = this.prereqList.iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            newList.add((Prerequisite)element.clone());
        }
        return newList;
    }

    public void setPrereqList(List prereqList) {
        this.prereqList = prereqList;
    }

    public String getPrereqString() {
        StringBuffer sb = new StringBuffer(50);
        if (this.prereqList != null) {
            for (int i = 0; i < this.prereqList.size(); ++i) {
                sb.append(i == 0 ? "" : "|").append(this.prereqList.get(i));
            }
        }
        return sb.toString().toUpperCase();
    }

    public boolean isPreReqKind(String aKind) {
        if (this.prereqList != null) {
            for (int i = 0; i < this.prereqList.size(); ++i) {
                Prerequisite prereq = (Prerequisite)this.prereqList.get(i);
                if (prereq == null || prereq.getKind() == null || !prereq.getKind().equalsIgnoreCase(aKind)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPreReqTarget(String aKey) {
        if (this.prereqList != null) {
            for (int i = 0; i < this.prereqList.size(); ++i) {
                Prerequisite prereq = (Prerequisite)this.prereqList.get(i);
                if (prereq.getOperand().equalsIgnoreCase(aKey)) {
                    return true;
                }
                if (prereq.getPrerequisites().size() <= 0) continue;
                List aList = prereq.getPrerequisites();
                Iterator iter = aList.iterator();
                while (iter.hasNext()) {
                    Prerequisite element = (Prerequisite)iter.next();
                    if (!element.getOperand().equalsIgnoreCase(aKey)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean passesPrereqs(Equipment eq) {
        return this.prereqList != null && PrereqHandler.passesAll(this.prereqList, eq);
    }

    public void setTargetObject(Object anObj) {
        this.targetObj = anObj;
    }

    public Object getTargetObject() {
        return this.targetObj;
    }

    public String getTypeOfBonus() {
        return Bonus.bonusTags[this.typeOfBonus];
    }

    public String getTypeString() {
        return this.bonusType;
    }

    public void setValue(String bValue) {
        try {
            this.bonusValue = new Integer(bValue);
        }
        catch (NumberFormatException e1) {
            try {
                this.bonusValue = new Float(bValue);
            }
            catch (Exception e2) {
                this.bonusValue = bValue.toUpperCase();
                this.valueIsStatic = false;
                this.buildDependMap(bValue.toUpperCase());
            }
        }
    }

    public String getValue() {
        return this.bonusValue.toString();
    }

    public double getValueAsdouble() {
        return Double.parseDouble(this.bonusValue.toString());
    }

    public double getCalculatedValue(PlayerCharacter aPC) {
        double value = 0.0;
        if (this.bonusValue != null) {
            value = this.bonusValue instanceof Integer ? (double)((Integer)this.bonusValue).longValue() : (this.bonusValue instanceof Float ? (double)((Float)this.bonusValue).floatValue() : (this.bonusValue instanceof String && this.creatorObj instanceof PObject ? ((PObject)this.creatorObj).calcBonusFrom(this, aPC, "") : this.getValueAsdouble()));
        }
        return value;
    }

    public boolean isValueStatic() {
        return this.valueIsStatic;
    }

    public void setVariable(String aString) {
        this.varPart = aString.toUpperCase();
    }

    public String getVariable() {
        return this.varPart;
    }

    public boolean hasPreReqs() {
        return this.prereqList != null;
    }

    public boolean hasTypeString() {
        return this.bonusType.length() > 0;
    }

    public boolean hasVariable() {
        return this.varPart.length() > 0;
    }

    public String getPCCText() {
        StringBuffer sb = new StringBuffer(50);
        if (this.pcLevel >= 0) {
            sb.append(this.pcLevel).append('|');
        }
        sb.append(this.getTypeOfBonus());
        if (this.bonusInfo.size() > 0) {
            for (int i = 0; i < this.bonusInfo.size(); ++i) {
                sb.append(i == 0 ? (char)'|' : ',').append(this.unparseToken(this.bonusInfo.get(i)));
            }
        } else {
            sb.append("|ERROR");
        }
        if (this.bonusValue != null) {
            sb.append('|').append(this.bonusValue.toString());
        }
        if (this.prereqList != null) {
            StringWriter writer = new StringWriter();
            for (int i = 0; i < this.prereqList.size(); ++i) {
                Prerequisite prereq = (Prerequisite)this.prereqList.get(i);
                PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
                writer.write("|");
                try {
                    prereqWriter.write(writer, prereq);
                    continue;
                }
                catch (PersistenceLayerException e) {
                    e.printStackTrace();
                }
            }
            sb.append(writer);
        }
        if (this.bonusType.length() != 0) {
            sb.append("|TYPE=").append(this.bonusType);
        }
        return sb.toString();
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuffer sb = new StringBuffer(50);
            if (this.pcLevel >= 0) {
                sb.append(this.pcLevel).append('|');
            }
            sb.append(this.getTypeOfBonus());
            if (this.bonusInfo.size() > 0) {
                for (int i = 0; i < this.bonusInfo.size(); ++i) {
                    sb.append(i == 0 ? (char)'|' : ',').append(this.unparseToken(this.bonusInfo.get(i)));
                }
            } else {
                sb.append("|ERROR");
            }
            if (this.bonusValue != null) {
                sb.append('|').append(this.bonusValue.toString());
            }
            if (this.prereqList != null) {
                sb.append('|');
                sb.append(this.getPrereqString());
            }
            if (this.bonusType.length() != 0) {
                sb.append("|TYPE=").append(this.bonusType);
            }
            this.stringRepresentation = sb.toString();
        }
        return this.stringRepresentation;
    }

    public String getDescription(boolean shortForm, PlayerCharacter aPC) {
        StringBuffer sb = new StringBuffer(50);
        if (this.bonusValue != null) {
            if (this.bonusValue instanceof Integer) {
                sb.append(Delta.toString((Integer)this.bonusValue));
            } else if (this.bonusValue instanceof Float) {
                sb.append(Delta.toString((Float)this.bonusValue));
            } else if (this.bonusValue instanceof String && this.creatorObj instanceof PObject) {
                sb.append(Delta.toString((float)((PObject)this.creatorObj).calcBonusFrom(this, aPC, "")));
            } else {
                sb.append(this.bonusValue.toString());
            }
        } else {
            sb.append("+0");
        }
        sb.append('[');
        if (this.prereqList != null) {
            for (int i = 0; i < this.prereqList.size(); ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                sb.append(((Prerequisite)this.prereqList.get(i)).getDescription(shortForm));
            }
        }
        if (this.bonusType.length() != 0) {
            if (!shortForm) {
                sb.append("|TYPE=");
            }
            if (!shortForm || sb.charAt(sb.length() - 1) == '[') {
                sb.append(this.bonusType);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    void setBonusName(String aName) {
        this.bonusName = aName;
    }

    void setTypeOfBonus(int type) {
        this.typeOfBonus = type;
    }

    void addBonusInfo(Object obj) {
        this.bonusInfo.add(obj);
    }

    public void addPreReq(Prerequisite prereq) {
        if (this.prereqList == null) {
            this.prereqList = new LinkedList();
        }
        if (!this.prereqList.contains(prereq)) {
            this.prereqList.add(prereq);
        }
    }

    boolean addType(String typeString) {
        if (this.bonusType.length() == 0) {
            this.bonusType = typeString.toUpperCase();
            return true;
        }
        return false;
    }

    boolean parseToken(String token) {
        return false;
    }

    String unparseToken(Object obj) {
        return "";
    }

    private void buildDependMap(String aString) {
        while (aString.lastIndexOf(40) >= 0) {
            int x = CoreUtility.innerMostStringStart(aString);
            int y = CoreUtility.innerMostStringEnd(aString);
            if (y < x) {
                return;
            }
            String bString = aString.substring(x + 1, y);
            this.buildDependMap(bString);
            aString = aString.substring(0, x) + aString.substring(y + 1);
        }
        if (aString.indexOf("(") >= 0 || aString.indexOf(")") >= 0 || aString.indexOf("%") >= 0) {
            return;
        }
        StringTokenizer cTok = new StringTokenizer(aString, ".");
        while (cTok.hasMoreTokens()) {
            String controlString = cTok.nextToken();
            if (controlString.equals("IF") || controlString.equals("THEN") || controlString.equals("ELSE") || controlString.equals("GT") || controlString.equals("GTEQ") || controlString.equals("EQ") || controlString.equals("LTEQ") || controlString.equals("LT")) continue;
            StringTokenizer mTok = new StringTokenizer(controlString, "+-/*");
            while (mTok.hasMoreTokens()) {
                String newString;
                String testString = newString = mTok.nextToken();
                boolean found = false;
                while (!found) {
                    if (newString.indexOf("MAX") >= 0) {
                        testString = newString.substring(0, newString.indexOf("MAX"));
                        newString = newString.substring(newString.indexOf("MAX") + 3);
                    } else if (newString.indexOf("MIN") >= 0) {
                        testString = newString.substring(0, newString.indexOf("MIN"));
                        newString = newString.substring(newString.indexOf("MIN") + 3);
                    } else {
                        found = true;
                    }
                    try {
                        Float.parseFloat(testString);
                    }
                    catch (NumberFormatException e) {
                        if (testString.length() <= 0) continue;
                        if (testString.startsWith("MOVE[")) {
                            testString = "TYPE." + testString.substring(5, testString.length() - 1);
                        }
                        this.dependMap.put(testString, "1");
                    }
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BonusObj bonusObj = (BonusObj)super.clone();
        bonusObj.bonusInfo = (List)((LinkedList)this.bonusInfo).clone();
        if (this.prereqList != null) {
            bonusObj.prereqList = new LinkedList();
            Iterator iter = this.prereqList.iterator();
            while (iter.hasNext()) {
                Prerequisite element = (Prerequisite)iter.next();
                bonusObj.prereqList.add((Prerequisite)element.clone());
            }
        }
        bonusObj.dependMap = new HashMap();
        if (this.bonusValue != null) {
            bonusObj.setValue(this.bonusValue.toString());
        }
        return bonusObj;
    }

    public void expandToken(String token, String tokenValue) {
        String value = this.getValue();
        this.setValue(CoreUtility.replaceAll(value, token, tokenValue));
        if (this.getPrereqList() != null) {
            Iterator iter = this.getPrereqList().iterator();
            while (iter.hasNext()) {
                Prerequisite prereq = (Prerequisite)iter.next();
                prereq.expandToken(token, tokenValue);
            }
        }
    }
}

