/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.util.SpellCastInfo;

final class SpellCast
extends BonusObj {
    SpellCast() {
    }

    boolean parseToken(String token) {
        int idx = token.indexOf(";LEVEL=");
        if (idx < 0) {
            idx = token.indexOf(";LEVEL.");
        }
        if (idx < 0) {
            return false;
        }
        String level = token.substring(idx + 7);
        if (token.startsWith("TYPE=") || token.startsWith("TYPE.")) {
            this.addBonusInfo(new SpellCastInfo(token.substring(5, idx), level));
            return true;
        }
        if (token.startsWith("CLASS=") || token.startsWith("CLASS.")) {
            if (token.substring(6, idx).equalsIgnoreCase("Any")) {
                this.addBonusInfo(new SpellCastInfo((PCClass)null, level));
                return true;
            }
            PCClass aClass = Globals.getClassNamed(token.substring(6, idx));
            if (aClass != null) {
                this.addBonusInfo(new SpellCastInfo(aClass, level));
                return true;
            }
        }
        return false;
    }

    String unparseToken(Object obj) {
        StringBuffer sb = new StringBuffer(30);
        if (((SpellCastInfo)obj).getType() != null) {
            sb.append("TYPE.").append(((SpellCastInfo)obj).getType());
        } else {
            sb.append("CLASS.");
            if (((SpellCastInfo)obj).getPcClass() != null) {
                sb.append(((SpellCastInfo)obj).getPcClass().getName());
            } else {
                sb.append("Any");
            }
        }
        sb.append(";LEVEL.").append(((SpellCastInfo)obj).getLevel());
        return sb.toString();
    }
}

