/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.util.MissingObject;

final class Stat
extends BonusObj {
    private static final String[] bonusTags = new String[]{"BASESPELLSTAT", "BASESPELLKNOWNSTAT"};

    Stat() {
    }

    boolean parseToken(String token) {
        int iStat;
        for (int i = 0; i < bonusTags.length; ++i) {
            if (!bonusTags[i].equals(token)) continue;
            this.addBonusInfo(new Integer(i));
            return true;
        }
        if (token.startsWith("CAST=") || token.startsWith("CAST.")) {
            iStat = SettingsHandler.getGame().getStatFromAbbrev(token.substring(5));
            if (iStat >= 0) {
                this.addBonusInfo(new CastStat((PCStat)SettingsHandler.getGame().getUnmodifiableStatList().get(iStat)));
                return true;
            }
        } else {
            iStat = SettingsHandler.getGame().getStatFromAbbrev(token);
            if (iStat >= 0) {
                this.addBonusInfo(SettingsHandler.getGame().getUnmodifiableStatList().get(iStat));
            } else {
                PCClass aClass = Globals.getClassNamed(token);
                if (aClass != null) {
                    this.addBonusInfo(aClass);
                } else {
                    this.addBonusInfo(new MissingObject(token));
                }
            }
            return true;
        }
        return false;
    }

    String unparseToken(Object obj) {
        if (obj instanceof Integer) {
            return bonusTags[(Integer)obj];
        }
        if (obj instanceof CastStat) {
            return "CAST." + ((CastStat)obj).stat.getAbb();
        }
        if (obj instanceof PCClass) {
            return ((PCClass)obj).getName();
        }
        if (obj instanceof MissingObject) {
            return ((MissingObject)obj).getObjectName();
        }
        return ((PCStat)obj).getAbb();
    }

    private static class CastStat {
        protected PCStat stat = null;

        CastStat(PCStat argStat) {
            this.stat = argStat;
        }
    }
}

