/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;

public final class CharacterSpell
implements Comparable {
    private final List infoList = new ArrayList();
    private PObject owner;
    private Spell spell = null;

    public CharacterSpell(PObject o, Spell aSpell) {
        this.owner = o;
        this.spell = aSpell;
    }

    public int getInfoIndexFor(String bookName, int level, int specialty) {
        boolean sp;
        if (this.infoList.isEmpty()) {
            return -1;
        }
        boolean bl = sp = specialty == 1;
        if (sp && specialty != -1) {
            sp = this.isSpecialtySpell();
        }
        int i = 0;
        Iterator x = this.infoList.iterator();
        while (x.hasNext()) {
            SpellInfo s = (SpellInfo)x.next();
            if (!(!"".equals(bookName) && !bookName.equals(s.getBook()) || level != -1 && s.getActualLevel() != level || specialty != -1 && !sp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Iterator getInfoListIterator() {
        return this.infoList.iterator();
    }

    public PObject getOwner() {
        return this.owner;
    }

    public boolean isSpecialtySpell() {
        boolean result;
        if (this.spell == null) {
            result = false;
        } else if (this.owner instanceof Domain) {
            result = true;
        } else if (this.owner instanceof PCClass) {
            PCClass a = (PCClass)this.owner;
            result = a.isSpecialtySpell(this.spell);
        } else {
            result = false;
        }
        return result;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellInfo getSpellInfoFor(String bookName, int level, int specialty) {
        return this.getSpellInfoFor(bookName, level, specialty, null);
    }

    public SpellInfo getSpellInfoFor(String bookName, int level, int specialty, List featList) {
        boolean sp;
        if (this.infoList.isEmpty()) {
            return null;
        }
        boolean bl = sp = specialty == 1;
        if (sp && specialty != -1) {
            sp = this.isSpecialtySpell();
        }
        Iterator x = this.infoList.iterator();
        while (x.hasNext()) {
            SpellInfo s = (SpellInfo)x.next();
            if (!"".equals(bookName) && !bookName.equals(s.getBook()) || level != -1 && s.getActualLevel() != level || specialty != -1 && !sp || featList != null && (!featList.isEmpty() || s.getFeatList() != null && !s.getFeatList().isEmpty()) && !featList.toString().equals(s.getFeatList().toString())) continue;
            return s;
        }
        return null;
    }

    public SpellInfo addInfo(int level, int times, String book) {
        return this.addInfo(level, times, book, null);
    }

    public SpellInfo addInfo(int level, int times, String book, List featList) {
        SpellInfo si = new SpellInfo(this, level, times, book);
        if (featList != null) {
            si.addFeatsToList(featList);
        }
        this.infoList.add(si);
        return si;
    }

    public int compareTo(Object obj) {
        return this.spell.compareTo(((CharacterSpell)obj).getSpell());
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CharacterSpell && ((CharacterSpell)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void removeSpellInfo(SpellInfo x) {
        if (x != null) {
            this.infoList.remove(x);
        }
    }

    public String toString() {
        String result = this.spell == null ? "" : this.spell.getName();
        return result;
    }

    private String getName() {
        String result = this.owner.toString();
        if (this.spell != null) {
            result = result + ":" + this.spell.getName();
        }
        return result;
    }
}

