/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

public final class EquipSet
implements Comparable,
Cloneable {
    private Equipment eq_item = null;
    private Float qty = new Float(1.0f);
    private List tempBonusList = new LinkedList();
    private String id_path = "";
    private String name = "";
    private String note = "";
    private String value = "";
    private boolean useTempBonuses = false;

    public EquipSet(String id, String aName) {
        this.id_path = id;
        this.name = aName;
    }

    public EquipSet(String id, String aName, String aValue, Equipment item) {
        this.id_path = id;
        this.name = aName;
        this.value = aValue;
        this.eq_item = item;
    }

    public int getId() {
        int id = 0;
        try {
            StringTokenizer aTok = new StringTokenizer(this.id_path, ".", false);
            while (aTok.hasMoreTokens()) {
                id = Integer.valueOf(aTok.nextToken());
            }
        }
        catch (NullPointerException e) {
            Logging.errorPrint("Error in EquipSet.getId", e);
        }
        return id;
    }

    public void setIdPath(String x) {
        this.id_path = x;
    }

    public String getIdPath() {
        return this.id_path;
    }

    public void setItem(Equipment item) {
        this.eq_item = item;
    }

    public Equipment getItem() {
        return this.eq_item;
    }

    public void setName(String x) {
        this.name = x;
    }

    public String getName() {
        return this.name;
    }

    public void setNote(String aString) {
        this.note = aString;
    }

    public String getNote() {
        return this.note;
    }

    public String getParentIdPath() {
        StringBuffer buf = new StringBuffer(50);
        try {
            StringTokenizer aTok = new StringTokenizer(this.id_path, ".", true);
            for (int i = aTok.countTokens() - 2; i > 0; --i) {
                buf.append(aTok.nextToken());
            }
        }
        catch (NullPointerException e) {
            Logging.errorPrint("Error in EquipSet.getParentIdPath", e);
        }
        return buf.toString();
    }

    public void setQty(Float x) {
        this.qty = x;
    }

    public Float getQty() {
        return this.qty;
    }

    public String getRootIdPath() {
        String result;
        StringBuffer buf = new StringBuffer(50);
        StringTokenizer aTok = new StringTokenizer(this.id_path, ".", false);
        if (aTok.countTokens() < 2) {
            result = "";
        } else {
            buf.append(aTok.nextToken());
            buf.append(".");
            buf.append(aTok.nextToken());
            result = buf.toString();
        }
        return result;
    }

    public void setTempBonusList(List aList) {
        this.tempBonusList = aList;
    }

    public List getTempBonusList() {
        return this.tempBonusList;
    }

    public void setUseTempMods(boolean aBool) {
        this.useTempBonuses = aBool;
    }

    public boolean getUseTempMods() {
        return this.useTempBonuses;
    }

    public void setValue(String x) {
        this.value = x;
    }

    public String getValue() {
        return this.value;
    }

    public void clearTempBonusList() {
        this.tempBonusList.clear();
    }

    public Object clone() {
        EquipSet eqSet = null;
        try {
            eqSet = (EquipSet)super.clone();
            if (this.getItem() != null) {
                eqSet.setItem((Equipment)this.getItem().clone());
            }
            if (this.getQty() != null) {
                eqSet.setQty(new Float(this.getQty().floatValue()));
            }
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return eqSet;
    }

    public int compareTo(Object obj) {
        EquipSet es = (EquipSet)obj;
        return this.id_path.compareToIgnoreCase(es.getIdPath());
    }

    public String toString() {
        return this.name;
    }

    public boolean useTempBonusList() {
        return !this.tempBonusList.isEmpty();
    }
}

