/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreVariableParser;
import pcgen.util.Logging;

public final class WieldCategory {
    private Map damageMultMap = new HashMap();
    private Map switchMap = new HashMap();
    private Map wcStepMap = new HashMap();
    private String name = "";
    private boolean finessBool = false;
    private int hands = 999;
    private int sizeDiff = 0;

    public WieldCategory(String aName) {
        this.name = aName;
    }

    public int getDamageMult(int hands) {
        String aKey = Integer.toString(hands);
        Integer anInt = new Integer(1);
        if (this.damageMultMap.containsKey(aKey)) {
            anInt = Integer.getInteger((String)this.damageMultMap.get(aKey));
        }
        return anInt;
    }

    public void setFinessable(boolean aBool) {
        this.finessBool = aBool;
    }

    public boolean isFinessable() {
        return this.finessBool;
    }

    public void setHands(int x) {
        this.hands = x;
    }

    public int getHands() {
        return this.hands;
    }

    public void setName(String aString) {
        this.name = aString;
    }

    public String getName() {
        return this.name;
    }

    public int getObjectSizeInt(Equipment eq) {
        int eqSize = eq.sizeInt();
        return eqSize + this.sizeDiff;
    }

    public void setSizeDiff(int x) {
        this.sizeDiff = x;
    }

    public void setWCStep(int aInt, String aVal) {
        String aKey = new Integer(aInt).toString();
        this.wcStepMap.put(aKey, aVal);
    }

    public String getWieldCategory(PlayerCharacter aPC, Equipment eq) {
        if (aPC == null || eq == null) {
            return this.name;
        }
        Iterator pc = this.switchMap.keySet().iterator();
        while (pc.hasNext()) {
            String aKey = (String)pc.next();
            PreVariableParser parser = new PreVariableParser();
            boolean invertResult = false;
            if (aKey.startsWith("!")) {
                invertResult = true;
                aKey = aKey.substring(1);
            }
            String aType = aKey.substring(3, aKey.indexOf(":"));
            String preVar = aKey.substring(aKey.indexOf(":") + 1);
            try {
                Prerequisite prereq = parser.parse(aType, preVar, invertResult, false);
                if (!PrereqHandler.passes(prereq, eq)) continue;
                return (String)this.switchMap.get(aKey);
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint(ple.getMessage(), ple);
            }
        }
        return this.name;
    }

    public String getWieldCategoryStep(int aBump) {
        String aKey = Integer.toString(aBump);
        String newWC = (String)this.wcStepMap.get(aKey);
        if (newWC != null) {
            return newWC;
        }
        return this.name;
    }

    public void addDamageMultMap(String aKey, String aVal) {
        this.damageMultMap.put(aKey, aVal);
    }

    public void addSwitchMap(String aKey, String aVal) {
        this.switchMap.put(aKey, aVal);
    }
}

