/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.kit.BaseKit;
import pcgen.util.Logging;

public final class KitGear
extends BaseKit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List eqMods = null;
    private String name = "";
    private int maxCost = 0;
    private int qty = 1;

    public KitGear(String gearName) {
        this.name = gearName;
    }

    public List getEqMods() {
        return this.eqMods;
    }

    public void setMaxCost(String argMaxCost) {
        try {
            this.maxCost = Integer.parseInt(argMaxCost);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Invalid max cost \"" + argMaxCost + "\" in KitGear.setMaxCost");
        }
    }

    public int getMaxCost() {
        return this.maxCost;
    }

    public String getName() {
        return this.name;
    }

    public void setQty(String argQty) {
        try {
            this.qty = Integer.parseInt(argQty);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Invalid qty \"" + argQty + "\" in KitGear.setQty");
        }
    }

    public int getQty() {
        return this.qty;
    }

    public void addEqMod(String argEqMod) {
        if (this.eqMods == null) {
            this.eqMods = new ArrayList();
        }
        this.eqMods.add(argEqMod);
    }

    public String toString() {
        int maxSize = 0;
        if (this.eqMods != null) {
            maxSize = this.eqMods.size();
        }
        StringBuffer info = new StringBuffer(maxSize * 5);
        if (this.qty != 1) {
            info.append(this.qty).append('x');
        }
        info.append(this.name);
        if (maxSize > 0) {
            info.append(" (");
            for (int i = 0; i < maxSize; ++i) {
                if (i != 0) {
                    info.append('/');
                }
                info.append((String)this.eqMods.get(i));
            }
            info.append(')');
        }
        return info.toString();
    }
}

