/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.money;

import pcgen.core.money.Denomination;

final class Coin {
    protected Denomination denom;
    protected long amount;

    Coin(Denomination denom, long amount) {
        this.denom = denom;
        this.amount = amount;
    }

    Coin(Denomination aDenom) {
        this(aDenom, 0L);
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public long getAmount() {
        return this.amount;
    }

    public Denomination getDenomination() {
        return this.denom;
    }

    public boolean isDenomination(Denomination d) {
        boolean val = false;
        try {
            return this.denom.getName().equals(d.getName());
        }
        catch (Exception e) {
            return val;
        }
    }

    public int getFactor() {
        return this.denom.getFactor();
    }

    public long getFactoredAmount() {
        return this.amount * (long)this.denom.factor;
    }

    public String getName() {
        return this.denom.getName();
    }

    public float getWeight() {
        return this.denom.getWeight() * (float)this.amount;
    }

    public long add(long argAmount) {
        return this.amount += argAmount;
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean useAbbr) {
        return this.amount + " " + (useAbbr ? this.denom.getAbbr() : this.denom.getName());
    }
}

