/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.money;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.money.Coin;
import pcgen.core.money.Denomination;
import pcgen.core.money.Denominations;

final class Coins {
    private Coin defaultCoin;
    private List coins = new ArrayList();

    Coins(Denominations currency) {
        Iterator i = currency.iterator();
        while (i.hasNext()) {
            Denomination d = (Denomination)i.next();
            Coin c = new Coin(d);
            this.coins.add(c);
            if (currency.getDefaultCoin() == null || !c.isDenomination(currency.getDefaultCoin())) continue;
            this.defaultCoin = c;
        }
    }

    public static Coin parseCoin(String coinAmount, Coins someCoins) {
        coinAmount = coinAmount.trim();
        Coin tempCoin = null;
        if (coinAmount.length() > 0) {
            int pos;
            String coinName = "";
            long amount = 0L;
            int index = 0;
            if (coinAmount.charAt(index) == '+') {
                coinAmount = coinAmount.substring(++index);
            }
            try {
                for (pos = index; pos < coinAmount.length(); ++pos) {
                    char c = coinAmount.charAt(pos);
                    if (c >= '0' && c <= '9') continue;
                    amount = Long.parseLong(coinAmount.substring(index, pos));
                    coinName = coinAmount.substring(pos);
                    coinName = coinName.trim();
                    break;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (pos >= coinAmount.length()) {
                if (someCoins.defaultCoin != null) {
                    coinName = someCoins.defaultCoin.getName();
                    amount = Long.parseLong(coinAmount);
                } else {
                    return null;
                }
            }
            if ((tempCoin = someCoins.cloneCoin(coinName)) != null) {
                tempCoin.amount = amount;
            }
        }
        return tempCoin;
    }

    public Coin getCoin(String name) {
        Iterator i = this.coins.iterator();
        while (i.hasNext()) {
            Coin c = (Coin)i.next();
            if (!c.denom.getName().equalsIgnoreCase(name) && !c.denom.getAbbr().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public Coin getDefaultCoin() {
        return this.defaultCoin;
    }

    public float getWeight(String name) {
        Coin c = this.getCoin(name);
        return c != null ? (float)c.getAmount() * c.getWeight() : 0.0f;
    }

    public double getWeight() {
        Iterator i = this.coins.iterator();
        double weight = 0.0;
        while (i.hasNext()) {
            Coin c = (Coin)i.next();
            weight += (double)c.getWeight();
        }
        return weight;
    }

    public Iterator iterator() {
        return this.coins.iterator();
    }

    public String toString() {
        return this.toString(true, false, true);
    }

    public String toString(boolean useAbbr, boolean includeZeros, boolean startAtDefault) {
        StringBuffer result = new StringBuffer(50);
        long carriedAmount = 0L;
        Iterator i = this.coins.iterator();
        while (i.hasNext()) {
            Coin c = Coins.cloneCoin((Coin)i.next());
            if (startAtDefault) {
                if (c.isDenomination(this.defaultCoin.getDenomination())) {
                    c.add(carriedAmount / (long)c.getFactor());
                    startAtDefault = false;
                } else {
                    carriedAmount += c.getFactoredAmount();
                    c.setAmount(0L);
                }
            }
            if ((!includeZeros || c.getAmount() != 0L) && c.getAmount() == 0L) continue;
            result.append(c.toString(useAbbr)).append(", ");
        }
        if (result.length() > 2) {
            result = new StringBuffer(result.substring(0, result.length() - 2));
        }
        return result.toString();
    }

    private Coin cloneCoin(String name) {
        Coin c = this.getCoin(name);
        return c == null ? null : new Coin(c.denom, c.amount);
    }

    private static Coin cloneCoin(Coin name) {
        return name == null ? null : new Coin(name.denom, name.amount);
    }
}

