/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.money;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Constants;
import pcgen.core.money.Denomination;
import pcgen.core.money.iDefaultRankConstants;

public final class Denominations
implements iDefaultRankConstants {
    private Denomination defaultCoin;
    private List coinDenominations = new ArrayList();
    private String region;
    private int defaultRank = 0;

    public Denomination getDefaultCoin() {
        return this.defaultCoin;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void addDenomination(String name, String abbr, int factor, float weight, boolean isDefault) {
        Denomination newCoin = new Denomination(name, abbr, factor, weight);
        this.addDenomination(newCoin);
        if (isDefault && this.defaultRank < 4) {
            this.defaultCoin = newCoin;
            this.defaultRank = 4;
        }
    }

    public Iterator iterator() {
        return this.coinDenominations.iterator();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(50);
        Iterator i = this.coinDenominations.iterator();
        while (i.hasNext()) {
            Denomination d = (Denomination)i.next();
            result.append(d).append(Constants.s_LINE_SEP);
        }
        return result.toString();
    }

    private void addDenomination(Denomination coin) {
        Iterator i = this.coinDenominations.iterator();
        boolean found = false;
        while (i.hasNext()) {
            Denomination d = (Denomination)i.next();
            String name = d.getName();
            if (!name.equalsIgnoreCase(coin.getName())) continue;
            d = coin;
            found = true;
            break;
        }
        if (!found) {
            this.coinDenominations.add(coin);
            String ucName = coin.getName().toUpperCase();
            if ("GOLD".equals(ucName) && this.defaultRank < 3) {
                this.defaultCoin = coin;
                this.defaultRank = 3;
            } else if (this.defaultRank < 2 && (ucName.indexOf(" GOLD ") >= 0 || ucName.startsWith("GOLD ") || ucName.endsWith(" GOLD"))) {
                this.defaultCoin = coin;
                this.defaultRank = 2;
            }
        }
        Collections.sort(this.coinDenominations);
        if (this.coinDenominations.size() > 0 && this.defaultRank <= 1) {
            this.defaultCoin = (Denomination)this.coinDenominations.get(0);
            this.defaultRank = 1;
        }
    }
}

