/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.money;

import java.util.Iterator;
import pcgen.core.money.Coin;
import pcgen.core.money.Coins;
import pcgen.core.money.Denominations;

public final class Purse {
    private Coins coins;

    public Purse(Coins coins) {
        this.coins = coins;
    }

    public Purse(Denominations coins) {
        this.coins = new Coins(coins);
    }

    public void setAmount(long amount, String coinName) {
        if (coinName.equals("")) {
            this.coins.getDefaultCoin().setAmount(amount);
        } else {
            Coin c = this.coins.getCoin(coinName);
            if (c != null) {
                c.setAmount(amount);
            }
        }
    }

    public void setAmount(String coinAmount) {
        Coin tempCoin = Coins.parseCoin(coinAmount, this.coins);
        this.setAmount(tempCoin.getAmount(), tempCoin.getName());
    }

    public void setAmount(double amount) {
        this.setTotalValue((long)(amount * (double)this.coins.getDefaultCoin().getFactor()));
    }

    public long getAmount(String coinName) {
        Coin c = this.coins.getCoin(coinName);
        if (c != null) {
            return c.getAmount();
        }
        return 0L;
    }

    public void setLCDValue() {
        this.setTotalValue(this.getTotalValue());
    }

    public void setTotalValue(long amount) {
        Iterator i = this.coins.iterator();
        while (i.hasNext()) {
            Coin c = (Coin)i.next();
            c.setAmount(amount / (long)c.getFactor());
            amount %= (long)c.getFactor();
        }
    }

    public long getTotalValue() {
        Iterator i = this.coins.iterator();
        long result = 0L;
        while (i.hasNext()) {
            Coin c = (Coin)i.next();
            result += c.getFactoredAmount();
        }
        return result;
    }

    public double getWeight(String name) {
        return this.coins.getWeight(name);
    }

    public double getWeight() {
        return this.coins.getWeight();
    }

    public void add(long amount) {
        this.coins.getDefaultCoin().add(amount);
    }

    public void add(long amount, String coinName) {
        Coin c = coinName.equals("") ? this.coins.getDefaultCoin() : this.coins.getCoin(coinName);
        if (c != null) {
            c.add(amount);
        }
    }

    public void add(Coin coin) {
        this.add(coin.getAmount(), coin.getName());
    }

    public void add(String coinAmount) {
        Coin tempCoin = Coins.parseCoin(coinAmount, this.coins);
        if (tempCoin != null) {
            this.add(tempCoin.getAmount(), tempCoin.getName());
        }
    }

    public void add(double amount) {
        this.addLCD((long)(amount * (double)this.coins.getDefaultCoin().getFactor()));
    }

    public void add(Coins someCoins) {
        Iterator i = someCoins.iterator();
        while (i.hasNext()) {
            this.add((Coin)i.next());
        }
    }

    public void addLCD(long amount) {
        Iterator i = this.coins.iterator();
        while (i.hasNext()) {
            Coin c = (Coin)i.next();
            c.add(amount / (long)c.getFactor());
            amount %= (long)c.getFactor();
        }
    }

    public long coinAmount(String coinName) {
        Coin c = this.coins.getCoin(coinName);
        if (c != null) {
            return c.getAmount();
        }
        return 0L;
    }

    public String coinTotal(String coinName, boolean useAbbr) {
        Coin c = this.coins.getCoin(coinName);
        if (c != null) {
            return c.toString(useAbbr);
        }
        return "";
    }

    public String coinTotal(boolean useAbbr) {
        return this.toString(useAbbr, false, true);
    }

    public boolean equals(Purse purse) {
        return this.getTotalValue() == purse.getTotalValue();
    }

    public boolean equals(Coin coin) {
        return this.getTotalValue() == coin.getFactoredAmount();
    }

    public boolean equals(long amount) {
        return this.getTotalValue() == amount;
    }

    public boolean equals(double amount) {
        return Math.abs((double)this.getTotalValue() - amount) < 9.9E-324;
    }

    public boolean greaterThan(Purse purse) {
        return this.getTotalValue() < purse.getTotalValue();
    }

    public boolean greaterThan(Coin coin) {
        return this.getTotalValue() > coin.getFactoredAmount();
    }

    public boolean greaterThan(long amount) {
        return this.getTotalValue() > amount;
    }

    public boolean greaterThan(double amount) {
        return (double)this.getTotalValue() > amount;
    }

    public boolean lessThan(Purse purse) {
        return this.getTotalValue() < purse.getTotalValue();
    }

    public boolean lessThan(Coin coin) {
        return this.getTotalValue() < coin.getFactoredAmount();
    }

    public boolean lessThan(long amount) {
        return this.getTotalValue() < amount;
    }

    public boolean lessThan(double amount) {
        return (double)this.getTotalValue() < amount;
    }

    public void subtract(Coin coin) {
        this.add(0L - coin.getAmount(), coin.getName());
    }

    public void subtract(Coins someCoins) {
        Iterator i = someCoins.iterator();
        while (i.hasNext()) {
            this.subtract((Coin)i.next());
        }
    }

    public String toString() {
        return this.toString(true, false, true);
    }

    public String toString(boolean useAbbr, boolean includeZeros, boolean startAtDefault) {
        return this.coins.toString(useAbbr, includeZeros, startAtDefault);
    }

    public double value() {
        double coinValue = this.getTotalValue();
        return coinValue / (double)this.coins.getDefaultCoin().getFactor();
    }

    public double value(String coinName) {
        Coin c = this.coins.getCoin(coinName);
        double coinValue = this.getTotalValue();
        return coinValue / (double)c.getFactor();
    }
}

