/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.party;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.io.PCGIOHandler;
import pcgen.util.FileHelper;
import pcgen.util.Logging;

public class Party {
    private File partyFile;
    private List characterFiles = new ArrayList();

    private Party() {
    }

    private Party(File partyFile) {
        this.partyFile = partyFile;
    }

    public static Party makePartyFromFile(File partyFile) {
        return new Party(partyFile);
    }

    public static Party makeSingleCharacterParty(File characterFile) {
        Party party = new Party();
        party.characterFiles.add(characterFile);
        return party;
    }

    public String getDisplayName() {
        String displayName = this.partyFile.getName();
        int lastDot = displayName.lastIndexOf(46);
        if (lastDot >= 0) {
            displayName = displayName.substring(0, lastDot);
        }
        return displayName;
    }

    public void addAllOpenCharacters() {
        Iterator characters = Globals.getPCList().iterator();
        while (characters.hasNext()) {
            PlayerCharacter character = (PlayerCharacter)characters.next();
            this.characterFiles.add(new File(character.getFileName()));
        }
    }

    public boolean load(PCGen_Frame1 mainFrame) {
        boolean success;
        block7: {
            if (this.partyFile == null) {
                return this.loadCharacterFiles();
            }
            success = true;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.partyFile), "UTF-8"));
                br.readLine();
                String charFiles = br.readLine();
                br.close();
                StringTokenizer fileNames = new StringTokenizer(charFiles, ",");
                while (fileNames.hasMoreTokens()) {
                    String fileName = fileNames.nextToken();
                    File characterFile = this.buildCharacterFile(fileName);
                    if (!characterFile.exists()) {
                        characterFile = new File(SettingsHandler.getPcgPath(), fileName);
                    }
                    if (characterFile.exists()) {
                        this.characterFiles.add(characterFile);
                        if (mainFrame != null) {
                            mainFrame.loadPCFromFile(characterFile);
                            continue;
                        }
                        Party.loadPCFromFile(characterFile);
                        continue;
                    }
                    Logging.errorPrint("Character file does not exist: " + fileName);
                    success = false;
                }
                Globals.sortCampaigns();
            }
            catch (IOException ex) {
                success = false;
                Logging.errorPrint("Error loading party partyFile.", ex);
                if (!Globals.getUseGUI()) break block7;
                ShowMessageDelegate.showMessageDialog("Could not load party partyFile.", "PCGen", MessageType.ERROR);
            }
        }
        return success;
    }

    public void save() throws FileNotFoundException, IOException {
        if (this.partyFile == null) {
            throw new FileNotFoundException("The file to save this party to is null");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.partyFile), "UTF-8"));
        ResourceBundle properties = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
        writer.write("VERSION:");
        writer.write(properties.getString("VersionNumber"));
        writer.newLine();
        for (int i = 0; i < this.characterFiles.size(); ++i) {
            File file = (File)this.characterFiles.get(i);
            writer.write(FileHelper.findRelativePath(this.partyFile, file) + ",");
        }
        writer.newLine();
        writer.close();
        SettingsHandler.setPcgPath(this.partyFile.getParentFile());
    }

    private File buildCharacterFile(String fileName) {
        return new File(this.partyFile.getParentFile().getAbsolutePath() + fileName);
    }

    private boolean loadCharacterFiles() {
        boolean success = true;
        for (int i = 0; i < this.characterFiles.size(); ++i) {
            File file = (File)this.characterFiles.get(i);
            success = Party.loadPCFromFile(file);
        }
        return success;
    }

    private static boolean loadPCFromFile(File file) {
        Iterator it;
        PlayerCharacter newPC = new PlayerCharacter();
        PCGIOHandler ioHandler = new PCGIOHandler();
        ioHandler.read(newPC, file.getAbsolutePath());
        if (Globals.getUseGUI()) {
            it = ioHandler.getErrors().iterator();
            while (it.hasNext()) {
                ShowMessageDelegate.showMessageDialog("Error: " + it.next(), "PCGen", MessageType.ERROR);
            }
            it = ioHandler.getWarnings().iterator();
            while (it.hasNext()) {
                ShowMessageDelegate.showMessageDialog("Warning: " + it.next(), "PCGen", MessageType.ERROR);
            }
        } else {
            it = ioHandler.getMessages().iterator();
            while (it.hasNext()) {
                Logging.errorPrint((String)it.next());
            }
        }
        boolean result = false;
        if (ioHandler.getErrors().size() <= 0) {
            newPC.setFileName(file.getAbsolutePath());
            Globals.getPCList().add(newPC);
            Globals.setCurrentPC(newPC);
            Globals.sortCampaigns();
            result = true;
        }
        return result;
    }
}

