/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.pclevelinfo;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfoStat;

public final class PCLevelInfo {
    private List statsPostModified = null;
    private List statsPreModified = null;
    private String classKeyName = "";
    private int level = 0;
    private int skillPointsGained = 0;
    private int skillPointsRemaining = 0;

    public PCLevelInfo(String argClassKeyName) {
        this.classKeyName = argClassKeyName;
    }

    public void setClassKeyName(String argClassKeyName) {
        this.classKeyName = argClassKeyName;
    }

    public String getClassKeyName() {
        return this.classKeyName;
    }

    public void setLevel(int arg) {
        this.level = arg;
    }

    public int getLevel() {
        return this.level;
    }

    public List getModifiedStats(boolean preMod) {
        List result = this.statsPostModified;
        if (preMod) {
            result = this.statsPreModified;
        }
        return result;
    }

    public void setSkillPointsGained(int arg) {
        this.skillPointsGained = arg;
    }

    public int getSkillPointsGained(PlayerCharacter aPC) {
        return this.getSkillPointsGained(true, aPC);
    }

    public int getSkillPointsGained(boolean addBonus, PlayerCharacter aPC) {
        if (this.skillPointsGained == 0 && this.classKeyName.length() > 0) {
            PCClass aClass = Globals.getClassKeyed(this.classKeyName);
            this.skillPointsGained = aClass.recalcSkillPointMod(aPC, this.level);
        }
        if (addBonus) {
            return this.skillPointsGained + this.getBonusSkillPool(aPC);
        }
        return this.skillPointsGained;
    }

    public void setSkillPointsRemaining(int arg, PlayerCharacter aPC) {
        this.setSkillPointsRemaining(arg, false, aPC);
    }

    public void setSkillPointsRemaining(int arg, boolean delBonus, PlayerCharacter aPC) {
        this.skillPointsRemaining = arg;
        if (delBonus) {
            this.skillPointsRemaining -= this.getBonusSkillPool(aPC);
        }
    }

    public int getSkillPointsRemaining(PlayerCharacter aPC) {
        return this.getSkillPointsRemaining(true, aPC);
    }

    public int getSkillPointsRemaining(boolean addBonus, PlayerCharacter aPC) {
        if (addBonus) {
            return this.skillPointsRemaining + this.getBonusSkillPool(aPC);
        }
        return this.skillPointsRemaining;
    }

    public int getTotalStatMod(String statAbb, boolean includePost) {
        int i;
        int mod = 0;
        if (this.statsPreModified != null) {
            for (i = 0; i < this.statsPreModified.size(); ++i) {
                if (!((PCLevelInfoStat)this.statsPreModified.get(i)).getStatAbb().equals(statAbb)) continue;
                mod += ((PCLevelInfoStat)this.statsPreModified.get(i)).getStatMod();
            }
        }
        if (includePost && this.statsPostModified != null) {
            for (i = 0; i < this.statsPostModified.size(); ++i) {
                if (!((PCLevelInfoStat)this.statsPostModified.get(i)).getStatAbb().equals(statAbb)) continue;
                mod += ((PCLevelInfoStat)this.statsPostModified.get(i)).getStatMod();
            }
        }
        return mod;
    }

    public void addModifiedStat(String statAbb, int mod, boolean isPreMod) {
        List statList;
        if (isPreMod) {
            if (this.statsPreModified == null) {
                this.statsPreModified = new ArrayList();
            }
            statList = this.statsPreModified;
        } else {
            if (this.statsPostModified == null) {
                this.statsPostModified = new ArrayList();
            }
            statList = this.statsPostModified;
        }
        for (int i = 0; i < statList.size(); ++i) {
            PCLevelInfoStat aStat = (PCLevelInfoStat)statList.get(i);
            if (!statAbb.equals(aStat.getStatAbb())) continue;
            aStat.modifyStat(mod);
            if (aStat.getStatMod() == 0) {
                statList.remove(aStat);
            }
            return;
        }
        statList.add(new PCLevelInfoStat(statAbb, mod));
    }

    private int getBonusSkillPool(PlayerCharacter aPC) {
        int returnValue = 0;
        PCClass aClass = aPC.getClassKeyed(this.classKeyName);
        if (aClass != null) {
            returnValue += (int)aClass.getBonusTo("SKILLPOOL", "NUMBER", this.level, aPC);
            returnValue -= (int)aClass.getBonusTo("SKILLPOOL", "NUMBER", this.level - 1, aPC);
        }
        if (this.level == 1) {
            returnValue += (int)aPC.getTotalBonusTo("SKILLPOOL", "CLASS." + this.classKeyName);
        }
        returnValue += (int)aPC.getTotalBonusTo("SKILLPOOL", "CLASS." + this.classKeyName + ";LEVEL." + Integer.toString(this.level));
        return returnValue += (int)aPC.getTotalBonusTo("SKILLPOOL", "LEVEL." + aPC.getCharacterLevel(this));
    }
}

