/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreAlign
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        PlayerCharacter aPC = Globals.getCurrentPC();
        if (aPC == null) {
            return 0;
        }
        return this.passes(prereq, aPC);
    }

    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        if (Globals.getGameModeAlignmentText().length() == 0) {
            runningTotal = 1;
        } else {
            String deityAlignStr;
            GameMode gm = SettingsHandler.getGame();
            String desiredAlignment = prereq.getKey();
            try {
                int align = Integer.parseInt(prereq.getKey());
                String[] aligns = SettingsHandler.getGame().getAlignmentListStrings(false);
                desiredAlignment = aligns[align];
            }
            catch (Exception e) {
                // empty catch block
            }
            String charAlignment = gm.getShortAlignmentAtIndex(character.getAlignment());
            if (desiredAlignment.equalsIgnoreCase(charAlignment)) {
                runningTotal = 1;
            } else if (desiredAlignment.equalsIgnoreCase("Deity") && character.getDeity() != null && (deityAlignStr = character.getDeity().getAlignment()).equalsIgnoreCase(charAlignment)) {
                runningTotal = 1;
            }
        }
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "align";
    }

    public String toHtmlString(Prerequisite prereq) {
        String alignment = prereq.getKey();
        try {
            int align = Integer.parseInt(prereq.getKey());
            String[] aligns = SettingsHandler.getGame().getAlignmentListStrings(false);
            alignment = aligns[align];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PropertyFactory.getFormattedString("PreAlign.toHtml", prereq.getOperator().toDisplayString(), alignment);
    }
}

