/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreApply
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        return 0;
    }

    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = 1;
        String requiredType = null;
        try {
            targetNumber = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException ne) {
            requiredType = prereq.getOperand();
            targetNumber = 1;
        }
        Iterator iter = prereq.getPrerequisites().iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test != null) {
                runningTotal += test.passes(element, equipment);
                continue;
            }
            Logging.errorPrintLocalised("PreApply.cannot_find_test", element.getKind());
        }
        if (requiredType == null) {
            return runningTotal >= targetNumber ? 1 : 0;
        }
        if (prereq.getOperator().equals(PrerequisiteComparator.EQ)) {
            if (equipment.isPreType(requiredType)) {
                ++runningTotal;
            }
        } else if (prereq.getOperator().equals(PrerequisiteComparator.NEQ)) {
            if (!equipment.isPreType(requiredType)) {
                ++runningTotal;
            }
        } else {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreApply.invalid_comparison", prereq.getOperator().toString()));
        }
        runningTotal = this.countedTotal(prereq, runningTotal);
        return runningTotal;
    }

    public int passes(Prerequisite prereq, String aString) throws PrerequisiteException {
        if (prereq.getKey().equalsIgnoreCase(aString)) {
            return 1;
        }
        return 1;
    }

    public String kindHandled() {
        return "APPLY";
    }

    public String toHtmlString(Prerequisite prereq) {
        return PropertyFactory.getFormattedString("PreApply.toHtml", prereq.getOperator().toString(), prereq.getOperand());
    }
}

