/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreClass
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        boolean runningTotal = false;
        if (Globals.checkRule("CLASSPRE")) {
            return 1;
        }
        Logging.errorPrint("PreClass on equipment: " + equipment.getName() + "  pre: " + this.toHtmlString(prereq));
        return 0;
    }

    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        if (Globals.checkRule("CLASSPRE")) {
            return 1;
        }
        boolean sumLevels = prereq.isTotalValues();
        String aString = prereq.getKey().toUpperCase();
        int preClass = Integer.parseInt(prereq.getOperand());
        if ("SPELLCASTER".equals(aString)) {
            if (character.isSpellCaster(preClass, sumLevels)) {
                runningTotal = preClass;
            }
        } else if (aString.startsWith("SPELLCASTER.")) {
            if (character.isSpellCaster(aString.substring(12), preClass, sumLevels)) {
                runningTotal = preClass;
            }
        } else {
            PCClass aClass = character.getClassNamed(aString);
            if (aClass != null) {
                runningTotal += aClass.getLevel();
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, preClass);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "CLASS";
    }

    public String toHtmlString(Prerequisite prereq) {
        String level = prereq.getOperand();
        String operator = prereq.getOperator().toDisplayString();
        return PropertyFactory.getFormattedString("PreClass.toHtml", prereq.getKey(), operator, level);
    }
}

