/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreDeityAlign
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        String deityAlign = character.getDeity() != null ? character.getDeity().getAlignment() : "";
        String desiredAlign = prereq.getOperand();
        if (prereq.getOperator().equals(PrerequisiteComparator.EQ)) {
            runningTotal = deityAlign.equals(desiredAlign) ? 1 : 0;
        } else if (prereq.getOperator().equals(PrerequisiteComparator.NEQ)) {
            runningTotal = deityAlign.equals(desiredAlign) ? 0 : 1;
        } else {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreDeityAlign.error.invalid_comparator", prereq.toString()));
        }
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "DEITYALIGN";
    }

    public String toHtmlString(Prerequisite prereq) {
        return PropertyFactory.getFormattedString("PreDeityAlign.toHtml", prereq.getOperator().toDisplayString(), SettingsHandler.getGame().getShortAlignmentAtIndex(Integer.parseInt(prereq.getKey())));
    }
}

