/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreEquip
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int number;
        int runningTotal = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreFeat.error", prereq.toString()));
        }
        if (!character.getEquipmentList().isEmpty()) {
            String targetEquip = prereq.getKey();
            Iterator e1 = character.getEquipmentList().iterator();
            while (e1.hasNext()) {
                Equipment eq = (Equipment)e1.next();
                if (targetEquip.startsWith("TYPE=") || targetEquip.startsWith("TYPE.")) {
                    if (eq.getType().indexOf(targetEquip.substring(5).toUpperCase()) < 0 || !eq.isEquipped()) continue;
                    ++runningTotal;
                    break;
                }
                if (targetEquip.indexOf(37) >= 0) {
                    if (!eq.getName().startsWith(targetEquip.substring(0, targetEquip.indexOf(37))) || !eq.isEquipped()) continue;
                    ++runningTotal;
                    break;
                }
                if (!eq.getName().equalsIgnoreCase(targetEquip) || !eq.isEquipped()) continue;
                ++runningTotal;
                break;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "EQUIP";
    }
}

