/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.spell.Spell;
import pcgen.util.PropertyFactory;

public class PreFeat
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        PlayerCharacter aPC = Globals.getCurrentPC();
        if (aPC == null) {
            return 0;
        }
        return this.passes(prereq, aPC);
    }

    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        List aFeatList;
        boolean subKeyIsType;
        int number;
        if (Globals.checkRule("FEATPRE")) {
            return 1;
        }
        boolean countMults = prereq.isCountMultiples();
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreFeat.error", prereq.toString()));
        }
        String key = prereq.getKey();
        String subKey = prereq.getSubKey();
        boolean keyIsType = key.startsWith("TYPE=") || key.startsWith("TYPE.");
        boolean bl = subKeyIsType = subKey != null && (subKey.startsWith("TYPE=") || subKey.startsWith("TYPE."));
        if (keyIsType) {
            key = key.substring(5);
        }
        if (subKeyIsType) {
            subKey = subKey.substring(5);
        }
        int runningTotal = 0;
        List list = aFeatList = character != null ? character.aggregateFeatList() : null;
        if (aFeatList != null && !aFeatList.isEmpty()) {
            Iterator e1 = aFeatList.iterator();
            block2: while (e1.hasNext()) {
                Feat aFeat = (Feat)e1.next();
                String featName = aFeat.getName();
                if (!keyIsType && featName.equalsIgnoreCase(key) || keyIsType && aFeat.isType(key)) {
                    if (subKey != null) {
                        String cType = subKey;
                        ArrayList availableList = new ArrayList();
                        ArrayList selectedList = new ArrayList();
                        String aChoiceString = aFeat.getChoiceString();
                        PObject.modChoices(aFeat, availableList, selectedList, false, character);
                        availableList.clear();
                        if (subKeyIsType) {
                            if (aChoiceString.startsWith("SKILL")) {
                                runningTotal = this.subKeySkill(countMults, runningTotal, cType, selectedList);
                                continue;
                            }
                            if (aChoiceString.startsWith("WEAPONPROFS")) {
                                runningTotal = this.subKeyWeaponProf(countMults, runningTotal, cType, selectedList);
                                continue;
                            }
                            if (aChoiceString.startsWith("DOMAIN")) {
                                runningTotal = this.subKeyDomain(countMults, runningTotal, cType, selectedList);
                                continue;
                            }
                            if (!aChoiceString.startsWith("SPELL")) continue;
                            runningTotal = this.subKeySpell(countMults, runningTotal, cType, selectedList);
                            continue;
                        }
                        if (featName.equalsIgnoreCase(key) && aFeat.containsAssociated(subKey)) {
                            ++runningTotal;
                            if (!aFeat.isMultiples() || !countMults) continue;
                            runningTotal += aFeat.getAssociatedCount() - 1;
                            continue;
                        }
                        int wildCardPos = subKey.indexOf(37);
                        if (wildCardPos <= -1) continue;
                        for (int k = 0; k < aFeat.getAssociatedCount(); ++k) {
                            String fString = aFeat.getAssociated(k).toUpperCase();
                            if (!fString.startsWith(subKey.substring(0, wildCardPos - 1).toUpperCase())) continue;
                            ++runningTotal;
                            if (!countMults) continue block2;
                        }
                        continue;
                    }
                    ++runningTotal;
                    if (!aFeat.isMultiples() || !countMults) continue;
                    runningTotal += aFeat.getAssociatedCount() - 1;
                    continue;
                }
                if (subKey == null) continue;
                String s1 = key + " (" + subKey + ")";
                String s2 = key + "(" + subKey + ")";
                if (!featName.equalsIgnoreCase(s1) && !aFeat.getName().equalsIgnoreCase(s2)) continue;
                ++runningTotal;
                if (countMults) continue;
                break;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    private int subKeySpell(boolean countMults, int runningTotal, String cType, List selectedList) {
        Iterator e = selectedList.iterator();
        while (e.hasNext()) {
            Object aObj = e.next();
            Spell sp = Globals.getSpellNamed(aObj.toString());
            if (sp == null || !sp.isType(cType)) continue;
            ++runningTotal;
            if (countMults) continue;
            break;
        }
        return runningTotal;
    }

    private int subKeyDomain(boolean countMults, int runningTotal, String cType, List selectedList) {
        Iterator e = selectedList.iterator();
        while (e.hasNext()) {
            Object aObj = e.next();
            Domain dom = Globals.getDomainKeyed(aObj.toString());
            if (dom == null || !dom.isType(cType)) continue;
            ++runningTotal;
            if (countMults) continue;
            break;
        }
        return runningTotal;
    }

    private int subKeyWeaponProf(boolean countMults, int runningTotal, String cType, List selectedList) {
        Iterator e = selectedList.iterator();
        while (e.hasNext()) {
            Equipment eq;
            Object aObj = e.next();
            WeaponProf wp = Globals.getWeaponProfNamed(aObj.toString());
            if (wp == null || (eq = EquipmentList.getEquipmentKeyed(wp.getKeyName())) == null || !eq.isType(cType)) continue;
            ++runningTotal;
            if (countMults) continue;
            break;
        }
        return runningTotal;
    }

    private int subKeySkill(boolean countMults, int runningTotal, String cType, List selectedList) {
        Iterator e = selectedList.iterator();
        while (e.hasNext()) {
            Object aObj = e.next();
            Skill sk = Globals.getSkillNamed(aObj.toString());
            if (sk == null || !sk.isType(cType)) continue;
            ++runningTotal;
            if (countMults) continue;
            break;
        }
        return runningTotal;
    }

    public String toHtmlString(Prerequisite prereq) {
        String string = prereq.getKey();
        if (prereq.getSubKey() != null && !prereq.getSubKey().equals("")) {
            string = string + " ( " + prereq.getSubKey() + " )";
        }
        return PropertyFactory.getFormattedString("PreFeat.toHtml", new Object[]{prereq.getKind(), string, prereq.getOperator().toDisplayString(), prereq.getOperand()});
    }

    public String kindHandled() {
        return "FEAT";
    }
}

