/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.utils.CoreUtility;
import pcgen.util.PropertyFactory;

public class PreItem
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int number;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException e) {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreItem.error.bad_operand", prereq.toString()));
        }
        int runningTotal = 0;
        if (!character.getEquipmentList().isEmpty()) {
            String aString = prereq.getKey();
            List typeList = null;
            if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                typeList = CoreUtility.split(aString.substring(5), '.');
            }
            Iterator e1 = character.getEquipmentList().iterator();
            while (e1.hasNext()) {
                Equipment eq = (Equipment)e1.next();
                if (typeList != null) {
                    boolean bMatches = true;
                    int x = typeList.size();
                    for (int i = 0; i < x; ++i) {
                        if (eq.isType((String)typeList.get(i))) continue;
                        bMatches = false;
                        break;
                    }
                    if (!bMatches) continue;
                    ++runningTotal;
                    continue;
                }
                if (aString.indexOf(37) >= 0) {
                    if (!eq.getName().toUpperCase().startsWith(aString.substring(0, aString.indexOf(37)))) continue;
                    ++runningTotal;
                    continue;
                }
                if (!eq.getName().equalsIgnoreCase(aString)) continue;
                ++runningTotal;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "ITEM";
    }
}

