/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreLanguage
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        String requiredLang = prereq.getKey();
        int requiredNumber = Integer.parseInt(prereq.getOperand());
        int runningTotal = 0;
        if (prereq.getKey().equalsIgnoreCase("ANY")) {
            runningTotal = character.getLanguagesList().size();
        } else {
            Language aLang = Globals.getLanguageNamed(requiredLang);
            if (aLang != null) {
                if (character.getLanguagesList().contains(aLang)) {
                    runningTotal = 1;
                }
            } else if (!requiredLang.equals("ANY")) {
                throw new PrerequisiteException(PropertyFactory.getFormattedString("PreLanguage.error.no_such_language", requiredLang));
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, requiredNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "LANG";
    }
}

