/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreMove
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        int moveAmount = 0;
        if (character == null || character.getRace() == null || character.getRace().getNumberOfMovementTypes() == 0) {
            runningTotal = 0;
        } else {
            String moveType = prereq.getKey();
            try {
                moveAmount = Integer.parseInt(prereq.getOperand());
            }
            catch (NumberFormatException e) {
                throw new PrerequisiteException(PropertyFactory.getFormattedString("PreMove.error.bad_operand", prereq.toString()));
            }
            for (int x = 0; x < character.getNumberOfMovements(); ++x) {
                String type = character.getMovementType(x);
                int speed = character.getMovement(x).intValue();
                if (!moveType.equalsIgnoreCase(type) || speed < moveAmount) continue;
                runningTotal += character.getMovement(x).intValue();
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, moveAmount);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "MOVE";
    }
}

