/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreMult
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = Integer.parseInt(prereq.getOperand());
        Iterator iter = prereq.getPrerequisites().iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test != null) {
                runningTotal += test.passes(element, character);
                continue;
            }
            Logging.errorPrintLocalised("PreMult.cannot_find_subtest", element.getKind());
        }
        runningTotal = prereq.getOperator().compare(runningTotal, targetNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "MULT";
    }

    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = Integer.parseInt(prereq.getOperand());
        Iterator iter = prereq.getPrerequisites().iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            runningTotal += test.passes(element, equipment);
        }
        runningTotal = prereq.getOperator().compare(runningTotal, targetNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    public String toHtmlString(Prerequisite prereq) {
        String str = "";
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        String delimiter = "";
        Iterator iter = prereq.getPrerequisites().iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null) {
                Logging.errorPrintLocalised("PreMult.cannot_find_subformatter", element.getKind());
                continue;
            }
            str = str + delimiter;
            str = str + test.toHtmlString(element);
            delimiter = PropertyFactory.getString("PreMult.html_delimiter");
        }
        return PropertyFactory.getFormattedString("PreMult.toHtml", new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), str});
    }
}

