/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;

public class PreRule
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public String kindHandled() {
        return "RULE";
    }

    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = 1;
        try {
            targetNumber = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException ne) {
            targetNumber = 1;
        }
        if (Globals.checkRule(prereq.getKey())) {
            runningTotal = 1;
        }
        Iterator e = prereq.getPrerequisites().iterator();
        while (e.hasNext()) {
            Prerequisite element = (Prerequisite)e.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null) continue;
            runningTotal += test.passes(element, equipment);
        }
        return this.countedTotal(prereq, prereq.getOperator().compare(runningTotal, targetNumber));
    }

    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        int targetNumber = 1;
        try {
            targetNumber = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException ne) {
            targetNumber = 1;
        }
        if (Globals.checkRule(prereq.getKey())) {
            runningTotal = 1;
        }
        Iterator e = prereq.getPrerequisites().iterator();
        while (e.hasNext()) {
            Prerequisite element = (Prerequisite)e.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null) continue;
            runningTotal += test.passes(element, character);
        }
        return this.countedTotal(prereq, prereq.getOperator().compare(runningTotal, targetNumber));
    }
}

