/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.Iterator;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreSkill
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        boolean isType;
        int requiredRanks = Integer.parseInt(prereq.getOperand());
        String requiredSkillName = prereq.getKey().toUpperCase();
        if (prereq.getSubKey() != null) {
            requiredSkillName = requiredSkillName + " (" + prereq.getSubKey() + ")";
        }
        boolean bl = isType = requiredSkillName.startsWith("TYPE.") || requiredSkillName.startsWith("TYPE=");
        if (isType) {
            requiredSkillName = requiredSkillName.substring(5).toUpperCase();
        }
        String skillName = requiredSkillName.toUpperCase();
        int percentageSignPosition = skillName.lastIndexOf(37);
        int runningTotal = 0;
        boolean foundMatch = false;
        ArrayList sList = (ArrayList)character.getSkillList().clone();
        Iterator e1 = sList.iterator();
        while (e1.hasNext() && !foundMatch) {
            Skill aSkill = (Skill)e1.next();
            String aSkillName = aSkill.getName().toUpperCase();
            if (isType) {
                if (percentageSignPosition >= 0) {
                    int maxCount = aSkill.getMyTypeCount();
                    for (int k = 0; k < maxCount && !foundMatch; ++k) {
                        if (!aSkill.getMyType(k).startsWith(skillName.substring(0, percentageSignPosition))) continue;
                        foundMatch = true;
                    }
                } else if (aSkill.isType(skillName)) {
                    foundMatch = true;
                }
                if (foundMatch) {
                    if (prereq.isTotalValues()) {
                        runningTotal += aSkill.getTotalRank(character).intValue();
                    } else if (prereq.getOperator().compare(aSkill.getTotalRank(character).intValue(), requiredRanks) > 0) {
                        ++runningTotal;
                    }
                    if (runningTotal == 0) {
                        foundMatch = false;
                    }
                }
            } else if (aSkillName.equals(skillName) || percentageSignPosition >= 0 && aSkillName.startsWith(skillName.substring(0, percentageSignPosition))) {
                if (prereq.isTotalValues()) {
                    runningTotal += aSkill.getTotalRank(character).intValue();
                } else if (prereq.getOperator().compare(aSkill.getTotalRank(character).intValue(), requiredRanks) > 0) {
                    ++runningTotal;
                }
                if (runningTotal > 0) {
                    foundMatch = true;
                }
            }
            if (!prereq.isCountMultiples() && !prereq.isTotalValues()) continue;
            foundMatch = false;
        }
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "SKILL";
    }

    public String toHtmlString(Prerequisite prereq) {
        String skillName = prereq.getKey();
        if (prereq.getSubKey() != null && !prereq.getSubKey().equals("")) {
            skillName = skillName + " (" + prereq.getSubKey() + ")";
        }
        String foo = PropertyFactory.getFormattedString("PreSkill.toHtml", new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), skillName});
        return foo;
    }
}

