/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import java.util.List;
import pcgen.core.CharacterDomain;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreSpell
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int requiredNumber = 0;
        try {
            requiredNumber = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException e) {
            Logging.errorPrint(PropertyFactory.getString("PreSpell.error.badly_formed_attribute") + prereq.toString());
        }
        List aArrayList = character.aggregateSpellList("Any", "", "", "", 0, 20);
        Iterator domains = character.getCharacterDomainList().iterator();
        while (domains.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)domains.next();
            if (aCD == null || aCD.getDomain() == null) continue;
            aArrayList.addAll(Globals.getSpellsIn(-1, "", aCD.getDomain().toString()));
        }
        String spellName = prereq.getKey();
        int runningTotal = 0;
        if (!aArrayList.isEmpty()) {
            Iterator e1 = aArrayList.iterator();
            while (e1.hasNext()) {
                Spell aSpell = (Spell)e1.next();
                if (!aSpell.getName().equalsIgnoreCase(spellName)) continue;
                ++runningTotal;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, requiredNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "SPELL";
    }

    public String toHtmlString(Prerequisite prereq) {
        Object[] args = new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), prereq.getKey()};
        return PropertyFactory.getFormattedString("PreSpell.toHtml", args);
    }
}

