/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.Iterator;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreSpellCastMemorize
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public String kindHandled() {
        return "spellcast.memorize";
    }

    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int requiredNumber = Integer.parseInt(prereq.getOperand());
        boolean prereqMemorized = prereq.getKey().toUpperCase().startsWith("Y");
        int runningTotal = 0;
        ArrayList classList = (ArrayList)character.getClassList().clone();
        if (!classList.isEmpty()) {
            Iterator e1 = classList.iterator();
            while (e1.hasNext()) {
                PCClass aClass = (PCClass)e1.next();
                boolean classMemorized = aClass.getMemorizeSpells();
                if (classMemorized != prereqMemorized) continue;
                ++runningTotal;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, requiredNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    public String toHtmlString(Prerequisite prereq) {
        boolean prereqMemorized = prereq.getKey().toUpperCase().startsWith("Y");
        if (prereqMemorized) {
            return PropertyFactory.getFormattedString("PreSpellCastMemorize.toHtml_does_memorise", prereq.getOperator().toDisplayString());
        }
        return PropertyFactory.getFormattedString("PreSpellCastMemorize.toHtml_does_not_memorise", prereq.getOperator().toDisplayString());
    }
}

