/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.List;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreSpellType
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        String castingType = prereq.getKey();
        int requiredLevel = 1;
        int requiredNumber = 1;
        try {
            requiredLevel = Integer.parseInt(prereq.getSubKey());
        }
        catch (NumberFormatException e) {
            requiredLevel = 1;
            Logging.errorPrintLocalised("PreSpellType.Badly_formed_spell_type", prereq.getSubKey(), prereq.toString());
        }
        try {
            requiredNumber = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException e) {
            requiredNumber = 1;
            Logging.errorPrintLocalised("PreSpellType.Badly_formed_spell_type", prereq.getSubKey(), prereq.toString());
        }
        List aArrayList = character.aggregateSpellList(castingType, "", "", "", requiredLevel, 20);
        int runningTotal = prereq.getOperator().compare(aArrayList.size(), requiredNumber);
        if (runningTotal > 0 && !character.canCastSpellTypeLevel(castingType, requiredLevel, requiredNumber)) {
            runningTotal = 0;
        }
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "SPELL.TYPE";
    }

    public String toHtmlString(Prerequisite prereq) {
        return PropertyFactory.getFormattedString("PreSpellType.toHtml", new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), prereq.getKey(), prereq.getSubKey()});
    }
}

