/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreTemplate
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int number;
        int runningTotal = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreTemplate.error", prereq.toString()));
        }
        if (!character.getTemplateList().isEmpty()) {
            String templateName = prereq.getKey().toUpperCase();
            int wildCard = templateName.indexOf(37);
            if (wildCard >= 0) {
                templateName = templateName.substring(0, wildCard);
                Iterator ti = character.getTemplateList().iterator();
                while (ti.hasNext()) {
                    PCTemplate aTemplate = (PCTemplate)ti.next();
                    if (!aTemplate.getName().toUpperCase().startsWith(templateName)) continue;
                    ++runningTotal;
                }
            } else if (character.getTemplateNamed(templateName) != null) {
                ++runningTotal;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "TEMPLATE";
    }
}

