/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.PropertyFactory;

public class PreType
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public String kindHandled() {
        return "TYPE";
    }

    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        String requiredType = prereq.getKey();
        int runningTotal = 0;
        if (prereq.getOperator().equals(PrerequisiteComparator.EQ)) {
            if (equipment.isPreType(requiredType)) {
                ++runningTotal;
            }
        } else if (prereq.getOperator().equals(PrerequisiteComparator.NEQ)) {
            if (!equipment.isPreType(requiredType)) {
                ++runningTotal;
            }
        } else {
            throw new PrerequisiteException(PropertyFactory.getFormattedString("PreType.error.invalidComparison", prereq.getOperator().toString(), prereq.toString()));
        }
        runningTotal = this.countedTotal(prereq, runningTotal);
        return runningTotal;
    }

    public int passes(Prerequisite prereq, PlayerCharacter aPC) throws PrerequisiteException {
        if (aPC == null) {
            return 0;
        }
        String requiredType = prereq.getKey();
        int numRequired = Integer.parseInt(prereq.getOperand());
        int runningTotal = 0;
        List typeList = aPC.getTypes();
        Iterator iter = typeList.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (!element.equalsIgnoreCase(requiredType)) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, numRequired);
        return this.countedTotal(prereq, runningTotal);
    }

    public String toHtmlString(Prerequisite prereq) {
        return PropertyFactory.getFormattedString("PreType.toHtml", prereq.getOperator().toDisplayString(), prereq.getOperand());
    }
}

