/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PreUnarmedAttack
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int att = 0;
        if (!character.getClassList().isEmpty()) {
            Iterator e2 = character.getClassList().iterator();
            while (e2.hasNext()) {
                PCClass aClass = (PCClass)e2.next();
                String s = aClass.getUattForLevel(aClass.getLevel());
                if (s.length() == 0 || "0".equals(s)) {
                    att = Math.max(att, aClass.baseAttackBonus(character));
                    continue;
                }
                StringTokenizer bTok = new StringTokenizer(s, ",");
                s = bTok.nextToken();
                try {
                    att = Math.max(att, Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    Logging.errorPrint(PropertyFactory.getFormattedString("PreUnarmedAttack.error.bad_operand", s));
                }
            }
        }
        int requiredValue = Integer.parseInt(prereq.getOperand());
        int runningTotal = prereq.getOperator().compare(att, requiredValue);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "UATT";
    }

    public String toHtmlString(Prerequisite prereq) {
        return PropertyFactory.getFormattedString("PreUnarmedAttack.toHtml", prereq.getOperator().toString(), prereq.getOperand());
    }
}

