/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.core.utils.CoreUtility;

public class PreVariable
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public String kindHandled() {
        return "VAR";
    }

    public int passes(Prerequisite prereq, Equipment equipment) throws PrerequisiteException {
        PlayerCharacter aPC = Globals.getCurrentPC();
        if (aPC == null) {
            return 0;
        }
        String eqVar = "EQ:" + equipment.profName(0, aPC);
        float aVar = equipment.getVariableValue(prereq.getKey(), eqVar, "", aPC).floatValue();
        float aTarget = equipment.getVariableValue(prereq.getOperand(), eqVar, "", aPC).floatValue();
        float runningTotal = prereq.getOperator().compare(aVar, aTarget);
        if (CoreUtility.doublesEqual(runningTotal, 0.0)) {
            return 0;
        }
        Iterator e = prereq.getPrerequisites().iterator();
        while (e.hasNext()) {
            Prerequisite element = (Prerequisite)e.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null || !CoreUtility.doublesEqual(runningTotal = (float)test.passes(element, equipment), 0.0)) continue;
            return 0;
        }
        return this.countedTotal(prereq, (int)runningTotal);
    }

    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        float aVar = character.getVariableValue(prereq.getKey(), "").floatValue();
        float aTarget = character.getVariableValue(prereq.getOperand(), "").floatValue();
        float runningTotal = prereq.getOperator().compare(aVar, aTarget);
        if (CoreUtility.doublesEqual(runningTotal, 0.0)) {
            return 0;
        }
        Iterator e = prereq.getPrerequisites().iterator();
        while (e.hasNext()) {
            Prerequisite element = (Prerequisite)e.next();
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null || !CoreUtility.doublesEqual(runningTotal = (float)test.passes(element, character), 0.0)) continue;
            return 0;
        }
        return this.countedTotal(prereq, (int)runningTotal);
    }
}

