/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.utils.CoreUtility;

public class PreWeaponProficiency
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character) throws PrerequisiteException {
        int runningTotal = 0;
        String aString = prereq.getKey();
        if ("DEITYWEAPON".equals(aString) && character.getDeity() != null) {
            Iterator weapIter = CoreUtility.split(character.getDeity().getFavoredWeapon(), '|').iterator();
            while (weapIter.hasNext()) {
                String weaponName = (String)weapIter.next();
                if (!character.hasWeaponProfNamed(weaponName)) continue;
                ++runningTotal;
            }
        } else if (aString.startsWith("TYPE.") || aString.startsWith("TYPE=")) {
            String requiredType = aString.substring(5);
            Iterator e = character.getWeaponProfList().iterator();
            while (e.hasNext()) {
                String profName = (String)e.next();
                WeaponProf wp = Globals.getWeaponProfNamed(profName);
                if (wp == null) continue;
                if (wp.isType(requiredType)) {
                    ++runningTotal;
                    continue;
                }
                Equipment eq = EquipmentList.getEquipmentNamed(profName);
                if (eq == null || !eq.isType(requiredType)) continue;
                ++runningTotal;
            }
        } else if (character.hasWeaponProfNamed(aString)) {
            ++runningTotal;
        }
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "WEAPONPROF";
    }
}

