/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Iterator;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PrereqHandler {
    public static boolean passesAll(List prereqList, PlayerCharacter character, PObject caller) {
        if (prereqList == null) {
            return true;
        }
        if (caller instanceof PCClass && Globals.checkRule("CLASSPRE")) {
            return true;
        }
        if (caller instanceof Feat && Globals.checkRule("FEATPRE")) {
            return true;
        }
        if (character != null && caller != null && character.checkQualifyList(caller.getName())) {
            return true;
        }
        Iterator iter = prereqList.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            Prerequisite prereq = null;
            if (object instanceof String) {
                String oString = (String)object;
                Logging.debugPrintLocalised(PropertyFactory.getString("PrereqHandler.Why_not_already_parsed"), object, "PrereqHandler.passesAll()");
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    prereq = factory.parse(oString);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                    return false;
                }
            } else {
                prereq = (Prerequisite)object;
            }
            if (PrereqHandler.passes(prereq, character, caller)) continue;
            return false;
        }
        return true;
    }

    public static boolean passesAll(List prereqList, Equipment equip) {
        if (prereqList == null) {
            return true;
        }
        Iterator iter = prereqList.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            Prerequisite prereq = null;
            if (object instanceof String) {
                Logging.debugPrintLocalised("PrereqHandler.Why_not_already_parsed", object, "PrereqHandler.passesAll()");
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    prereq = factory.parse((String)object);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                    return false;
                }
            } else {
                prereq = (Prerequisite)object;
            }
            if (PrereqHandler.passes(prereq, equip)) continue;
            return false;
        }
        return true;
    }

    public static boolean passesAtLeastOne(List prereqList, PlayerCharacter character, PObject caller) {
        if (prereqList == null) {
            return true;
        }
        Iterator iter = prereqList.iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            if (!PrereqHandler.passes(element, character, caller)) continue;
            return true;
        }
        return false;
    }

    public static boolean passesAtLeastOne(List prereqList, Equipment equip) {
        if (prereqList == null) {
            return true;
        }
        Iterator iter = prereqList.iterator();
        while (iter.hasNext()) {
            Prerequisite element = (Prerequisite)iter.next();
            if (!PrereqHandler.passes(element, equip)) continue;
            return true;
        }
        return false;
    }

    public static boolean passes(Prerequisite prereq, PlayerCharacter character, PObject caller) {
        if (character == null) {
            return true;
        }
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        PrerequisiteTest test = factory.getTest(prereq.getKind());
        if (prereq.getLevelQualifier() >= 0 && caller instanceof PCClass && ((PCClass)caller).getLevel() != prereq.getLevelQualifier()) {
            return true;
        }
        if (test == null) {
            Logging.errorPrintLocalised("PrereqHandler.Unable_to_find_implementation", prereq.toString());
            return false;
        }
        boolean overrideQualify = prereq.isOverrideQualify();
        boolean autoQualifies = false;
        int total = 0;
        if (caller != null && character.checkQualifyList(caller.getName()) && !overrideQualify) {
            autoQualifies = true;
        }
        if (autoQualifies) {
            return true;
        }
        try {
            total = test.passes(prereq, character);
        }
        catch (PrerequisiteException pe) {
            Logging.errorPrintLocalised("PrereqHandler.Exception_in_test", pe);
        }
        return total > 0;
    }

    public static boolean passes(Prerequisite prereqList, Equipment equip) {
        if (equip == null) {
            return true;
        }
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        PrerequisiteTest test = factory.getTest(prereqList.getKind());
        if (test == null) {
            Logging.errorPrintLocalised("PrereqHandler.Unable_to_find_implementation", prereqList.toString());
            return false;
        }
        int total = 0;
        try {
            total = test.passes(prereqList, equip);
        }
        catch (PrerequisiteException pe) {
            Logging.errorPrintLocalised("PrereqHandler.Exception_in_test", pe);
        }
        return total > 0;
    }

    public static final String toHtmlString(List anArrayList) {
        if (anArrayList == null || anArrayList.isEmpty()) {
            return "";
        }
        try {
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PreParserFactory pfactory = PreParserFactory.getInstance();
            StringBuffer pString = new StringBuffer(anArrayList.size() * 20);
            String delimiter = "";
            Iterator e = anArrayList.iterator();
            while (e.hasNext()) {
                Object obj = e.next();
                Prerequisite prereq = obj instanceof String ? pfactory.parse((String)obj) : (Prerequisite)obj;
                PrerequisiteTest preHtml = factory.getTest(prereq.getKind());
                if (preHtml == null) {
                    Logging.errorPrintLocalised("PrereqHandler.No_known_formatter", prereq.getKind());
                    continue;
                }
                pString.append(delimiter);
                if (prereq.getLevelQualifier() > 0) {
                    pString.append("at level " + prereq.getLevelQualifier() + ":");
                }
                pString.append(preHtml.toHtmlString(prereq));
                delimiter = PropertyFactory.getString("PrereqHandler.HTML_prerequisite_delimiter");
            }
            return pString.toString();
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint(ple.getMessage(), ple);
            return "";
        }
    }
}

