/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.utils.CoreUtility;
import pcgen.util.PropertyFactory;

public class Prerequisite
implements Cloneable {
    public static final String CLEAR_KIND = "clear";
    private String kind;
    private String key = null;
    private String subKey = null;
    private List prerequisites = new ArrayList();
    private PrerequisiteOperator operator = new PrerequisiteOperator(PrerequisiteComparator.GTEQ);
    private String operand = "1";
    private boolean totalValues;
    private boolean countMultiples;
    private boolean overrideQualify = false;
    private int levelQualifier = -1;

    public Prerequisite() {
    }

    public Prerequisite(Prerequisite that) {
        this.kind = that.kind;
        this.key = that.key;
        this.subKey = that.subKey;
        this.operator = that.operator;
        this.operand = that.operand;
        this.countMultiples = that.countMultiples;
        this.levelQualifier = that.levelQualifier;
        if (that.prerequisites != null) {
            Iterator itr = that.prerequisites.iterator();
            while (itr.hasNext()) {
                Prerequisite foo = (Prerequisite)itr.next();
                this.addPrerequisite(new Prerequisite(foo));
            }
        }
    }

    public final boolean isTotalValues() {
        return this.totalValues;
    }

    public final void setTotalValues(boolean totalValues) {
        this.totalValues = totalValues;
    }

    public void setCountMultiples(boolean countMultiples) {
        this.countMultiples = countMultiples;
    }

    public boolean isCountMultiples() {
        return this.countMultiples;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getKind() {
        return this.kind;
    }

    public void setOperand(String operand) {
        this.operand = operand;
    }

    public String getOperand() {
        return this.operand;
    }

    public void setOperator(String operator) throws PrerequisiteException {
        this.operator = new PrerequisiteOperator(operator);
    }

    public void setOperator(PrerequisiteComparator comparator) {
        this.operator = new PrerequisiteOperator(comparator);
    }

    public PrerequisiteOperator getOperator() {
        return this.operator;
    }

    public void setPrerequisites(List prerequisites) {
        this.prerequisites = prerequisites;
    }

    public void addPrerequisite(Prerequisite prereq) {
        this.prerequisites.add(prereq);
    }

    public List getPrerequisites() {
        return this.prerequisites;
    }

    public void setSubKey(String subKey) {
        this.subKey = subKey;
    }

    public String getSubKey() {
        return this.subKey;
    }

    public void setOperator(PrerequisiteOperator operator) {
        this.operator = operator;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(PropertyFactory.getString("Prerequisite.prereq_tag"));
        buf.append(" ");
        if (this.kind != null) {
            buf.append(PropertyFactory.getString("Prerequisite.kind"));
            buf.append("=\"");
            buf.append(this.kind);
            buf.append("\" ");
        }
        if (this.countMultiples) {
            buf.append(PropertyFactory.getString("Prerequisite.count-multiples"));
        }
        if (this.totalValues) {
            buf.append(PropertyFactory.getString("Prerequisite.total-values"));
        }
        if (this.key != null) {
            buf.append(PropertyFactory.getString("Prerequisite.key"));
            buf.append("=\"");
            buf.append(this.key);
            buf.append("\" ");
        }
        if (this.subKey != null && !this.subKey.equals("")) {
            buf.append(PropertyFactory.getString("Prerequisite.sub-key"));
            buf.append("=\"");
            buf.append(this.subKey);
            buf.append("\" ");
        }
        buf.append(PropertyFactory.getString("Prerequisite.operator"));
        buf.append("=\"");
        buf.append(this.operator);
        buf.append("\" ");
        if (this.operand != null) {
            buf.append(PropertyFactory.getString("Prerequisite.operand"));
            buf.append("=\"");
            buf.append(this.operand);
            buf.append("\" ");
        }
        buf.append(">\n");
        if (this.prerequisites.size() > 0) {
            Iterator iter = this.prerequisites.iterator();
            while (iter.hasNext()) {
                Prerequisite element = (Prerequisite)iter.next();
                buf.append(element.toString());
            }
        }
        buf.append("</");
        buf.append(PropertyFactory.getString("Prerequisite.prereq_tag"));
        buf.append(">\n");
        return buf.toString();
    }

    public boolean isOverrideQualify() {
        return this.overrideQualify;
    }

    public void setOverrideQualify(boolean overrideQualify) {
        this.overrideQualify = overrideQualify;
    }

    public Object clone() throws CloneNotSupportedException {
        Prerequisite copy = (Prerequisite)super.clone();
        if (this.prerequisites != null) {
            copy.prerequisites = new ArrayList();
            Iterator iter = this.prerequisites.iterator();
            while (iter.hasNext()) {
                Prerequisite subreq = (Prerequisite)iter.next();
                copy.prerequisites.add((Prerequisite)subreq.clone());
            }
        }
        return copy;
    }

    public void expandToken(String token, String tokenValue) {
        this.key = CoreUtility.replaceAll(this.key, token, tokenValue);
        this.operand = CoreUtility.replaceAll(this.operand, token, tokenValue);
        if (this.prerequisites != null) {
            Iterator iter = this.prerequisites.iterator();
            while (iter.hasNext()) {
                Prerequisite subreq = (Prerequisite)iter.next();
                subreq.expandToken(token, tokenValue);
            }
        }
    }

    public String getDescription(boolean shortForm) {
        StringBuffer buf = new StringBuffer();
        if (this.levelQualifier > 0 && !shortForm) {
            buf.append("at level ");
            buf.append(this.levelQualifier + ":");
            buf.append(' ');
        }
        if (this.kind != null && !shortForm) {
            buf.append(this.kind);
            buf.append(' ');
        }
        if (this.key != null) {
            buf.append(this.key);
            if (!shortForm) {
                buf.append(' ');
            }
        }
        if (this.subKey != null && !this.subKey.equals("")) {
            buf.append('(');
            buf.append(this.subKey);
            buf.append(')');
            if (!shortForm) {
                buf.append(' ');
            }
        }
        if (!shortForm) {
            buf.append(this.operator);
            buf.append(' ');
        }
        if (this.operand != null && !shortForm) {
            buf.append(this.operand);
        }
        if (this.prerequisites.size() > 0 && !shortForm) {
            buf.append(" (");
            Iterator iter = this.prerequisites.iterator();
            while (iter.hasNext()) {
                Prerequisite element = (Prerequisite)iter.next();
                buf.append(element.getDescription(shortForm));
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public int getLevelQualifier() {
        return this.levelQualifier;
    }

    public void setLevelQualifier(int qualifier) {
        this.levelQualifier = qualifier;
    }
}

