/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.utils.CoreUtility;
import pcgen.util.PropertyFactory;

public class PrerequisiteOperator {
    private PrerequisiteComparator value = PrerequisiteComparator.GTEQ;

    public PrerequisiteOperator(String operator) throws PrerequisiteException {
        this.value = this.getComparisonType(operator);
    }

    public PrerequisiteOperator(PrerequisiteComparator operator) {
        this.value = operator;
    }

    public PrerequisiteOperator invert() {
        PrerequisiteComparator comp = PrerequisiteComparator.LT;
        if (this.value.equals(PrerequisiteComparator.EQ)) {
            comp = PrerequisiteComparator.NEQ;
        } else if (this.value.equals(PrerequisiteComparator.LT)) {
            comp = PrerequisiteComparator.GTEQ;
        } else if (this.value.equals(PrerequisiteComparator.LTEQ)) {
            comp = PrerequisiteComparator.GT;
        } else if (this.value.equals(PrerequisiteComparator.GT)) {
            comp = PrerequisiteComparator.LTEQ;
        } else if (this.value.equals(PrerequisiteComparator.GTEQ)) {
            comp = PrerequisiteComparator.LT;
        } else if (this.value.equals(PrerequisiteComparator.NEQ)) {
            comp = PrerequisiteComparator.EQ;
        }
        return new PrerequisiteOperator(comp);
    }

    public String toString() {
        return this.value.toString();
    }

    public String toDisplayString() {
        String comp = null;
        if (this.value.equals(PrerequisiteComparator.EQ)) {
            comp = PropertyFactory.getString("PrerequisiteOperator.display.eq");
        } else if (this.value.equals(PrerequisiteComparator.LT)) {
            comp = PropertyFactory.getString("PrerequisiteOperator.display.lt");
        } else if (this.value.equals(PrerequisiteComparator.LTEQ)) {
            comp = PropertyFactory.getString("PrerequisiteOperator.display.lteq");
        } else if (this.value.equals(PrerequisiteComparator.GT)) {
            comp = PropertyFactory.getString("PrerequisiteOperator.display.gt");
        } else if (this.value.equals(PrerequisiteComparator.GTEQ)) {
            comp = PropertyFactory.getString("PrerequisiteOperator.display.gteq");
        } else if (this.value.equals(PrerequisiteComparator.NEQ)) {
            comp = PropertyFactory.getString("PrerequisiteOperator.display.neq");
        }
        return comp;
    }

    private final PrerequisiteComparator getComparisonType(String aString) throws PrerequisiteException {
        if ("EQ".equalsIgnoreCase(aString) || "=".equals(aString)) {
            return PrerequisiteComparator.EQ;
        }
        if ("LT".equalsIgnoreCase(aString) || "<".equals(aString)) {
            return PrerequisiteComparator.LT;
        }
        if ("LTEQ".equalsIgnoreCase(aString) || "<=".equals(aString)) {
            return PrerequisiteComparator.LTEQ;
        }
        if ("GT".equalsIgnoreCase(aString) || ">".equals(aString)) {
            return PrerequisiteComparator.GT;
        }
        if ("GTEQ".equalsIgnoreCase(aString) || ">=".equals(aString)) {
            return PrerequisiteComparator.GTEQ;
        }
        if ("NEQ".equalsIgnoreCase(aString) || "!=".equals(aString)) {
            return PrerequisiteComparator.NEQ;
        }
        throw new PrerequisiteException(PropertyFactory.getFormattedString("PrerequisiteOperator.error.invalid_operator", aString));
    }

    public int compare(int leftHandOp, int rightHandOp) {
        return (int)this.compare((float)leftHandOp, (float)rightHandOp);
    }

    public float compare(float leftHandOp, float rightHandOp) {
        boolean passes = false;
        if (this.value.equals(PrerequisiteComparator.EQ)) {
            passes = CoreUtility.doublesEqual(leftHandOp, rightHandOp);
        } else if (this.value.equals(PrerequisiteComparator.LT)) {
            passes = leftHandOp < rightHandOp;
        } else if (this.value.equals(PrerequisiteComparator.LTEQ)) {
            passes = leftHandOp <= rightHandOp;
        } else if (this.value.equals(PrerequisiteComparator.GT)) {
            passes = leftHandOp > rightHandOp;
        } else if (this.value.equals(PrerequisiteComparator.GTEQ)) {
            passes = leftHandOp >= rightHandOp;
        } else if (this.value.equals(PrerequisiteComparator.NEQ)) {
            boolean bl = passes = !CoreUtility.doublesEqual(leftHandOp, rightHandOp);
        }
        if (passes) {
            if (CoreUtility.doublesEqual(leftHandOp, 0.0)) {
                return 1.0f;
            }
            return leftHandOp;
        }
        return 0.0f;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrerequisiteOperator) {
            return this.value.equals(((PrerequisiteOperator)obj).value);
        }
        if (obj instanceof PrerequisiteComparator) {
            return this.value.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

