/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.HashMap;
import java.util.Map;
import pcgen.core.prereq.PreAlign;
import pcgen.core.prereq.PreApply;
import pcgen.core.prereq.PreArmorProficiency;
import pcgen.core.prereq.PreArmorType;
import pcgen.core.prereq.PreAttack;
import pcgen.core.prereq.PreBaseSize;
import pcgen.core.prereq.PreBirthPlace;
import pcgen.core.prereq.PreCheck;
import pcgen.core.prereq.PreCheckBase;
import pcgen.core.prereq.PreCity;
import pcgen.core.prereq.PreClass;
import pcgen.core.prereq.PreDamageReduction;
import pcgen.core.prereq.PreDefaultMonster;
import pcgen.core.prereq.PreDeity;
import pcgen.core.prereq.PreDeityAlign;
import pcgen.core.prereq.PreDeityDomain;
import pcgen.core.prereq.PreDomain;
import pcgen.core.prereq.PreEquip;
import pcgen.core.prereq.PreEquippedBoth;
import pcgen.core.prereq.PreEquippedPrimary;
import pcgen.core.prereq.PreEquippedSecondary;
import pcgen.core.prereq.PreEquippedTwoWeapon;
import pcgen.core.prereq.PreFeat;
import pcgen.core.prereq.PreGender;
import pcgen.core.prereq.PreHD;
import pcgen.core.prereq.PreHP;
import pcgen.core.prereq.PreHands;
import pcgen.core.prereq.PreHasDeity;
import pcgen.core.prereq.PreItem;
import pcgen.core.prereq.PreLanguage;
import pcgen.core.prereq.PreLegs;
import pcgen.core.prereq.PreLevel;
import pcgen.core.prereq.PreLevelMax;
import pcgen.core.prereq.PreMove;
import pcgen.core.prereq.PreMult;
import pcgen.core.prereq.PreRace;
import pcgen.core.prereq.PreRegion;
import pcgen.core.prereq.PreRule;
import pcgen.core.prereq.PreShieldProficiency;
import pcgen.core.prereq.PreSize;
import pcgen.core.prereq.PreSkill;
import pcgen.core.prereq.PreSkillMult;
import pcgen.core.prereq.PreSpecialAbility;
import pcgen.core.prereq.PreSpell;
import pcgen.core.prereq.PreSpellBook;
import pcgen.core.prereq.PreSpellCast;
import pcgen.core.prereq.PreSpellCastMemorize;
import pcgen.core.prereq.PreSpellDescriptor;
import pcgen.core.prereq.PreSpellResistance;
import pcgen.core.prereq.PreSpellSchool;
import pcgen.core.prereq.PreSpellSchoolSub;
import pcgen.core.prereq.PreSpellType;
import pcgen.core.prereq.PreStat;
import pcgen.core.prereq.PreSubClass;
import pcgen.core.prereq.PreTemplate;
import pcgen.core.prereq.PreText;
import pcgen.core.prereq.PreType;
import pcgen.core.prereq.PreUnarmedAttack;
import pcgen.core.prereq.PreVariable;
import pcgen.core.prereq.PreVision;
import pcgen.core.prereq.PreWeaponProficiency;
import pcgen.core.prereq.PreWield;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PrerequisiteTestFactory {
    private static PrerequisiteTestFactory instance = null;
    private static Map testLookup = new HashMap();

    public static PrerequisiteTestFactory getInstance() {
        if (instance == null) {
            instance = new PrerequisiteTestFactory();
        }
        return instance;
    }

    private PrerequisiteTestFactory() {
        this.register(new PreAlign());
        this.register(new PreApply());
        this.register(new PreArmorProficiency());
        this.register(new PreArmorType());
        this.register(new PreAttack());
        this.register(new PreBaseSize());
        this.register(new PreBirthPlace());
        this.register(new PreCity());
        this.register(new PreCheck());
        this.register(new PreCheckBase());
        this.register(new PreClass());
        this.register(new PreDamageReduction());
        this.register(new PreDefaultMonster());
        this.register(new PreDeity());
        this.register(new PreDeityAlign());
        this.register(new PreDeityDomain());
        this.register(new PreDomain());
        this.register(new PreEquip());
        this.register(new PreEquippedBoth());
        this.register(new PreEquippedPrimary());
        this.register(new PreEquippedSecondary());
        this.register(new PreEquippedTwoWeapon());
        this.register(new PreFeat());
        this.register(new PreGender());
        this.register(new PreHands());
        this.register(new PreHasDeity());
        this.register(new PreHD());
        this.register(new PreHP());
        this.register(new PreItem());
        this.register(new PreLanguage());
        this.register(new PreLegs());
        this.register(new PreLevel());
        this.register(new PreLevelMax());
        this.register(new PreMove());
        this.register(new PreRace());
        this.register(new PreRegion());
        this.register(new PreRule());
        this.register(new PreShieldProficiency());
        this.register(new PreSize());
        this.register(new PreSkill());
        this.register(new PreSkillMult());
        this.register(new PreSpell());
        this.register(new PreSpecialAbility());
        this.register(new PreSpellBook());
        this.register(new PreSpellCast());
        this.register(new PreSpellCastMemorize());
        this.register(new PreSpellResistance());
        this.register(new PreSpellSchool());
        this.register(new PreSpellSchoolSub());
        this.register(new PreSpellDescriptor());
        this.register(new PreSpellType());
        this.register(new PreStat());
        this.register(new PreSubClass());
        this.register(new PreTemplate());
        this.register(new PreText());
        this.register(new PreType());
        this.register(new PreUnarmedAttack());
        this.register(new PreVariable());
        this.register(new PreVision());
        this.register(new PreWield());
        this.register(new PreWeaponProficiency());
    }

    private void register(PrerequisiteTest testClass) {
        String kindHandled = testClass.kindHandled();
        Object test = testLookup.get(kindHandled);
        if (test != null) {
            Logging.errorPrint(PropertyFactory.getFormattedString("PrerequisiteTestFactory.error.already_registered", testClass.getClass().getName(), kindHandled, test.getClass().getName()));
        }
        testLookup.put(kindHandled.toUpperCase(), testClass);
    }

    public PrerequisiteTest getTest(String kind) {
        PrerequisiteTest test = null;
        if (kind == null) {
            test = new PreMult();
        } else {
            test = (PrerequisiteTest)testLookup.get(kind.toUpperCase());
            if (test == null) {
                Logging.errorPrintLocalised("PrerequisiteTestFactory.error.cannot_find_test", kind);
            }
        }
        return test;
    }
}

