/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.spell;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

public final class Spell
extends PObject {
    private BigDecimal cost = BigDecimalHelper.ZERO;
    private HashMap levelInfo = null;
    private List descriptorList = new ArrayList();
    private List variantList = null;
    private Map preReqMap = null;
    private SortedSet castingTime = new TreeSet();
    private SortedSet componentList = new TreeSet();
    private SortedSet duration = new TreeSet();
    private SortedSet range = new TreeSet();
    private SortedSet saveInfo = new TreeSet();
    private SortedSet school = new TreeSet();
    private SortedSet spellResistance = new TreeSet();
    private SortedSet subschool = new TreeSet();
    private String creatableItem = "";
    private String spellStat = "";
    private String target = "";
    private int castingThreshold = 0;
    private int xpCost = 0;

    public void setCastingThreshold(int arg) {
        this.castingThreshold = arg;
    }

    public int getCastingThreshold() {
        return this.castingThreshold;
    }

    public void setCastingTime(String aString) {
        if (aString.equals(".CLEAR")) {
            this.castingTime.clear();
        } else if (aString.length() != 0) {
            this.castingTime.add(aString);
            Globals.addSpellCastingTimesSet(aString);
        }
    }

    public String getCastingTime() {
        String s = this.castingTime.toString();
        return s.substring(1, s.length() - 1);
    }

    public void setComponentList(String aString) {
        if (aString.equals(".CLEAR")) {
            this.castingTime.clear();
        } else if (aString.length() != 0) {
            this.componentList.add(aString);
            Globals.addSpellComponentSet(aString);
        }
    }

    public String getComponentList() {
        String s = this.componentList.toString();
        return s.substring(1, s.length() - 1);
    }

    public void setCost(String aString) {
        try {
            this.cost = new BigDecimal(aString);
        }
        catch (NumberFormatException ignore) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCreatableItem(String creatableItem) {
        this.creatableItem = creatableItem;
    }

    public String getCreatableItem() {
        return this.creatableItem;
    }

    public int getDCForPlayerCharacter(PlayerCharacter aPC, SpellInfo si) {
        return this.getDCForPlayerCharacter(aPC, si, null, 0);
    }

    public int getDCForPlayerCharacter(PlayerCharacter aPC, SpellInfo si, PCClass aClass, int inLevel) {
        String aType;
        String statName;
        CharacterSpell cs = null;
        PObject ow = null;
        int spellLevel = inLevel;
        String bonDomain = "";
        String bonClass = "";
        String spellType = "";
        String aClassName = "";
        int metaDC = 0;
        int spellIndex = 0;
        if (si != null) {
            cs = si.getOwner();
            if (cs != null) {
                spellLevel = si.getActualLevel();
                ow = cs.getOwner();
            }
            if (si.getFeatList() != null) {
                Iterator i = si.getFeatList().iterator();
                while (i.hasNext()) {
                    Feat aFeat = (Feat)i.next();
                    spellLevel -= aFeat.getAddSpellLevel();
                    metaDC = (int)((double)metaDC + aFeat.bonusTo("DC", "FEATBONUS", aPC, aPC));
                }
            }
        } else {
            ow = aClass;
        }
        if (ow instanceof Domain) {
            bonDomain = "DOMAIN." + ow.getName();
            CharacterDomain aCD = aPC.getCharacterDomainForDomain(ow.getName());
            if (aCD != null && aCD.isFromPCClass()) {
                String a = aCD.getObjectName();
                aClass = aPC.getClassNamed(a);
            }
        }
        if (aClass != null || ow instanceof PCClass) {
            if (aClass == null || ow instanceof PCClass) {
                aClass = ow;
            }
            bonClass = "CLASS." + aClass.getName();
            aClassName = "CLASS:" + aClass.getName();
            spellType = aClass.getSpellType();
            spellIndex = aClass.baseSpellIndex();
        }
        if (!(ow instanceof PCClass) && !(ow instanceof Domain)) {
            spellIndex = -2;
        }
        aPC.setSpellLevelTemp(spellLevel);
        int dc = aPC.getVariableValue(Globals.getGameModeBaseSpellDC(), aClassName).intValue() + metaDC;
        dc += (int)aPC.getTotalBonusTo("DC", "ALLSPELLS");
        if (spellIndex == -2 && (statName = this.getStat()).length() > 0) {
            dc += aPC.getStatList().getStatModFor(statName);
        }
        if (this.getName().length() > 0) {
            dc += (int)aPC.getTotalBonusTo("DC", "SPELL." + this.getName());
        }
        if (bonDomain.length() > 0) {
            dc += (int)aPC.getTotalBonusTo("DC", bonDomain);
        }
        if (bonClass.length() > 0) {
            dc += (int)aPC.getTotalBonusTo("DC", bonClass);
        }
        dc += (int)aPC.getTotalBonusTo("DC", "TYPE." + spellType);
        Iterator i = this.getMyTypeIterator();
        if (spellType.equals("ALL")) {
            while (i.hasNext()) {
                aType = (String)i.next();
                dc += (int)aPC.getTotalBonusTo("DC", "TYPE." + aType);
            }
        }
        if ((i = this.school.iterator()) != null) {
            while (i.hasNext()) {
                aType = (String)i.next();
                dc += (int)aPC.getTotalBonusTo("DC", "SCHOOL." + aType);
            }
        }
        if ((i = this.subschool.iterator()) != null) {
            while (i.hasNext()) {
                aType = (String)i.next();
                dc += (int)aPC.getTotalBonusTo("DC", "SUBSCHOOL." + aType);
            }
        }
        if ((i = this.descriptorList.iterator()) != null) {
            while (i.hasNext()) {
                aType = (String)i.next();
                dc += (int)aPC.getTotalBonusTo("DC", "DESCRIPTOR." + aType);
            }
        }
        aPC.setSpellLevelTemp(0);
        return dc;
    }

    public List getDescriptorList() {
        return this.descriptorList;
    }

    public void setDuration(String aString) {
        if (aString.equals(".CLEAR")) {
            this.duration.clear();
        } else if (aString.length() != 0) {
            this.duration.add(aString);
            Globals.addDurationSet(aString);
        }
    }

    public String getDuration() {
        String s = this.duration.toString();
        return s.substring(1, s.length() - 1);
    }

    public int getFirstLevelForKey(String key, PlayerCharacter aPC) {
        int[] levelInt = this.levelForKey(key, aPC);
        int result = -1;
        if (levelInt.length > 0) {
            result = levelInt[0];
        }
        return result;
    }

    protected void doGlobalTypeUpdate(String aType) {
        Globals.addTypeForSpells(aType);
    }

    public void setLevelInfo(String key, String aLevel) {
        try {
            this.setLevelInfo(key, Integer.parseInt(aLevel));
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Could not set level info.", exc);
        }
    }

    public void setLevelInfo(String key, int level) {
        if (".CLEAR".equals(key)) {
            this.levelInfo = null;
        } else if (level == -1) {
            if (this.levelInfo != null) {
                this.levelInfo.remove(key);
            }
        } else {
            if (this.levelInfo == null) {
                this.levelInfo = new HashMap();
            }
            this.levelInfo.put(key, new Integer(level));
        }
    }

    public Map getLevelInfo(PlayerCharacter aPC) {
        HashMap wLevelInfo = null;
        if (this.levelInfo != null) {
            wLevelInfo = (HashMap)this.levelInfo.clone();
        }
        if (aPC != null) {
            if (wLevelInfo == null) {
                wLevelInfo = new HashMap();
            }
            wLevelInfo.putAll(aPC.getSpellInfoMap("CLASS|" + this.getName()));
            wLevelInfo.putAll(aPC.getSpellInfoMap("DOMAIN|" + this.getName()));
        }
        return wLevelInfo;
    }

    public String getPCCText(PlayerCharacter aPC) {
        String aString;
        StringBuffer txt = new StringBuffer(200);
        txt.append(this.getName());
        this.appendPCCText(txt, this.castingTime, "CASTTIME");
        this.appendPCCText(txt, this.componentList, "COMPS");
        txt.append("\tCOST:").append(this.getCost().toString());
        if (this.getLevelInfo(aPC) != null) {
            ArrayList<String> classList = new ArrayList<String>();
            ArrayList<String> domainList = new ArrayList<String>();
            ArrayList<String> miscList = new ArrayList<String>();
            Iterator e = this.getLevelInfo(aPC).entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry entry = e.next();
                aString = entry.getKey().toString();
                if (aString.startsWith("CLASS|")) {
                    classList.add(aString.substring(6) + '=' + entry.getValue().toString());
                    continue;
                }
                if (aString.startsWith("DOMAIN|")) {
                    domainList.add(aString.substring(7) + '=' + entry.getValue().toString());
                    continue;
                }
                miscList.add(aString + '|' + entry.getValue().toString());
            }
            if (classList.size() != 0) {
                txt.append("\tCLASSES:").append(CoreUtility.join(classList, "|"));
            }
            if (domainList.size() != 0) {
                txt.append("\tDOMAINS:").append(CoreUtility.join(domainList, "|"));
            }
            if (miscList.size() != 0) {
                txt.append("\tSPELLLEVEL:").append(CoreUtility.join(miscList, "|"));
            }
        }
        if (this.getCastingThreshold() != 0) {
            txt.append("\tCT:").append(this.getCastingThreshold());
        }
        if ((aString = this.getDescriptor("|")).length() != 0) {
            txt.append("\tDESCRIPTOR:").append(aString);
        }
        this.appendPCCText(txt, this.duration, "DURATION");
        aString = this.getCreatableItem();
        if (aString.length() != 0) {
            txt.append("\tITEM:").append(aString);
        }
        this.appendPCCText(txt, this.range, "RANGE");
        this.appendPCCText(txt, this.saveInfo, "SAVEINFO");
        this.appendPCCText(txt, this.school, "SCHOOL");
        aString = this.getStat();
        if (aString.length() != 0) {
            txt.append("\tSTAT:").append(aString);
        }
        this.appendPCCText(txt, this.spellResistance, "SPELLRES");
        this.appendPCCText(txt, this.subschool, "SUBSCHOOL");
        aString = this.getTarget();
        if (aString.length() != 0) {
            txt.append("\tTARGETAREA:").append(aString);
        }
        if (this.variantList != null && this.variantList.size() != 0) {
            txt.append("\tVARIANTS:").append(CoreUtility.join((Collection)this.variantList, "|"));
        }
        if (this.getXPCost() != 0) {
            txt.append("\tXPCOST:").append(this.getXPCost());
        }
        txt.append(super.getPCCText(false, aPC));
        return txt.toString();
    }

    public void setRange(String aString) {
        if (aString.equals(".CLEAR")) {
            this.range.clear();
        } else if (aString.length() != 0) {
            this.range.add(aString);
            Globals.addSpellRangesSet(aString);
        }
    }

    public String getRange() {
        String s = this.range.toString();
        return s.substring(1, s.length() - 1);
    }

    public void setSaveInfo(String aString) {
        if (aString.equals(".CLEAR")) {
            this.saveInfo.clear();
        } else if (aString.length() != 0) {
            this.saveInfo.add(aString);
            Globals.addSpellSaveInfoSet(aString);
        }
    }

    public String getSaveInfo() {
        String s = this.saveInfo.toString();
        return s.substring(1, s.length() - 1);
    }

    public void addSchool(String aString) {
        if (aString.equals(".CLEAR")) {
            this.school.clear();
        } else if (aString.length() != 0) {
            this.school.add(aString);
        }
    }

    public String getSchool() {
        String s = this.school.toString();
        return s.substring(1, s.length() - 1);
    }

    public SortedSet getSchools() {
        return this.school;
    }

    public void setSpellResistance(String aString) {
        if (aString.equals(".CLEAR")) {
            this.spellResistance.clear();
        } else if (aString.length() != 0) {
            this.spellResistance.add(aString);
            Globals.addSpellSrSet(aString);
        }
    }

    public String getSpellResistance() {
        String s = this.spellResistance.toString();
        return s.substring(1, s.length() - 1);
    }

    public void setStat(String aStat) {
        this.spellStat = aStat;
        Globals.addSpellStatSet(aStat);
    }

    public String getStat() {
        return this.spellStat;
    }

    public void addSubschool(String aString) {
        if (aString.equals(".CLEAR")) {
            this.subschool.clear();
        } else if (aString.length() != 0) {
            this.subschool.add(aString);
            if (aString.length() != 0) {
                Globals.getSubschools().add(aString);
            }
        }
    }

    public String getSubschool() {
        String s = this.subschool.toString();
        return s.substring(1, s.length() - 1);
    }

    public SortedSet getSubschools() {
        return this.subschool;
    }

    public void setTarget(String aString) {
        this.target = aString;
        if (aString.length() != 0) {
            Globals.addSpellTargetSet(aString);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public List getVariants() {
        if (this.variantList == null) {
            this.variantList = new ArrayList();
        }
        return (ArrayList)this.variantList;
    }

    public void setXPCost(String aString) {
        try {
            this.xpCost = Integer.parseInt(aString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getXPCost() {
        return this.xpCost;
    }

    public void addDescriptor(String descriptor) {
        if (this.descriptorList == null) {
            this.descriptorList = new ArrayList();
        }
        this.descriptorList.add(descriptor);
    }

    public void addPreReqMapEntry(String type, Prerequisite preReq) {
        if (this.preReqMap == null) {
            this.preReqMap = new HashMap();
        }
        this.preReqMap.put(type, preReq);
    }

    public void addVariant(String variant) {
        if (this.variantList == null) {
            this.variantList = new ArrayList();
        }
        if (variant.length() != 0) {
            this.variantList.add(variant);
        }
    }

    public void clearLevelInfo() {
        this.levelInfo = null;
    }

    public void clearVariants() {
        this.variantList = null;
    }

    public Object clone() {
        Spell aSpell = null;
        try {
            aSpell = (Spell)super.clone();
            aSpell.school = this.school;
            aSpell.subschool = this.subschool;
            aSpell.isSpecified = this.isSpecified;
            aSpell.componentList = this.componentList;
            aSpell.castingTime = this.castingTime;
            aSpell.range = this.range;
            aSpell.target = this.target;
            aSpell.duration = this.duration;
            aSpell.saveInfo = this.saveInfo;
            aSpell.SR = this.SR;
            aSpell.spellResistance = this.spellResistance;
            aSpell.descriptorList = this.descriptorList;
            aSpell.setCastingThreshold(this.castingThreshold);
            aSpell.creatableItem = this.creatableItem;
            aSpell.cost = this.cost;
            aSpell.xpCost = this.xpCost;
            aSpell.variantList = this.variantList;
            if (this.levelInfo != null) {
                aSpell.levelInfo = (HashMap)this.levelInfo.clone();
            }
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aSpell;
    }

    public String descriptor() {
        return this.getDescriptor(", ");
    }

    public boolean descriptorListContains(List aList) {
        return CoreUtility.containsAny(this.descriptorList, aList);
    }

    public boolean isLevel(int aLevel, PlayerCharacter aPC) {
        Map wLevelInfo = this.getLevelInfo(aPC);
        Integer levelKey = new Integer(aLevel);
        Iterator i = wLevelInfo.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!wLevelInfo.get(key).equals(levelKey)) continue;
            return true;
        }
        return false;
    }

    public int levelForKey(String mType, String sType, PlayerCharacter aPC) {
        int result = -1;
        Map wLevelInfo = this.getLevelInfo(aPC);
        if (wLevelInfo != null && wLevelInfo.size() != 0) {
            PCClass aClass;
            Integer lvl = (Integer)wLevelInfo.get(mType + "|" + sType);
            if (lvl == null) {
                lvl = (Integer)wLevelInfo.get(mType + "|ALL");
            }
            if (lvl == null && mType.equals("CLASS") && (aClass = Globals.getClassKeyed(sType)) != null) {
                StringTokenizer aTok = new StringTokenizer(aClass.getType(), ".", false);
                while (aTok.hasMoreTokens() && lvl == null) {
                    lvl = (Integer)wLevelInfo.get(mType + "|TYPE." + aTok.nextToken());
                }
            }
            if (lvl != null) {
                result = lvl;
            }
        }
        return result;
    }

    public int[] levelForKey(String key, PlayerCharacter aPC) {
        if (this.levelInfo == null || this.levelInfo.size() == 0) {
            int[] temp = new int[]{-1};
            return temp;
        }
        StringTokenizer aTok = new StringTokenizer(key, "|", false);
        int[] levelInt = new int[aTok.countTokens() / 2];
        int i = 0;
        while (aTok.hasMoreTokens()) {
            String objectType = aTok.nextToken();
            if (!aTok.hasMoreTokens()) continue;
            String objectName = aTok.nextToken();
            levelInt[i++] = this.levelForKey(objectType, objectName, aPC);
        }
        return levelInt;
    }

    public boolean levelForKeyContains(String key, int levelMatch, PlayerCharacter aPC) {
        if (this.preReqMap != null && this.preReqMap.containsKey(key)) {
            ArrayList qList = new ArrayList();
            qList.add(this.preReqMap.get(key));
            if (!PrereqHandler.passesAll(qList, aPC, this)) {
                return false;
            }
        }
        int[] levelInt = this.levelForKey(key, aPC);
        for (int i = 0; i < levelInt.length; ++i) {
            if ((levelMatch != -1 || levelInt[i] < 0) && (levelMatch < 0 || levelInt[i] != levelMatch)) continue;
            return true;
        }
        if (aPC != null) {
            return aPC.getSpellLevelforKey(key + "|" + this.getName(), levelMatch);
        }
        return false;
    }

    public boolean schoolContains(List aList) {
        return CoreUtility.containsAny(this.school, aList);
    }

    public boolean subschoolContains(List aList) {
        return CoreUtility.containsAny(this.subschool, aList);
    }

    public boolean descriptorContains(String descriptor) {
        return this.descriptorList.contains(descriptor);
    }

    private String getDescriptor(String delimiter) {
        StringBuffer retVal = new StringBuffer(this.descriptorList.size() * 5);
        Iterator i = this.descriptorList.iterator();
        while (i.hasNext()) {
            String aString = (String)i.next();
            if (retVal.length() > 0) {
                retVal.append(delimiter);
            }
            retVal.append(aString);
        }
        return retVal.toString();
    }

    private void appendPCCText(StringBuffer sb, Set ts, String tag) {
        Iterator e = ts.iterator();
        while (e.hasNext()) {
            sb.append('\t').append(tag).append(':').append(e.next().toString());
        }
    }
}

