/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class CoreUtility {
    private CoreUtility() {
    }

    public static List arrayToList(Object[] array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static boolean isIntegerString(String numString) {
        boolean result;
        try {
            Integer.parseInt(numString);
            result = true;
        }
        catch (NumberFormatException nfe) {
            result = false;
        }
        return result;
    }

    public static boolean isNetURL(String aFile) {
        return aFile.startsWith("http:") || aFile.startsWith("ftp:");
    }

    public static boolean isURL(String aFile) {
        return aFile.startsWith("http:") || aFile.startsWith("ftp:") || aFile.startsWith("file:");
    }

    public static String capitalizeFirstLetter(String aString) {
        boolean toUpper = true;
        char[] a = aString.toLowerCase().toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (Character.isWhitespace(a[i])) {
                toUpper = true;
                continue;
            }
            if (toUpper && Character.isLowerCase(a[i])) {
                a[i] = Character.toUpperCase(a[i]);
            }
            toUpper = false;
        }
        return new String(a);
    }

    public static String commaDelimit(String oldString) {
        int oldStringLength = oldString.length();
        StringBuffer newString = new StringBuffer(oldStringLength);
        for (int i = 0; i < oldStringLength; ++i) {
            if (i != 0) {
                newString.append(',');
            }
            newString.append(oldString.charAt(i));
        }
        return newString.toString();
    }

    public static String commaDelimit(Collection stringArray) {
        return CoreUtility.join(stringArray, ',');
    }

    public static boolean compareDouble(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public static boolean containsAny(Collection checklist, Collection targets) {
        Iterator i = targets.iterator();
        while (i.hasNext()) {
            if (!checklist.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean doublesEqual(double a, double b) {
        return CoreUtility.compareDouble(a, b, 1.0E-4);
    }

    public static String fileToURL(String fileName) throws MalformedURLException {
        File aFile = new File(fileName);
        return aFile.toURL().toString();
    }

    public static String fixFilenamePath(String argFileName) {
        return argFileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String fixURL(String url) throws MalformedURLException {
        return new URL(url.replace('\\', '/')).toString();
    }

    public static String fixURLPath(String pccPath, String url) throws MalformedURLException {
        String result;
        StringBuffer path = new StringBuffer(url.length());
        if (url.startsWith("file:")) {
            path.append(pccPath.replace('\\', '/'));
            path.append(url.substring(5).replace('\\', '/'));
            result = new URL("file:" + path.toString()).toString();
        } else {
            result = new URL(url.replace('\\', '/')).toString();
        }
        return result;
    }

    public static int innerMostStringEnd(String aString) {
        int index = 0;
        int hi = 0;
        int current = 0;
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) == '(') {
                if (++current <= hi) continue;
                hi = current;
                continue;
            }
            if (aString.charAt(i) != ')') continue;
            if (current == hi) {
                index = i;
            }
            --current;
        }
        return index;
    }

    public static int innerMostStringStart(String aString) {
        int index = 0;
        int hi = 0;
        int current = 0;
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) == '(') {
                if (++current < hi) continue;
                hi = current;
                index = i;
                continue;
            }
            if (aString.charAt(i) != ')') continue;
            --current;
        }
        return index;
    }

    public static String join(Collection strings, char separator) {
        return CoreUtility.join(strings, separator + " ");
    }

    public static String join(Collection strings, String separator) {
        return CoreUtility.joinToStringBuffer(strings, separator).toString();
    }

    public static StringBuffer joinToStringBuffer(Collection strings, String separator) {
        StringBuffer result = new StringBuffer(strings.size() * 10);
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            result.append(element);
            if (!iter.hasNext()) continue;
            result.append(separator);
        }
        return result;
    }

    public static String ordinal(int iValue) {
        String suffix = "th";
        if (iValue < 4 || iValue > 20) {
            switch (iValue % 10) {
                case 1: {
                    suffix = "st";
                    break;
                }
                case 2: {
                    suffix = "nd";
                    break;
                }
                case 3: {
                    suffix = "rd";
                    break;
                }
            }
        }
        return Integer.toString(iValue) + suffix;
    }

    public static String replaceAll(String in, String find, String newStr) {
        int i;
        char[] working = in.toCharArray();
        StringBuffer sb = new StringBuffer(in.length() + newStr.length());
        int startindex = in.indexOf(find);
        if (startindex < 0) {
            return in;
        }
        int currindex = 0;
        while (startindex > -1) {
            for (i = currindex; i < startindex; ++i) {
                sb.append(working[i]);
            }
            currindex = startindex;
            sb.append(newStr);
            startindex = in.indexOf(find, currindex += find.length());
        }
        for (i = currindex; i < working.length; ++i) {
            sb.append(working[i]);
        }
        return sb.toString();
    }

    public static String replaceFirst(String original, String word, String replacement) {
        int start = original.indexOf(word);
        StringBuffer sb = new StringBuffer(50);
        sb.append(original.substring(0, start));
        sb.append(replacement);
        sb.append(original.substring(start + word.length()));
        return sb.toString();
    }

    public static List split(String aString, char separator) {
        int elems = 1;
        int beginIndex = 0;
        if (aString.trim().length() == 0) {
            return new ArrayList(0);
        }
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) != separator) continue;
            ++elems;
        }
        ArrayList<String> result = new ArrayList<String>(elems);
        for (int i = 0; i < elems; ++i) {
            int endIndex = aString.indexOf(separator, beginIndex);
            if (endIndex == -1) {
                endIndex = aString.length();
            }
            result.add(aString.substring(beginIndex, endIndex).trim());
            beginIndex = endIndex + 1;
        }
        return result;
    }

    public static String unEscapeColons2(String in) {
        return CoreUtility.replaceAll(in, "&#59;", ":");
    }
}

