/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.gui.tabs.InfoAbilities;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class AddSpecialAbility
extends JFrame {
    static final long serialVersionUID = 8632071234484774756L;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private InfoAbilities owner;
    private JButton okButton;
    private JPanel saPanel;
    private JScrollPane saPane;
    private JTableEx saTable;
    private JTextField saField = new JTextField();
    private PlayerCharacter aPC = null;
    private SAModel saModel = new SAModel();
    private TableSorter saSorter = null;
    static /* synthetic */ Class class$java$lang$String;

    public AddSpecialAbility() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint("Error while initing form", e);
        }
    }

    public AddSpecialAbility(PlayerCharacter pc, InfoAbilities ia) {
        try {
            this.aPC = pc;
            this.setTitle(AddSpecialAbility.myGetTitle());
            Toolkit kit = Toolkit.getDefaultToolkit();
            Image img = kit.getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif"));
            this.setIconImage(img);
            Dimension screenSize = kit.getScreenSize();
            int screenHeight = screenSize.height;
            int screenWidth = screenSize.width;
            this.setSize(screenWidth >> 1, screenHeight >> 1);
            this.setLocation(screenWidth >> 2, screenHeight >> 2);
            this.setDefaultCloseOperation(2);
            Container contentPane = this.getContentPane();
            this.jbInit();
            contentPane.add(this.saPanel);
            this.setVisible(true);
            this.owner = ia;
        }
        catch (HeadlessException e) {
            Logging.errorPrint("This gui cannot run headless. D-oh.", e);
        }
        catch (Exception e) {
            Logging.errorPrint("Error while initing form", e);
        }
    }

    private static String myGetTitle() {
        String title = PropertyFactory.getString("in_addSA");
        return title;
    }

    private void addSpecialAbility() {
        if (this.aPC == null || this.aPC.getClassList().isEmpty()) {
            return;
        }
        String selectedValue = this.saField.getText();
        if (selectedValue != null) {
            PCClass aClass = (PCClass)this.aPC.getClassList().get(0);
            String aString = selectedValue.trim();
            SpecialAbility sa = new SpecialAbility(aString, "PCCLASS|" + aClass.getName() + "|0");
            aClass.addSpecialAbilityToList(sa);
            aClass.addSave(aString);
            if (this.owner != null) {
                this.owner.forceRefresh();
            }
        }
    }

    private void jbInit() throws Exception {
        this.saPanel = new JPanel();
        this.saPane = new JScrollPane();
        JLabel saLabel = new JLabel("Special Ability:");
        JPanel top = new JPanel();
        this.saPanel.setLayout(this.gridBagLayout);
        this.saSorter = new TableSorter(this.saModel);
        this.saTable = new JTableEx(this.saSorter);
        this.saSorter.addMouseListenerToHeaderInTable(this.saTable);
        this.saTable.setSelectionMode(0);
        this.saTable.setDoubleBuffered(false);
        this.saPane.setViewportView(this.saTable);
        top.setLayout(new BorderLayout());
        top.add((Component)saLabel, "West");
        top.add((Component)this.saField, "Center");
        this.saPanel.add((Component)top, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saPanel.add((Component)this.saPane, new GridBagConstraints(0, 1, 1, 7, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ListSelectionModel lsm = AddSpecialAbility.this.saTable.getSelectionModel();
                int iRow = AddSpecialAbility.this.saSorter.getRowTranslated(lsm.getMinSelectionIndex());
                if (iRow >= 0) {
                    AddSpecialAbility.this.saField.setText((String)AddSpecialAbility.this.saModel.getValueAt(iRow, 0));
                }
                if (evt.getClickCount() == 2) {
                    AddSpecialAbility.this.okButton.doClick();
                }
            }
        });
        this.okButton = new JButton();
        this.okButton.setText(PropertyFactory.getString("in_ok"));
        this.okButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddSpecialAbility.this.addSpecialAbility();
                AddSpecialAbility.this.setVisible(false);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 11;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)this.okButton, c);
        this.saPanel.add((Component)buttonPanel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class SAModel
    extends AbstractTableModel {
        SAModel() {
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = AddSpecialAbility.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Ability";
                }
                case 1: {
                    return "Source";
                }
            }
            return "Out Of Bounds";
        }

        public int getRowCount() {
            return Globals.getSASet().size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0) {
                return null;
            }
            SpecialAbility sa = (SpecialAbility)Globals.getSASet().toArray()[rowIndex];
            if (sa == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return sa.getName();
                }
                case 1: {
                    return sa.getSASource();
                }
            }
            return null;
        }
    }
}

