/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.tabs.InfoAbilities;
import pcgen.gui.tabs.InfoClasses;
import pcgen.gui.tabs.InfoDescription;
import pcgen.gui.tabs.InfoDomain;
import pcgen.gui.tabs.InfoFeats;
import pcgen.gui.tabs.InfoInventory;
import pcgen.gui.tabs.InfoRace;
import pcgen.gui.tabs.InfoSkills;
import pcgen.gui.tabs.InfoSpells;
import pcgen.gui.tabs.InfoSummary;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.SwingWorker;

public final class CharacterInfo
extends JPanel {
    private List tempTabList;
    private LinkedList tabList = new LinkedList();
    private BorderLayout borderLayout1 = new BorderLayout();
    private InfoDescription infoDesc;
    private InfoInventory infoInventory;
    private InfoSummary infoSummary;
    private InfoRace infoRace;
    private InfoAbilities infoAbilities;
    private InfoClasses infoClasses;
    private InfoSkills infoSkills;
    private InfoFeats infoFeats;
    private InfoDomain infoDomain;
    private InfoSpells infoSpells;
    private JTabbedPane characterInfoTabbedPane = new JTabbedPane();
    private PlayerCharacter pc;
    private static Set updateSet = new HashSet();

    public CharacterInfo(PlayerCharacter pc, List tempTabList) {
        this.pc = pc;
        this.tempTabList = tempTabList;
        this.infoDesc = new InfoDescription(pc);
        this.infoInventory = new InfoInventory(pc);
        this.infoSummary = new InfoSummary(pc);
        this.infoRace = new InfoRace(pc);
        this.infoAbilities = new InfoAbilities(pc);
        this.infoClasses = new InfoClasses(pc);
        this.infoSkills = new InfoSkills(pc);
        this.infoFeats = new InfoFeats(pc);
        this.infoDomain = new InfoDomain(pc);
        this.infoSpells = new InfoSpells(pc);
        this.setName("");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint(PropertyFactory.getString("in_CIerrorMess"), e);
        }
    }

    private void addListeners() {
        this.characterInfoTabbedPane.addChangeListener(new tabChangeListener());
        ComponentListener componentListener = PToolBar.getCurrentInstance().getComponentListener();
        this.addComponentListener(componentListener);
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab tab = (CharacterInfoTab)this.tabList.get(i);
            if (!tab.isShown() || !(tab instanceof FilterAdapterPanel)) continue;
            FilterAdapterPanel fpanel = (FilterAdapterPanel)((Object)tab);
            fpanel.addComponentListener(componentListener);
        }
        this.infoInventory.getInfoGear().addComponentListener(componentListener);
    }

    public final Component getActivePane() {
        return this.characterInfoTabbedPane.getSelectedComponent();
    }

    public String getKitFilter() {
        Component c = this.characterInfoTabbedPane.getSelectedComponent();
        if (c instanceof FilterAdapterPanel) {
            return ((FilterAdapterPanel)c).getKitFilter();
        }
        if (c instanceof InfoInventory) {
            return ((InfoInventory)c).getInfoGear().getKitFilter();
        }
        return "";
    }

    public Filterable getSelectedFilterable() {
        Component c = this.characterInfoTabbedPane.getSelectedComponent();
        if (c instanceof Filterable) {
            return (Filterable)((Object)c);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.characterInfoTabbedPane.getSelectedIndex();
    }

    public void setTxtName(String aString) {
        this.infoSummary.getPcNameText().setText(aString);
        this.infoDesc.getTxtName().setText(aString);
    }

    public int indexOfTab(String aString) {
        return this.characterInfoTabbedPane.indexOfTab(aString);
    }

    public InfoDescription infoDesc() {
        return this.infoDesc;
    }

    public InfoInventory infoInventory() {
        return this.infoInventory;
    }

    public InfoSummary infoSummary() {
        return this.infoSummary;
    }

    public InfoRace infoRace() {
        return this.infoRace;
    }

    public InfoAbilities infoAbilities() {
        return this.infoAbilities;
    }

    public InfoClasses infoClasses() {
        return this.infoClasses;
    }

    public InfoSkills infoSkills() {
        return this.infoSkills;
    }

    public InfoFeats infoFeats() {
        return this.infoFeats;
    }

    public InfoDomain infoDomain() {
        return this.infoDomain;
    }

    public InfoSpells infoSpells() {
        return this.infoSpells;
    }

    public void setPaneForUpdate(CharacterInfoTab tab) {
        updateSet.add(tab);
    }

    public void resetToSummaryTab() {
        this.characterInfoTabbedPane.setSelectedIndex(0);
    }

    public void restoreFilterSettings(String filterableName) {
        if (filterableName == null) {
            this.restoreAllFilterSettings();
            return;
        }
        for (int i = 0; i < this.characterInfoTabbedPane.getTabCount(); ++i) {
            Component c = this.characterInfoTabbedPane.getComponentAt(i);
            if (!(c instanceof Filterable) || c.getName() == null || !c.getName().equals(filterableName)) continue;
            FilterFactory.restoreFilterSettings((Filterable)((Object)c));
        }
    }

    public void storeFilterSettings() {
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab tab = (CharacterInfoTab)this.tabList.get(i);
            if (!tab.isShown() || !(tab instanceof FilterAdapterPanel)) continue;
            FilterAdapterPanel fpanel = (FilterAdapterPanel)((Object)tab);
            SettingsHandler.storeFilterSettings(fpanel);
        }
        SettingsHandler.storeFilterSettings(this.infoInventory.getInfoGear());
    }

    public void addTab(CharacterInfoTab tab) {
        if (tab.isShown()) {
            this.characterInfoTabbedPane.add((Component)tab.getView(), tab.getTabName());
        }
        this.tabList.add(tab);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.characterInfoTabbedPane.setPreferredSize(new Dimension(550, 350));
        this.setMinimumSize(new Dimension(550, 350));
        this.setPreferredSize(new Dimension(550, 350));
        this.add((Component)this.characterInfoTabbedPane, "Center");
        this.characterInfoTabbedPane.setTabPlacement(SettingsHandler.getChaTabPlacement());
        this.addTab(this.infoSummary());
        this.addTab(this.infoRace());
        this.addTab(this.infoAbilities());
        this.addTab(this.infoClasses());
        this.addTab(this.infoSkills());
        this.addTab(this.infoFeats());
        this.addTab(this.infoDomain());
        this.addTab(this.infoSpells());
        this.addTab(this.infoInventory());
        this.addTab(this.infoDesc());
        for (int i = 0; i < this.tempTabList.size(); ++i) {
            CharacterInfoTab tab = (CharacterInfoTab)this.tempTabList.get(i);
            tab.setPc(this.pc);
            this.addTab(tab);
        }
        this.addListeners();
    }

    private void restoreAllFilterSettings() {
        FilterFactory.clearFilterCache();
        for (int i = 0; i < this.tabList.size(); ++i) {
            CharacterInfoTab tab = (CharacterInfoTab)this.tabList.get(i);
            if (!tab.isShown() || !(tab instanceof FilterAdapterPanel)) continue;
            FilterAdapterPanel fpanel = (FilterAdapterPanel)((Object)tab);
            FilterFactory.restoreFilterSettings(fpanel);
        }
        FilterFactory.restoreFilterSettings(this.infoInventory.getInfoGear());
    }

    public void refresh() {
        new Refresher().start();
    }

    public void setPc(PlayerCharacter pc) {
        this.pc = pc;
        CharacterInfoTab tab = (CharacterInfoTab)((Object)this.characterInfoTabbedPane.getSelectedComponent());
        tab.setPc(pc);
        new PcSetter().start();
    }

    private class Refresher
    extends SwingWorker {
        private Refresher() {
        }

        public Object construct() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            CharacterInfoTab tab = (CharacterInfoTab)((Object)CharacterInfo.this.characterInfoTabbedPane.getSelectedComponent());
            Set set = updateSet;
            synchronized (set) {
                if (updateSet.contains(tab)) {
                    tab.refresh();
                    updateSet.remove(tab);
                }
                Iterator i = updateSet.iterator();
                while (i.hasNext()) {
                    tab = (CharacterInfoTab)i.next();
                    if (tab.isShown()) {
                        try {
                            tab.refresh();
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    i.remove();
                }
            }
        }
    }

    private class PcSetter
    extends SwingWorker {
        private PcSetter() {
        }

        public Object construct() {
            return "";
        }

        public void finished() {
            for (int i = 0; i < CharacterInfo.this.tabList.size(); ++i) {
                CharacterInfoTab tab = (CharacterInfoTab)CharacterInfo.this.tabList.get(i);
                if (!tab.isShown()) continue;
                tab.setPc(CharacterInfo.this.pc);
            }
            PCGen_Frame1.getInst().repaint();
        }
    }

    private class tabChangeListener
    implements ChangeListener {
        private tabChangeListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            CharacterInfoTab tab = (CharacterInfoTab)((Object)CharacterInfo.this.characterInfoTabbedPane.getSelectedComponent());
            tab.refresh();
        }
    }
}

