/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Domain;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.EqBuilder;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class ChooseSpellDialog
extends JDialog {
    static final long serialVersionUID = 3692925177296126937L;
    private static final int TRIGGER_ALL = -1;
    private static final int TRIGGER_CLASS = 0;
    private static final int TRIGGER_BASELEVEL = 1;
    private static final int TRIGGER_CASTERLEVEL = 2;
    private static final int TRIGGER_SPELLNAME = 3;
    private static final int TRIGGER_METAMAGIC = 4;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBoxEx cmbBaseSpellLevel;
    private JComboBoxEx cmbCasterLevel;
    private JComboBoxEx cmbClass;
    private JComboBoxEx cmbSpellName;
    private JComboBoxEx cmbSpellType;
    private JComboBoxEx cmbSpellVariant;
    private JLabel lblBaseSpellLevel;
    private JLabel lblCasterLevel;
    private JLabel lblClass;
    private JLabel lblMetamagicFeats;
    private JLabel lblSpellName;
    private JLabel lblSpellType;
    private JLabel lblSpellVariant;
    private JList lstMetamagicFeats;
    private JScrollPane jScrollPane1;
    private List classList = null;
    private List classSpells = null;
    private List levelList = null;
    private List subTypeList = new ArrayList();
    private Map specialists = null;
    private PObject castingClass = null;
    private Spell theSpell = null;
    private String choiceString = "";
    private boolean metaAllowed = true;
    private boolean wasCancelled = true;
    private int baseSpellLevel = -1;
    private int eqType = -1;
    private int levelAdjust = 0;
    private int minLevel = 0;
    private int spellBooks = 0;
    private PlayerCharacter pc;

    ChooseSpellDialog(JFrame parent, PlayerCharacter pc, int eqType, boolean metaAllowed, List classList, List levelList, int spellBooks, String choiceString) {
        super(parent);
        IconUtilitities.maybeSetIcon(parent, "PcgenIcon.gif");
        this.eqType = eqType;
        this.pc = pc;
        this.metaAllowed = metaAllowed;
        this.spellBooks = spellBooks;
        this.classList = classList;
        this.levelList = levelList;
        this.choiceString = choiceString;
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    ChooseSpellDialog(JFrame parent, PlayerCharacter pc, int eqType, boolean metaAllowed, List classList, List levelList, int spellBooks) {
        super(parent);
        IconUtilitities.maybeSetIcon(parent, "PcgenIcon.gif");
        this.eqType = eqType;
        this.metaAllowed = metaAllowed;
        this.spellBooks = spellBooks;
        this.classList = classList;
        this.levelList = levelList;
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public int getBaseSpellLevel() {
        return this.baseSpellLevel + this.levelAdjust;
    }

    public int getCasterLevel() {
        if (this.cmbCasterLevel.getSelectedIndex() >= 0) {
            return (Integer)this.cmbCasterLevel.getItemAt(this.cmbCasterLevel.getSelectedIndex());
        }
        return 9999;
    }

    public Object getCastingClass() {
        return this.castingClass;
    }

    public Object[] getMetamagicFeats() {
        if (this.lstMetamagicFeats != null) {
            return this.lstMetamagicFeats.getSelectedValues();
        }
        return null;
    }

    public Spell getSpell() {
        return this.theSpell;
    }

    public String getSpellType() {
        if (this.cmbSpellType.getSelectedIndex() >= 0) {
            return (String)this.cmbSpellType.getItemAt(this.cmbSpellType.getSelectedIndex());
        }
        return null;
    }

    public String getVariant() {
        if (this.cmbSpellVariant.isEnabled()) {
            return (String)this.cmbSpellVariant.getItemAt(this.cmbSpellVariant.getSelectedIndex());
        }
        return "";
    }

    public boolean getWasCancelled() {
        return this.wasCancelled;
    }

    private void setCasterLevel(int casterLevel) {
        boolean bEnabled = true;
        if (casterLevel == 9999) {
            this.cmbCasterLevel.setSelectedIndex(-1);
            bEnabled = false;
        } else {
            this.cmbCasterLevel.setSelectedItem(new Integer(casterLevel));
        }
        if (this.lblCasterLevel.isEnabled() != bEnabled) {
            this.lblCasterLevel.setEnabled(bEnabled);
            this.cmbCasterLevel.setEnabled(bEnabled);
        }
    }

    private void getSpecialists() {
        this.specialists = new HashMap();
        Iterator e = Globals.getClassList().iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            List subClasses = CoreUtility.split(aClass.getSubClassString(), '|');
            if (subClasses.size() > 1) {
                subClasses.remove(0);
            }
            for (int idx = 0; idx < subClasses.size(); ++idx) {
                String fileName = (String)subClasses.get(idx);
                int i = fileName.indexOf(40);
                if (i >= 0) {
                    fileName = fileName.substring(0, i);
                }
                if (!fileName.startsWith("FILE=")) continue;
                CoreUtility.fixFilenamePath(fileName);
                i = 5;
                if (fileName.charAt(6) == File.separatorChar) {
                    i = 6;
                }
                fileName = fileName.substring(i);
                fileName = SettingsHandler.getPccFilesLocation() + File.separator + fileName;
                File aFile = new File(fileName);
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
                    String line = reader.readLine();
                    while (line != null) {
                        StringTokenizer aTok;
                        if ((line.length() <= 0 || line.charAt(0) != '#') && (aTok = new StringTokenizer(line.trim(), "\t")).countTokens() > 2) {
                            String specialty = aTok.nextToken();
                            String cost = aTok.nextToken();
                            String className = aTok.nextToken();
                            ArrayList<String> aList = new ArrayList<String>(5);
                            aList.add(aClass.getName());
                            aList.add(specialty);
                            aList.add(cost);
                            this.specialists.put(className, aList);
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                    continue;
                }
                catch (FileNotFoundException exception) {
                    continue;
                }
                catch (UnsupportedEncodingException exception) {
                    continue;
                }
                catch (IOException exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isSpellOfSubType(Spell aSpell) {
        if (this.subTypeList.size() == 0) {
            return true;
        }
        boolean finalIsOfType = false;
        Iterator e = this.subTypeList.iterator();
        while (e.hasNext()) {
            boolean isOfType = true;
            StringTokenizer aTok = new StringTokenizer((String)e.next(), ";,");
            while (aTok.hasMoreTokens()) {
                String subType = aTok.nextToken();
                if (subType.startsWith("SCHOOL.")) {
                    ArrayList<String> school = new ArrayList<String>();
                    school.add(subType.substring(7));
                    if (!aSpell.schoolContains(school)) {
                        isOfType = false;
                        break;
                    }
                }
                if (subType.startsWith("SUBSCHOOL.")) {
                    ArrayList<String> subSchool = new ArrayList<String>();
                    subSchool.add(subType.substring(10));
                    if (!aSpell.subschoolContains(subSchool)) {
                        isOfType = false;
                        break;
                    }
                }
                if (!subType.startsWith("DESCRIPTOR.")) continue;
                String descriptor = subType.substring(11);
                if (aSpell.getDescriptorList().contains(descriptor)) continue;
                isOfType = false;
                break;
            }
            if (!isOfType) continue;
            finalIsOfType = true;
            break;
        }
        return finalIsOfType;
    }

    private List getSpellTypes() {
        ArrayList<String> spellTypes = new ArrayList<String>();
        if (this.castingClass instanceof PCClass) {
            spellTypes.add(((PCClass)this.castingClass).getSpellType());
        } else if (this.castingClass instanceof Domain) {
            spellTypes.add("Divine");
        } else {
            PCClass aClass = Globals.getClassNamed(this.castingClass.getAssociated(0));
            if (aClass != null) {
                spellTypes.add(aClass.getSpellType());
            }
        }
        return spellTypes;
    }

    private void addSpellInfoToList(Spell aSpell, List unfoundItems, List classWithSpell) {
        this.addSpellInfoToList(aSpell, unfoundItems, classWithSpell, "");
    }

    private void addSpellInfoToList(Spell aSpell, List unfoundItems, List classWithSpell, String spellType) {
        Map levelInfo = aSpell.getLevelInfo(this.pc);
        if (levelInfo == null || levelInfo.size() == 0) {
            Logging.errorPrint("Spell: " + aSpell.getName() + "(" + aSpell.getSource() + ") has no home");
            return;
        }
        Iterator it = levelInfo.keySet().iterator();
        while (it.hasNext()) {
            String sub;
            String key = (String)it.next();
            if (key.startsWith("CLASS|")) {
                sub = key.substring(6);
                PCClass aClass = Globals.getClassNamed(sub);
                if (aClass != null) {
                    if (!"".equals(spellType) && spellType.indexOf(aClass.getSpellType()) < 0 || classWithSpell.contains(aClass)) continue;
                    classWithSpell.add(aClass);
                    continue;
                }
                sub = 'C' + sub;
                if (unfoundItems.contains(sub)) continue;
                unfoundItems.add(sub);
                continue;
            }
            if (key.startsWith("DOMAIN|")) {
                if (!"".equals(spellType) && spellType.indexOf("Divine") < 0) continue;
                sub = key.substring(7);
                Domain aDomain = Globals.getDomainNamed(sub);
                if (aDomain != null) {
                    if (classWithSpell.contains(aDomain)) continue;
                    classWithSpell.add(aDomain);
                    continue;
                }
                sub = 'D' + sub;
                if (unfoundItems.contains(sub)) continue;
                unfoundItems.add(sub);
                continue;
            }
            Logging.errorPrint("Unknown spell source: " + key);
        }
    }

    private void btnOKActionPerformed() {
        if (this.btnOk.isEnabled()) {
            this.wasCancelled = false;
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean canCreateItem(Spell aSpell) {
        String itemType;
        boolean canCreate = true;
        switch (this.eqType) {
            case -1: {
                return true;
            }
            case 0: {
                canCreate = false;
            }
            case 1: 
            case 2: 
            case 3: {
                itemType = EqBuilder.validEqTypes[this.eqType];
                break;
            }
            default: {
                return false;
            }
        }
        String items = aSpell.getCreatableItem().toLowerCase();
        if (items.indexOf("[" + itemType + "]") >= 0) {
            canCreate = false;
        } else if (items.indexOf(itemType) >= 0) {
            canCreate = true;
        }
        return canCreate;
    }

    private void closeDialog() {
        this.wasCancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cmbClassLevelActionPerformed(ItemEvent evt, int trigger) {
        boolean isEnabled;
        if (evt != null && evt.getStateChange() != 1) {
            return;
        }
        if ((trigger == -1 || trigger == 0) && this.cmbClass.getSelectedIndex() >= 0) {
            this.castingClass = (PObject)this.cmbClass.getItemAt(this.cmbClass.getSelectedIndex());
            String cName = "";
            String dName = "";
            if (this.castingClass instanceof PCClass) {
                cName = ((PCClass)this.castingClass).getCastAs();
                if (cName.length() == 0) {
                    cName = this.castingClass.getName();
                }
            } else if (this.castingClass instanceof Domain) {
                dName = this.castingClass.getName();
            } else {
                cName = this.castingClass.getName();
            }
            this.classSpells = new ArrayList();
            Iterator e = Globals.getSpellsIn(-1, cName, dName).iterator();
            while (e.hasNext()) {
                Spell s = (Spell)e.next();
                if (!this.canCreateItem(s)) continue;
                this.classSpells.add(s);
            }
            List spellTypes = this.getSpellTypes();
            this.cmbSpellType.setModel(new DefaultComboBoxModel<Object>(spellTypes.toArray()));
            this.cmbBaseSpellLevel.setSelectedIndex(0);
        }
        if (this.castingClass == null) {
            return;
        }
        if ((trigger == -1 || trigger == 1) && this.cmbBaseSpellLevel.getSelectedIndex() >= 0) {
            this.baseSpellLevel = (Integer)this.cmbBaseSpellLevel.getItemAt(this.cmbBaseSpellLevel.getSelectedIndex());
        }
        if (this.baseSpellLevel < 0) {
            return;
        }
        if (trigger == -1 || trigger == 4) {
            this.levelAdjust = 0;
            Object[] selectedMetamagicFeats = this.getMetamagicFeats();
            if (selectedMetamagicFeats != null) {
                for (int i = 0; i < selectedMetamagicFeats.length; ++i) {
                    this.levelAdjust += ((Feat)selectedMetamagicFeats[i]).getAddSpellLevel();
                }
            }
        }
        if (trigger == -1 || trigger == 0 || trigger == 1 || trigger == 2 || trigger == 4) {
            if (trigger != 4 && trigger != 2 && this.lblSpellVariant.isEnabled()) {
                this.lblSpellVariant.setEnabled(false);
                this.cmbSpellVariant.setEnabled(false);
                this.cmbSpellVariant.setModel(new DefaultComboBoxModel<Object>(new ArrayList().toArray()));
            }
            int maxClassLevel = 20;
            PCClass aClass = this.castingClass instanceof PCClass ? (PCClass)this.castingClass : (this.castingClass instanceof Domain ? Globals.getClassNamed("Cleric") : Globals.getClassNamed(this.castingClass.getName()));
            if (aClass != null) {
                this.minLevel = Globals.minLevelForSpellLevel(aClass, this.baseSpellLevel + this.levelAdjust, true);
                maxClassLevel = aClass.getMaxLevel();
            } else {
                this.minLevel = 1;
            }
            int casterLevel = this.getCasterLevel();
            if (trigger == 1 || trigger == 4 || casterLevel < this.minLevel) {
                casterLevel = this.minLevel;
            }
            if (!Globals.checkRule("LEVELCAP") && casterLevel != 9999 && casterLevel > maxClassLevel) {
                casterLevel = maxClassLevel;
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_csdEr4"), "PCGen", MessageType.INFORMATION);
            }
            if (this.getCasterLevel() != casterLevel) {
                this.setCasterLevel(casterLevel);
            }
        }
        if (trigger == -1 || trigger == 0 || trigger == 1) {
            this.theSpell = null;
            ArrayList<Comparable> spellsOfLevel = new ArrayList<Comparable>();
            if (this.classSpells != null) {
                String caster;
                String casterName;
                if (this.castingClass instanceof PCClass) {
                    casterName = ((PCClass)this.castingClass).getCastAs();
                    if (casterName.length() == 0) {
                        casterName = this.castingClass.getName();
                    }
                    caster = "CLASS";
                } else if (this.castingClass instanceof Domain) {
                    casterName = this.castingClass.getName();
                    caster = "DOMAIN";
                } else {
                    casterName = this.castingClass.getName();
                    caster = "CLASS";
                }
                Iterator e = this.classSpells.iterator();
                while (e.hasNext()) {
                    Spell s = (Spell)e.next();
                    if (!this.isSpellOfSubType(s) || s.levelForKey(caster, casterName, this.pc) != this.baseSpellLevel) continue;
                    if (SettingsHandler.guiUsesOutputName()) {
                        spellsOfLevel.add(new SpellShell(s));
                        continue;
                    }
                    spellsOfLevel.add(s);
                }
                Collections.sort(spellsOfLevel);
            }
            isEnabled = spellsOfLevel.size() != 0;
            this.lblSpellName.setEnabled(isEnabled);
            this.cmbSpellName.setEnabled(isEnabled);
            this.cmbSpellName.setModel(new DefaultComboBoxModel<Object>(spellsOfLevel.toArray()));
        }
        if (trigger == -1 || trigger == 0 || trigger == 1 || trigger == 3) {
            Object obj;
            this.theSpell = this.cmbSpellName.getSelectedIndex() >= 0 ? ((obj = this.cmbSpellName.getItemAt(this.cmbSpellName.getSelectedIndex())) instanceof SpellShell ? ((SpellShell)obj).getSpell() : (Spell)obj) : null;
            ArrayList variants = this.theSpell != null ? this.theSpell.getVariants() : new ArrayList();
            boolean bl = isEnabled = variants.size() != 0;
            if (isEnabled || !isEnabled && this.lblSpellVariant.isEnabled()) {
                this.cmbSpellVariant.setModel(new DefaultComboBoxModel<Object>(variants.toArray()));
            }
            if (isEnabled != this.lblSpellVariant.isEnabled()) {
                this.lblSpellVariant.setEnabled(isEnabled);
                this.cmbSpellVariant.setEnabled(isEnabled);
            }
        }
        this.btnOk.setEnabled(this.cmbSpellName.isEnabled() && this.cmbCasterLevel.getSelectedIndex() >= 0);
    }

    private void initComponents() {
        int i;
        Integer[] levelsForCasting;
        this.lblClass = new JLabel();
        this.lblBaseSpellLevel = new JLabel();
        this.lblSpellName = new JLabel();
        this.lblSpellVariant = new JLabel();
        this.lblCasterLevel = new JLabel();
        this.lblSpellType = new JLabel();
        this.cmbClass = new JComboBoxEx();
        this.cmbBaseSpellLevel = new JComboBoxEx();
        this.cmbSpellName = new JComboBoxEx();
        this.cmbSpellVariant = new JComboBoxEx();
        this.cmbCasterLevel = new JComboBoxEx();
        this.cmbSpellType = new JComboBoxEx();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        if (this.metaAllowed) {
            this.lblMetamagicFeats = new JLabel();
            this.lstMetamagicFeats = new JList();
            this.jScrollPane1 = new JScrollPane();
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(PropertyFactory.getString("in_csdSelect"));
        this.setModal(true);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ChooseSpellDialog.this.closeDialog();
            }
        });
        this.lblClass.setText(PropertyFactory.getString("in_class"));
        this.lblClass.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_class"));
        this.lblClass.setLabelFor(this.cmbClass);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        this.lblClass.setPreferredSize(new Dimension(32, 16));
        this.getContentPane().add((Component)this.lblClass, gridBagConstraints);
        this.cmbClass.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(evt, 0);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        this.cmbClass.setPreferredSize(new Dimension(200, 25));
        this.getContentPane().add((Component)this.cmbClass, gridBagConstraints);
        this.lblBaseSpellLevel.setText(PropertyFactory.getString("in_csdSpLvl"));
        this.lblBaseSpellLevel.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_csdSpLvl"));
        this.lblBaseSpellLevel.setLabelFor(this.cmbBaseSpellLevel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.lblBaseSpellLevel.setPreferredSize(new Dimension(61, 16));
        this.getContentPane().add((Component)this.lblBaseSpellLevel, gridBagConstraints);
        this.cmbBaseSpellLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(evt, 1);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.cmbBaseSpellLevel.setPreferredSize(new Dimension(61, 25));
        this.getContentPane().add((Component)this.cmbBaseSpellLevel, gridBagConstraints);
        if (this.metaAllowed) {
            this.lblMetamagicFeats.setText(PropertyFactory.getString("in_metaFeat"));
            this.lblMetamagicFeats.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_metaFeat"));
            this.lblMetamagicFeats.setLabelFor(this.lstMetamagicFeats);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 11;
            gridBagConstraints.fill = 1;
            this.lblMetamagicFeats.setPreferredSize(new Dimension(97, 16));
            this.getContentPane().add((Component)this.lblMetamagicFeats, gridBagConstraints);
            this.jScrollPane1.setViewportView(this.lstMetamagicFeats);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 11;
            gridBagConstraints.gridheight = 15;
            gridBagConstraints.fill = 1;
            this.jScrollPane1.setPreferredSize(new Dimension(259, 150));
            this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
            this.lstMetamagicFeats.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ChooseSpellDialog.this.cmbClassLevelActionPerformed(null, 4);
                    }
                }
            });
        }
        this.btnOk.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.btnOk.setText(PropertyFactory.getString("in_ok"));
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseSpellDialog.this.btnOKActionPerformed();
            }
        });
        this.btnOk.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ChooseSpellDialog.this.btnOKActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.btnOk.setPreferredSize(new Dimension(73, 26));
        this.getContentPane().add((Component)this.btnOk, gridBagConstraints);
        this.btnCancel.setMnemonic(PropertyFactory.getMnemonic("in_mn_cancel"));
        this.btnCancel.setText(PropertyFactory.getString("in_cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseSpellDialog.this.closeDialog();
            }
        });
        this.btnCancel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ChooseSpellDialog.this.closeDialog();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.btnCancel.setPreferredSize(new Dimension(73, 26));
        this.getContentPane().add((Component)this.btnCancel, gridBagConstraints);
        this.lblSpellName.setText(PropertyFactory.getString("in_spellName"));
        this.lblSpellName.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_spellName"));
        this.lblSpellName.setLabelFor(this.cmbSpellName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.lblSpellName.setPreferredSize(new Dimension(64, 16));
        this.getContentPane().add((Component)this.lblSpellName, gridBagConstraints);
        this.cmbSpellName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(evt, 3);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.cmbSpellName.setPreferredSize(new Dimension(280, 25));
        this.getContentPane().add((Component)this.cmbSpellName, gridBagConstraints);
        this.lblSpellVariant.setText(PropertyFactory.getString("in_csdVariant"));
        this.lblSpellVariant.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_csdVariant"));
        this.lblSpellVariant.setLabelFor(this.cmbSpellVariant);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.lblSpellVariant.setPreferredSize(new Dimension(41, 16));
        this.getContentPane().add((Component)this.lblSpellVariant, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        this.cmbSpellVariant.setPreferredSize(new Dimension(280, 25));
        this.getContentPane().add((Component)this.cmbSpellVariant, gridBagConstraints);
        this.lblCasterLevel.setText(PropertyFactory.getString("in_casterLvl"));
        this.lblCasterLevel.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_casterLvl"));
        this.lblCasterLevel.setLabelFor(this.cmbCasterLevel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        this.lblCasterLevel.setPreferredSize(new Dimension(71, 16));
        this.getContentPane().add((Component)this.lblCasterLevel, gridBagConstraints);
        this.cmbCasterLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChooseSpellDialog.this.cmbClassLevelActionPerformed(evt, 2);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        this.cmbCasterLevel.setPreferredSize(new Dimension(71, 25));
        this.getContentPane().add((Component)this.cmbCasterLevel, gridBagConstraints);
        this.lblSpellType.setText(PropertyFactory.getString("in_spellType"));
        this.lblSpellType.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_spellType"));
        this.lblSpellType.setLabelFor(this.cmbSpellType);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 14;
        gridBagConstraints.fill = 1;
        this.lblSpellType.setPreferredSize(new Dimension(58, 16));
        this.getContentPane().add((Component)this.lblSpellType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 14;
        gridBagConstraints.fill = 1;
        this.cmbSpellType.setPreferredSize(new Dimension(60, 25));
        this.getContentPane().add((Component)this.cmbSpellType, gridBagConstraints);
        ArrayList unfoundItems = new ArrayList();
        ArrayList<PObject> classWithSpell = new ArrayList<PObject>();
        String spellType = "";
        int minLevel = 0;
        int maxLevel = 9;
        if (this.choiceString.startsWith("EQBUILDER.SPELL") && !this.choiceString.endsWith("EQBUILDER.SPELL")) {
            StringTokenizer aTok = new StringTokenizer(this.choiceString, "|");
            aTok.nextToken();
            if (aTok.hasMoreTokens() && ((spellType = aTok.nextToken()).equalsIgnoreCase("ANY") || spellType.equalsIgnoreCase("ALL"))) {
                spellType = "";
            }
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                try {
                    minLevel = Integer.parseInt(aString);
                    break;
                }
                catch (NumberFormatException nfe) {
                    this.subTypeList.add(aString);
                }
            }
            if (aTok.hasMoreTokens()) {
                maxLevel = Integer.parseInt(aTok.nextToken());
            }
        }
        if (this.classList != null) {
            Iterator i2 = this.classList.iterator();
            while (i2.hasNext()) {
                String className = (String)i2.next();
                PObject obj = Globals.getClassNamed(className);
                if (obj == null) {
                    obj = Globals.getDomainNamed(className);
                }
                if (obj == null || obj instanceof Domain && spellType.indexOf("Divine") < 0 || "".equals(spellType) || !(obj instanceof PCClass) || spellType.indexOf(((PCClass)obj).getSpellType()) < 0) continue;
                classWithSpell.add(obj);
            }
        } else {
            Map spellMap = Globals.getSpellMap();
            Iterator i3 = spellMap.keySet().iterator();
            while (i3.hasNext()) {
                String aKey = (String)i3.next();
                Object obj = spellMap.get(aKey);
                if (obj instanceof ArrayList) {
                    Iterator it2 = ((ArrayList)obj).iterator();
                    while (it2.hasNext()) {
                        Spell bSpell = (Spell)it2.next();
                        if (!this.isSpellOfSubType(bSpell)) continue;
                        this.addSpellInfoToList(bSpell, unfoundItems, classWithSpell, spellType);
                    }
                    continue;
                }
                if (!this.isSpellOfSubType((Spell)obj)) continue;
                this.addSpellInfoToList((Spell)obj, unfoundItems, classWithSpell, spellType);
            }
            if (unfoundItems.size() > 0) {
                this.specialists = null;
                Iterator e = unfoundItems.iterator();
                while (e.hasNext()) {
                    String eMsg = (String)e.next();
                    String bMsg = null;
                    if (eMsg.length() <= 0) continue;
                    switch (eMsg.charAt(0)) {
                        case 'C': {
                            String sub;
                            ArrayList specInfo;
                            if (this.specialists == null) {
                                this.getSpecialists();
                            }
                            if ((specInfo = (ArrayList)this.specialists.get(sub = eMsg.substring(1))) == null) {
                                bMsg = "Class";
                                break;
                            }
                            PObject pobj = new PObject();
                            pobj.setName(sub);
                            pobj.addAllToAssociated(specInfo);
                            if (classWithSpell.contains(pobj)) break;
                            classWithSpell.add(pobj);
                            break;
                        }
                        case 'D': {
                            bMsg = "Domain";
                            break;
                        }
                    }
                    if (bMsg == null) continue;
                    Logging.errorPrint(bMsg + " not found: " + eMsg.substring(1));
                }
            }
            Iterator iClass = Globals.getClassList().iterator();
            while (iClass.hasNext()) {
                PCClass aClass = (PCClass)iClass.next();
                if (aClass.getSpellType().equals("None") || aClass.zeroCastSpells() || !"".equals(spellType) && spellType.indexOf(aClass.getSpellType()) < 0 || classWithSpell.contains(aClass)) continue;
                classWithSpell.add(aClass);
            }
        }
        if (this.spellBooks != 0) {
            for (int i4 = classWithSpell.size() - 1; i4 >= 0; --i4) {
                Object obj = classWithSpell.get(i4);
                if (this.spellBooks < 0) {
                    if (!(obj instanceof PCClass) || !((PCClass)obj).getSpellBookUsed()) continue;
                    classWithSpell.remove(i4);
                    continue;
                }
                if (obj instanceof PCClass && ((PCClass)obj).getSpellBookUsed()) continue;
                classWithSpell.remove(i4);
            }
        }
        Globals.sortPObjectList(classWithSpell);
        this.cmbClass.setModel(new DefaultComboBoxModel<Object>(classWithSpell.toArray()));
        switch (this.eqType) {
            case 0: {
                maxLevel = Math.min(maxLevel, SettingsHandler.getMaxPotionSpellLevel());
                break;
            }
            case 2: {
                maxLevel = Math.min(maxLevel, SettingsHandler.getMaxWandSpellLevel());
                break;
            }
        }
        if (this.levelList != null && this.levelList.size() > 0) {
            levelsForCasting = new Integer[this.levelList.size()];
            for (i = minLevel; i < this.levelList.size(); ++i) {
                levelsForCasting[i] = new Integer((String)this.levelList.get(i));
            }
        } else {
            levelsForCasting = new Integer[maxLevel - minLevel + 1];
            for (i = minLevel; i <= maxLevel; ++i) {
                levelsForCasting[i - minLevel] = new Integer(i);
            }
        }
        this.cmbBaseSpellLevel.setModel(new DefaultComboBoxModel<Integer>(levelsForCasting));
        levelsForCasting = new Integer[20];
        for (i = 1; i <= 20; ++i) {
            levelsForCasting[i - 1] = new Integer(i);
        }
        this.cmbCasterLevel.setModel(new DefaultComboBoxModel<Integer>(levelsForCasting));
        if (this.metaAllowed) {
            ArrayList<Feat> metamagicFeats = new ArrayList<Feat>();
            Iterator e = Globals.getFeatList().iterator();
            while (e.hasNext()) {
                Feat aFeat = (Feat)e.next();
                if (!aFeat.isType("Metamagic")) continue;
                metamagicFeats.add(aFeat);
            }
            Globals.sortPObjectListByName(metamagicFeats);
            this.lstMetamagicFeats.setListData(metamagicFeats.toArray());
        }
        this.cmbClassLevelActionPerformed(null, -1);
        this.pack();
    }

    private static final class SpellShell
    implements Serializable,
    Comparable {
        private Spell aSpell = null;

        SpellShell(Spell argSpell) {
            this.aSpell = argSpell;
        }

        public int compareTo(Object obj) {
            if (obj != null) {
                return this.toString().compareToIgnoreCase(obj.toString());
            }
            return 1;
        }

        public String toString() {
            if (this.aSpell != null) {
                return this.aSpell.getOutputName();
            }
            return "";
        }

        Spell getSpell() {
            return this.aSpell;
        }
    }
}

