/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class CsheetFilter
extends FileFilter
implements FilenameFilter {
    private static final String chaTemplates = PropertyFactory.getString("in_chaTemplates");
    private List acceptedList = null;
    private String dirFilter = null;
    private String ignoreExtension = ".fo";
    private int sheetType = 0;

    public CsheetFilter() {
    }

    public CsheetFilter(int sheetTypeInt) {
        this.sheetType = sheetTypeInt;
    }

    public List getAccepted() {
        this.acceptedList = new ArrayList();
        this.accept(SettingsHandler.getPcgenOutputSheetDir());
        return this.acceptedList;
    }

    public String getDescription() {
        return chaTemplates;
    }

    public void setDirFilter(String arg) {
        this.dirFilter = arg;
    }

    public void setIgnoreExtension(String arg) {
        this.ignoreExtension = arg;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            File[] fileList = f.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                this.accept(fileList[i]);
            }
            return true;
        }
        return this.accept(f.getParentFile(), f.getName());
    }

    public boolean accept(File dir, String name) {
        String s = name.toLowerCase();
        File aFile = new File(dir + File.separator + name);
        if (aFile.isDirectory()) {
            return this.accept(aFile);
        }
        if (!aFile.getParent().endsWith(File.separator + this.dirFilter)) {
            return false;
        }
        if ((!s.endsWith(this.ignoreExtension) || s.endsWith(this.ignoreExtension) && Logging.isDebugMode()) && (this.sheetType == 0 && s.startsWith("csheet") || this.sheetType == 1 && s.startsWith("psheet"))) {
            if (this.acceptedList != null) {
                try {
                    String filename = dir.getAbsolutePath().substring(SettingsHandler.getPcgenOutputSheetDir().getAbsolutePath().length() + 1) + File.separator + name;
                    this.acceptedList.add(filename);
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }
}

