/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.EqBuilder;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public final class EQFrame
extends JFrame {
    private EqBuilder mainEq = null;
    private PlayerCharacter aPC;

    public EQFrame(PlayerCharacter aPC) {
        super(PropertyFactory.getString("in_itemCustomizer"));
        this.aPC = aPC;
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif"));
        this.setIconImage(img);
        this.setDefaultCloseOperation(0);
        this.mainEq = new EqBuilder(aPC);
        this.mainEq.setParentWindow(this);
        Container contentPane = this.getContentPane();
        contentPane.add(this.mainEq);
        this.pack();
        Dimension customizerDim = SettingsHandler.getCustomizerDimension();
        Point customizerLoc = SettingsHandler.getCustomizerLeftUpperCorner();
        int x = -11;
        int y = -11;
        if (customizerLoc != null) {
            x = (int)customizerLoc.getX();
            y = (int)customizerLoc.getY();
        }
        if (x < -10 || y < -10 || customizerDim == null || customizerDim.height == 0 || customizerDim.width == 0) {
            Utility.centerFrame(this, true);
        } else {
            this.setLocation(customizerLoc);
            this.setSize(customizerDim);
        }
    }

    public boolean setEquipment(Equipment aEq) {
        if (this.mainEq != null) {
            return this.mainEq.setEquipment(aEq);
        }
        return false;
    }

    public void toFront() {
        super.toFront();
        if (this.mainEq != null) {
            this.mainEq.toFront();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.handleQuit(true);
        }
    }

    void exitItem_actionPerformed(boolean bCancelled) {
        this.handleQuit(bCancelled);
    }

    private void handleQuit(boolean bCancelled) {
        if (!bCancelled) {
            SettingsHandler.setCustomizerLeftUpperCorner(this.getLocationOnScreen());
            SettingsHandler.setCustomizerDimension(this.getSize());
            SettingsHandler.writeOptionsProperties(this.aPC);
        }
        Globals.setCurrentFrame(null);
        this.dispose();
    }
}

