/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialProperty;
import pcgen.core.SystemCollections;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.ChooseSpellDialog;
import pcgen.gui.EQFrame;
import pcgen.gui.NewWeaponInfoDialog;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.util.Delta;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class EqBuilder
extends JPanel {
    static final long serialVersionUID = -369105812700996734L;
    private static TableSorter sorter;
    static String[] validEqTypes;
    public static final int EQTYPE_NONE = -1;
    public static final int EQTYPE_POTION = 0;
    public static final int EQTYPE_SCROLL = 1;
    public static final int EQTYPE_WAND = 2;
    public static final int EQTYPE_RING = 3;
    private DefaultListModel listModel1;
    private DefaultListModel listModel2;
    private Equipment aNewEq = null;
    private Equipment baseEquipment = null;
    private EquipmentModModel dataModel = new EquipmentModModel();
    private EQFrame parentFrame = null;
    private FlippingSplitPane jSplitPane2;
    private FlippingSplitPane jSplitPane3;
    private JButton jButtonAdd1;
    private JButton jButtonAdd2;
    private JButton jButtonCancel;
    private JButton jButtonCost;
    private JButton jButtonName;
    private JButton jButtonOk;
    private JButton jButtonPurchase;
    private JButton jButtonRemove1;
    private JButton jButtonRemove2;
    private JButton jButtonSProp;
    private JButton jButtonWeight;
    private JButton jButtonDamage;
    private JComboBoxEx jComboBoxSize;
    private JLabel jLabelSize;
    private JList jListSelected1;
    private JList jListSelected2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanelAvailables;
    private JPanel jPanelButtons1;
    private JPanel jPanelButtons2;
    private JPanel jPanelModifiers;
    private JPanel jPanelOkCancel;
    private JPanel jPanelSelected1;
    private JPanel jPanelSelected2;
    private JPanel jPanelSelections;
    private JScrollPane jScrollPane2;
    private JScrollPane jScroll_ListAvailable;
    private JScrollPane jScroll_ListSelected1;
    private JScrollPane jScroll_ListSelected2;
    private JTableEx jListAvailable;
    private JTextPane jItemDesc;
    private List displayModifiers = new ArrayList();
    private String customName = "";
    private ArrayList[] newTypeList = new ArrayList[]{null, null};
    private int eqType = -1;
    private int iListCount = 0;
    private PlayerCharacter aPC;
    static /* synthetic */ Class class$java$lang$String;

    EqBuilder(PlayerCharacter apc) {
        this.aPC = apc;
        this.initComponents();
    }

    public void setParentWindow(EQFrame aFrame) {
        this.parentFrame = aFrame;
        Globals.setCurrentFrame(this.parentFrame);
    }

    public boolean setEquipment(Equipment aEq) {
        return this.setEquipment(aEq, false);
    }

    public void toFront() {
        block0 : switch (this.eqType) {
            case 0: 
            case 1: 
            case 2: {
                for (int idx = 0; idx < this.displayModifiers.size(); ++idx) {
                    EquipmentModifier eqMod = (EquipmentModifier)this.displayModifiers.get(idx);
                    if (!eqMod.getKeyName().startsWith("SE_") || eqMod.getMyTypeCount() != 1) continue;
                    idx = sorter.translateRow(idx);
                    this.jListAvailable.setRowSelectionInterval(idx, idx);
                    this.jButtonAdd1ActionPerformed();
                    break block0;
                }
                break;
            }
        }
    }

    private static void setGuiTextInfo(Object obj, String in_String) {
        Utility.setGuiTextInfo(obj, "in_EqBuilder_" + in_String);
    }

    private boolean setEquipment(Equipment aEq, boolean bReloading) {
        this.listModel1.clear();
        this.listModel2.clear();
        String sBaseKey = aEq.getBaseItemName();
        if (!bReloading) {
            this.customName = "";
            this.baseEquipment = !sBaseKey.equals(aEq.getName()) ? EquipmentList.getEquipmentKeyed(sBaseKey) : aEq;
        }
        this.eqType = -1;
        for (int idx = 0; idx < validEqTypes.length; ++idx) {
            if (!aEq.isType(validEqTypes[idx])) continue;
            this.eqType = idx;
            break;
        }
        if (aEq.getEqModifierList(true).size() == 0 && aEq.getEqModifierList(false).size() == 0) {
            Iterator e = EquipmentList.getModifierList().iterator();
            while (e.hasNext()) {
                EquipmentModifier eqMod = (EquipmentModifier)e.next();
                if (!eqMod.getName().startsWith("EXCLUDEEQ")) continue;
                List typeList = eqMod.getItemType();
                Iterator e2 = typeList.iterator();
                while (e2.hasNext()) {
                    String type = (String)e2.next();
                    if (!aEq.isEitherType(type.toUpperCase())) continue;
                    ShowMessageDelegate.showMessageDialog("This item already has type: " + type + ". Select the base item and modify it instead.", "PCGen", MessageType.ERROR);
                    return false;
                }
            }
        }
        if (this.baseEquipment == null) {
            Logging.errorPrint("No base equipment found: " + aEq.getName() + ", aborting EqBuilder:" + sBaseKey);
            return false;
        }
        this.iListCount = bReloading ? (aEq.isWeapon() && aEq.isDouble() ? 2 : 1) : (this.baseEquipment.isWeapon() && this.baseEquipment.isDouble() ? 2 : 1);
        this.jListSelected1.setSelectionMode(0);
        this.jListSelected1.setModel(this.listModel1);
        this.jPanelButtons1.setVisible(true);
        if (bReloading) {
            this.dataModel.setFilter(aEq, this.iListCount);
        } else {
            this.dataModel.setFilter(this.baseEquipment, this.iListCount);
        }
        boolean showSize = Globals.canResizeHaveEffect(this.aPC, aEq, aEq.typeList());
        this.jLabelSize.setVisible(showSize);
        this.jComboBoxSize.setVisible(showSize);
        this.jButtonDamage.setVisible(aEq.isWeapon());
        String eqSize = aEq.getSize();
        int iSize = Globals.sizeInt(eqSize);
        this.setItemSize(SystemCollections.getSizeAdjustmentAtIndex(iSize).getName());
        if (!bReloading) {
            this.aNewEq = (Equipment)aEq.clone();
        }
        this.jPanelSelected2.setVisible(this.iListCount > 1);
        this.loadScreenInfo();
        this.updateDisplay(true);
        this.updateDisplay(false);
        return true;
    }

    private void setItemSize(String aNewSize) {
        for (int i = 0; i < this.jComboBoxSize.getItemCount(); ++i) {
            String aSize = (String)this.jComboBoxSize.getItemAt(i);
            if (!aSize.equalsIgnoreCase(aNewSize)) continue;
            this.jComboBoxSize.setSelectedIndex(i);
            return;
        }
    }

    private int getItemSize() {
        int idx = this.jComboBoxSize.getSelectedIndex();
        if (idx >= 0) {
            String aSize = (String)this.jComboBoxSize.getItemAt(idx);
            for (int i = 0; i <= SystemCollections.getSizeAdjustmentListSize() - 1; ++i) {
                if (!SystemCollections.getSizeAdjustmentAtIndex(i).getName().equalsIgnoreCase(aSize)) continue;
                return i;
            }
        }
        return -1;
    }

    private void addButton(boolean bPrimary) {
        this.jButtonAdd1.setEnabled(false);
        this.jButtonAdd2.setEnabled(false);
        Globals.setCurrentFrame(this.parentFrame);
        this.aNewEq.setCostMod("0");
        ListSelectionModel lsm = this.jListAvailable.getSelectionModel();
        int iSelected = lsm.getMinSelectionIndex();
        if (iSelected >= 0 && (iSelected = sorter.getRowTranslated(iSelected)) >= 0) {
            EquipmentModifier eqMod = (EquipmentModifier)this.displayModifiers.get(iSelected);
            if (eqMod.getChoiceString().startsWith("EQBUILDER.SPELL")) {
                this.jButtonSpellActionPerformed(eqMod, eqMod.getChoiceString().substring(15));
                return;
            }
            this.aNewEq.addEqModifier(eqMod, bPrimary, this.aPC);
            this.setEquipment(this.aNewEq, true);
            this.updateDisplay(bPrimary);
            if (this.aNewEq.isDouble() && eqMod.getAssignToAll()) {
                this.aNewEq.addEqModifier(eqMod, !bPrimary, this.aPC);
                this.updateDisplay(!bPrimary);
            }
            ((EQFrame)this.getRootPane().getParent()).setVisible(true);
            ((EQFrame)this.getRootPane().getParent()).toFront();
            Globals.getCurrentFrame().requestFocus();
        }
    }

    private void doCleanUp() {
        this.aNewEq = null;
        this.newTypeList[0] = null;
        this.newTypeList[1] = null;
        this.saveScreenInfo();
    }

    private void initComponents() {
        this.listModel1 = new DefaultListModel();
        this.listModel2 = new DefaultListModel();
        this.jPanel1 = new JPanel();
        this.jPanelOkCancel = new JPanel();
        this.jPanel3 = new JPanel();
        JPanel attribButtonPanel = new JPanel();
        this.jLabelSize = new JLabel();
        this.jButtonName = new JButton();
        this.jButtonSProp = new JButton();
        this.jButtonCost = new JButton();
        this.jButtonWeight = new JButton();
        this.jButtonDamage = new JButton();
        this.jComboBoxSize = new JComboBoxEx();
        JPanel actionButtonPanel = new JPanel();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonPurchase = new JButton();
        this.jSplitPane2 = new FlippingSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jItemDesc = new JTextPane();
        this.jPanelModifiers = new JPanel();
        this.jSplitPane3 = new FlippingSplitPane();
        this.jPanelAvailables = new JPanel();
        this.jScroll_ListAvailable = new JScrollPane();
        JPanel sizePanel = new JPanel();
        EqBuilder.setGuiTextInfo(this.jLabelSize, "Size");
        sorter = new TableSorter(this.dataModel);
        this.jListAvailable = new JTableEx(sorter);
        this.jListAvailable.setAutoResizeMode(0);
        sorter.addMouseListenerToHeaderInTable(this.jListAvailable);
        this.jPanel5 = new JPanel();
        this.jPanelSelections = new JPanel();
        this.jPanelSelected1 = new JPanel();
        this.jPanel20 = new JPanel();
        this.jPanelButtons1 = new JPanel();
        this.jButtonAdd1 = new JButton();
        this.jButtonRemove1 = new JButton();
        this.jPanel21 = new JPanel();
        this.jScroll_ListSelected1 = new JScrollPane();
        this.jListSelected1 = new JList(this.listModel1);
        this.jPanelSelected2 = new JPanel();
        this.jPanel22 = new JPanel();
        this.jPanelButtons2 = new JPanel();
        this.jButtonAdd2 = new JButton();
        this.jButtonRemove2 = new JButton();
        this.jPanel23 = new JPanel();
        this.jScroll_ListSelected2 = new JScrollPane();
        this.jListSelected2 = new JList(this.listModel2);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(640, 480));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(640, 480));
        this.jPanelOkCancel.setLayout(new BoxLayout(this.jPanelOkCancel, 0));
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagLayout gridbag = new GridBagLayout();
        attribButtonPanel.setLayout(gridbag);
        EqBuilder.setGuiTextInfo(this.jButtonName, "Name");
        this.jButtonName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonNameActionPerformed();
            }
        });
        this.jButtonName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonNameActionPerformed();
            }
        });
        attribButtonPanel.add(this.jButtonName);
        EqBuilder.setGuiTextInfo(this.jButtonSProp, "SProp");
        this.jButtonSProp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonSPropActionPerformed();
            }
        });
        this.jButtonSProp.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonSPropActionPerformed();
            }
        });
        attribButtonPanel.add(this.jButtonSProp);
        EqBuilder.setGuiTextInfo(this.jButtonCost, "Cost");
        this.jButtonCost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonCostActionPerformed();
            }
        });
        this.jButtonCost.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonCostActionPerformed();
            }
        });
        attribButtonPanel.add(this.jButtonCost);
        EqBuilder.setGuiTextInfo(this.jButtonWeight, "Weight");
        this.jButtonWeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonWeightActionPerformed();
            }
        });
        this.jButtonWeight.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonWeightActionPerformed();
            }
        });
        attribButtonPanel.add(this.jButtonWeight);
        EqBuilder.setGuiTextInfo(this.jButtonDamage, "Damage");
        this.jButtonDamage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonDamageActionPerformed();
            }
        });
        this.jButtonDamage.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonDamageActionPerformed();
            }
        });
        attribButtonPanel.add(this.jButtonDamage);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel3.add((Component)attribButtonPanel, gridBagConstraints1);
        this.jPanelOkCancel.add(this.jPanel3);
        actionButtonPanel.setLayout(new BoxLayout(actionButtonPanel, 0));
        EqBuilder.setGuiTextInfo(this.jButtonCancel, "Cancel");
        this.jButtonCancel.setPreferredSize(new Dimension(81, 27));
        this.jButtonCancel.setMaximumSize(new Dimension(81, 27));
        this.jButtonCancel.setMinimumSize(new Dimension(81, 27));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonCancelActionPerformed();
            }
        });
        this.jButtonCancel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonCancelActionPerformed();
            }
        });
        actionButtonPanel.add(this.jButtonCancel);
        EqBuilder.setGuiTextInfo(this.jButtonOk, "Ok");
        this.jButtonOk.setPreferredSize(new Dimension(81, 27));
        this.jButtonOk.setMaximumSize(new Dimension(81, 27));
        this.jButtonOk.setMinimumSize(new Dimension(81, 27));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonOkActionPerformed(false);
            }
        });
        this.jButtonOk.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonOkActionPerformed(false);
            }
        });
        actionButtonPanel.add(this.jButtonOk);
        EqBuilder.setGuiTextInfo(this.jButtonPurchase, "Purchase");
        this.jButtonPurchase.setPreferredSize(new Dimension(81, 27));
        this.jButtonPurchase.setMaximumSize(new Dimension(81, 27));
        this.jButtonPurchase.setMinimumSize(new Dimension(81, 27));
        this.jButtonPurchase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonOkActionPerformed(true);
            }
        });
        this.jButtonPurchase.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonOkActionPerformed(true);
            }
        });
        actionButtonPanel.add(this.jButtonPurchase);
        this.jPanelOkCancel.add(actionButtonPanel);
        this.jPanel1.add((Component)this.jPanelOkCancel, "South");
        this.jSplitPane2.setDividerSize(5);
        this.jSplitPane2.setOrientation(0);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(44, 70));
        this.jItemDesc.setEditable(false);
        this.jItemDesc.setBackground(this.jPanel1.getBackground());
        this.jScrollPane2.setViewportView(this.jItemDesc);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane2.setLeftComponent(this.jPanel2);
        this.jPanelModifiers.setLayout(new BoxLayout(this.jPanelModifiers, 0));
        this.jPanelModifiers.setPreferredSize(new Dimension(640, 300));
        this.jSplitPane3.setDividerSize(5);
        this.jSplitPane3.setPreferredSize(new Dimension(640, 407));
        this.jPanelAvailables.setLayout(new BorderLayout());
        this.jPanelAvailables.setPreferredSize(new Dimension(340, 403));
        this.jListAvailable.setSelectionMode(0);
        this.jListAvailable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jListAvailableMouseClicked(evt);
            }
        });
        this.jScroll_ListAvailable.setViewportView(this.jListAvailable);
        this.jPanelAvailables.add((Component)this.jScroll_ListAvailable, "Center");
        this.jSplitPane3.setLeftComponent(this.jPanelAvailables);
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        this.jPanel5.setPreferredSize(new Dimension(200, 400));
        this.jPanelSelections.setLayout(new BoxLayout(this.jPanelSelections, 1));
        this.jPanelSelected1.setLayout(new BoxLayout(this.jPanelSelected1, 0));
        this.jPanelButtons1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        JLabel fillerTemplate = new JLabel(" ");
        this.jPanelButtons1.add((Component)new Box.Filler(fillerTemplate.getMinimumSize(), fillerTemplate.getPreferredSize(), fillerTemplate.getMaximumSize()), gridBagConstraints2);
        EqBuilder.setGuiTextInfo(this.jButtonAdd1, "Add1");
        this.jButtonAdd1.setPreferredSize(new Dimension(81, 27));
        this.jButtonAdd1.setMaximumSize(new Dimension(81, 27));
        this.jButtonAdd1.setMinimumSize(new Dimension(81, 27));
        this.jButtonAdd1.setEnabled(false);
        this.jButtonAdd1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonAdd1ActionPerformed();
            }
        });
        this.jButtonAdd1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonAdd1ActionPerformed();
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        this.jPanelButtons1.add((Component)this.jButtonAdd1, gridBagConstraints2);
        EqBuilder.setGuiTextInfo(this.jButtonRemove1, "Remove1");
        this.jButtonRemove1.setPreferredSize(new Dimension(81, 27));
        this.jButtonRemove1.setEnabled(false);
        this.jButtonRemove1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonRemove1ActionPerformed();
            }
        });
        this.jButtonRemove1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonRemove1ActionPerformed();
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        this.jPanelButtons1.add((Component)this.jButtonRemove1, gridBagConstraints2);
        this.jPanelButtons1.setAlignmentY(0.5f);
        this.jPanel20.add(this.jPanelButtons1);
        this.jPanelSelected1.add(this.jPanel20);
        sizePanel.add(this.jLabelSize);
        this.jComboBoxSize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EqBuilder.this.jComboBoxSizeActionPerformed();
            }
        });
        sizePanel.add(this.jComboBoxSize);
        this.jPanelSelections.add(sizePanel);
        this.jPanel21.setLayout(new BorderLayout());
        this.jListSelected1.setSelectionMode(0);
        this.jListSelected1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jListSelected1MouseClicked(evt);
            }
        });
        this.jScroll_ListSelected1.setViewportView(this.jListSelected1);
        this.jPanel21.add((Component)new JLabel(PropertyFactory.getString("in_EqBuilder_Sel1"), 0), "North");
        this.jPanel21.add((Component)this.jScroll_ListSelected1, "Center");
        this.jPanelSelected1.add(this.jPanel21);
        this.jPanelSelections.add(this.jPanelSelected1);
        this.jPanelSelected2.setLayout(new BoxLayout(this.jPanelSelected2, 0));
        this.jPanelButtons2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 0;
        this.jPanelButtons2.add((Component)new Box.Filler(fillerTemplate.getMinimumSize(), fillerTemplate.getPreferredSize(), fillerTemplate.getMaximumSize()), gridBagConstraints3);
        EqBuilder.setGuiTextInfo(this.jButtonAdd2, "Add2");
        this.jButtonAdd2.setPreferredSize(new Dimension(81, 27));
        this.jButtonAdd2.setMaximumSize(new Dimension(81, 27));
        this.jButtonAdd2.setMinimumSize(new Dimension(81, 27));
        this.jButtonAdd2.setEnabled(false);
        this.jButtonAdd2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonAdd2ActionPerformed();
            }
        });
        this.jButtonAdd2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonAdd2ActionPerformed();
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 1;
        this.jPanelButtons2.add((Component)this.jButtonAdd2, gridBagConstraints3);
        EqBuilder.setGuiTextInfo(this.jButtonRemove2, "Remove2");
        this.jButtonRemove2.setPreferredSize(new Dimension(81, 27));
        this.jButtonRemove2.setEnabled(false);
        this.jButtonRemove2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EqBuilder.this.jButtonRemove2ActionPerformed();
            }
        });
        this.jButtonRemove2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jButtonRemove2ActionPerformed();
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridy = 2;
        this.jPanelButtons2.add((Component)this.jButtonRemove2, gridBagConstraints3);
        this.jPanel22.add(this.jPanelButtons2);
        this.jPanelSelected2.add(this.jPanel22);
        this.jPanel23.setLayout(new BorderLayout());
        this.jListSelected2.setSelectionMode(0);
        this.jListSelected2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EqBuilder.this.jListSelected2MouseClicked(evt);
            }
        });
        this.jScroll_ListSelected2.setViewportView(this.jListSelected2);
        this.jPanel23.add((Component)new JLabel(PropertyFactory.getString("in_EqBuilder_Sel2"), 0), "North");
        this.jPanel23.add((Component)this.jScroll_ListSelected2, "Center");
        this.jPanelSelected2.add(this.jPanel23);
        this.jPanelSelections.add(this.jPanelSelected2);
        this.jPanel5.add(this.jPanelSelections);
        this.jSplitPane3.setRightComponent(this.jPanel5);
        this.jPanelModifiers.add(this.jSplitPane3);
        this.jSplitPane2.setRightComponent(this.jPanelModifiers);
        this.jPanel1.add((Component)this.jSplitPane2, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jComboBoxSize.setModel(new DefaultComboBoxModel<String>(EqBuilder.populateSizeModel()));
        this.jSplitPane2.setDividerLocation(SettingsHandler.getCustomizerSplit1());
        this.jSplitPane3.setDividerLocation(SettingsHandler.getCustomizerSplit2());
        this.jScroll_ListAvailable.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension dimMax = EqBuilder.this.jScroll_ListAvailable.getSize();
                Dimension dimCur = EqBuilder.this.jListAvailable.getSize();
                if (dimCur.getWidth() < dimMax.getWidth()) {
                    EqBuilder.this.jListAvailable.setSize((int)dimMax.getWidth(), (int)dimCur.getHeight());
                    int[] cols = new int[]{EqBuilder.this.jListAvailable.getColumnCount() - 1};
                    EqBuilder.this.jListAvailable.setOptimalColumnWidths(cols);
                }
            }
        });
    }

    private static String[] populateSizeModel() {
        String[] sizeStrings = new String[SystemCollections.getSizeAdjustmentListSize()];
        for (int i = 0; i < SystemCollections.getSizeAdjustmentListSize(); ++i) {
            sizeStrings[i] = SystemCollections.getSizeAdjustmentAtIndex(i).getName();
        }
        return sizeStrings;
    }

    private void jButtonAdd1ActionPerformed() {
        this.addButton(true);
    }

    private void jButtonAdd2ActionPerformed() {
        this.addButton(false);
    }

    private void jButtonCancelActionPerformed() {
        this.doCleanUp();
        ((EQFrame)this.getRootPane().getParent()).exitItem_actionPerformed(true);
    }

    private void jButtonCostActionPerformed() {
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Enter Item's New Cost", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getCost(this.aPC).toString());
        if (selectedValue != null) {
            String aString = ((String)selectedValue).trim();
            try {
                BigDecimal newCost = new BigDecimal(aString);
                if (newCost.doubleValue() < 0.0) {
                    ShowMessageDelegate.showMessageDialog("Cost cannot be negative!", "PCGen", MessageType.ERROR);
                    return;
                }
                this.aNewEq.setCostMod("0");
                this.aNewEq.setCostMod(newCost.subtract(this.aNewEq.getCost(this.aPC)));
                this.showItemInfo(this.aPC);
            }
            catch (Exception e) {
                ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
            }
        }
    }

    private void jButtonNameActionPerformed() {
        InputInterface ii;
        Object selectedValue;
        String defaultName = this.customName;
        if (defaultName.length() == 0) {
            defaultName = this.aNewEq.getItemNameFromModifiers();
        }
        if ((selectedValue = (ii = InputFactory.getInputInstance()).showInputDialog(null, "Enter the new name", "PCGen", MessageType.INFORMATION, null, defaultName)) != null) {
            String aString = ((String)selectedValue).trim();
            if (aString.indexOf(124) >= 0 || aString.indexOf(58) >= 0 || aString.indexOf(59) >= 0) {
                ShowMessageDelegate.showMessageDialog("Invalid character in string! You cannot use '|', ':' or ';' in this entry", "PCGen", MessageType.ERROR);
            } else {
                this.customName = aString;
                StringBuffer oldName = new StringBuffer("(").append(this.aNewEq.getItemNameFromModifiers()).append(")");
                block3: for (int i = 0; i < oldName.length(); ++i) {
                    switch (oldName.charAt(i)) {
                        case ':': 
                        case ';': 
                        case '|': {
                            oldName.setCharAt(i, '@');
                            continue block3;
                        }
                    }
                }
                if (!oldName.toString().toUpperCase().startsWith("Generic Item".toUpperCase())) {
                    this.aNewEq.addSpecialProperty(SpecialProperty.createFromLst(oldName.toString()));
                }
                String aSize = SystemCollections.getSizeAdjustmentAtIndex(this.getItemSize()).getAbbreviation();
                this.aNewEq.resizeItem(this.aPC, aSize);
                this.showItemInfo(this.aPC);
            }
        }
    }

    private void jButtonOkActionPerformed(boolean bPurchase) {
        String sName = this.aNewEq.getKeyName();
        if (this.customName.length() != 0) {
            sName = this.customName;
        }
        if (this.aNewEq.isWeapon() && !this.aNewEq.isMelee() && !this.aNewEq.isRanged()) {
            ShowMessageDelegate.showMessageDialog("Weapons must either be Melee or Ranged", "PCGen", MessageType.INFORMATION);
            return;
        }
        if (sName.toUpperCase().startsWith("Generic Item".toUpperCase())) {
            ShowMessageDelegate.showMessageDialog("You must rename this item!", "PCGen", MessageType.INFORMATION);
            return;
        }
        if (EquipmentList.getEquipmentKeyed(sName) != null) {
            ShowMessageDelegate.showMessageDialog("There is already an existing item: " + sName, "PCGen", MessageType.INFORMATION);
            return;
        }
        this.aNewEq.setName(sName);
        this.aNewEq.setOutputName(sName);
        this.aNewEq.removeType("AUTO_GEN");
        this.aNewEq.removeType("STANDARD");
        if (this.aNewEq.getModifiersRequired() && this.aNewEq.getEqModifierList(true).size() == 0 && this.aNewEq.getEqModifierList(false).size() == 0) {
            ShowMessageDelegate.showMessageDialog("You must add at least 1 modifier to this item first.", "PCGen", MessageType.ERROR);
            return;
        }
        if (this.aNewEq.getBaseItemName().toUpperCase().startsWith("Generic Item".toUpperCase())) {
            this.aNewEq.setBaseItem("");
        }
        if (!EquipmentList.addEquipment(this.aNewEq)) {
            ShowMessageDelegate.showMessageDialog("Error adding item to list.", "PCGen", MessageType.INFORMATION);
            return;
        }
        PCGen_Frame1.getInst().eqList_Changed(this.aNewEq, bPurchase);
        this.doCleanUp();
        ((EQFrame)this.getRootPane().getParent()).exitItem_actionPerformed(false);
    }

    private void jButtonRemove1ActionPerformed() {
        this.jButtonRemove1.setEnabled(false);
        this.removeButton(this.listModel1, this.jListSelected1.getSelectedIndex(), true);
    }

    private void jButtonRemove2ActionPerformed() {
        this.jButtonRemove2.setEnabled(false);
        this.removeButton(this.listModel2, this.jListSelected2.getSelectedIndex(), false);
    }

    private void jButtonSPropActionPerformed() {
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Enter Special Property", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getRawSpecialProperties());
        if (selectedValue != null) {
            String aString = ((String)selectedValue).trim();
            if (aString.indexOf(124) >= 0 || aString.indexOf(58) >= 0 || aString.indexOf(59) >= 0) {
                ShowMessageDelegate.showMessageDialog("Invalid character in string! You cannot use '|', ':' or ';' in this entry", "PCGen", MessageType.ERROR);
            } else {
                this.aNewEq.addSpecialProperty(SpecialProperty.createFromLst(aString));
                String aSize = SystemCollections.getSizeAdjustmentAtIndex(this.getItemSize()).getAbbreviation();
                this.aNewEq.resizeItem(this.aPC, aSize);
                this.showItemInfo(this.aPC);
            }
        }
    }

    private void jButtonSpellActionPerformed(EquipmentModifier eqMod, String extraInfo) {
        ArrayList<String> classList = null;
        ArrayList<String> levelList = null;
        boolean metaAllowed = true;
        int spellBooks = 0;
        if (extraInfo.length() != 0) {
            StringTokenizer aTok = new StringTokenizer(extraInfo, "|", false);
            block6: while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                if (aString.startsWith("CLASS=")) {
                    if (classList == null) {
                        classList = new ArrayList<String>();
                    }
                    classList.add(aString.substring(6));
                    continue;
                }
                if (aString.startsWith("LEVEL=")) {
                    if (levelList == null) {
                        levelList = new ArrayList<String>();
                    }
                    levelList.add(aString.substring(6));
                    continue;
                }
                if (aString.startsWith("SPELLBOOKS=")) {
                    switch (aString.charAt(11)) {
                        case 'Y': {
                            spellBooks = 1;
                            continue block6;
                        }
                        case 'N': {
                            spellBooks = -1;
                            continue block6;
                        }
                    }
                    spellBooks = 0;
                    continue;
                }
                if (!aString.equals("METAMAGIC=N")) continue;
                metaAllowed = false;
            }
        }
        ChooseSpellDialog csd = new ChooseSpellDialog((JFrame)Utility.getParentNamed(this.getParent(), "pcgen.gui.EQFrame"), this.aPC, this.eqType, metaAllowed, classList, levelList, spellBooks, eqMod.getChoiceString());
        csd.setVisible(true);
        if (!csd.getWasCancelled()) {
            EquipmentModifier existingEqMod;
            Object castingClass = csd.getCastingClass();
            Spell theSpell = csd.getSpell();
            String variant = csd.getVariant();
            String spellType = csd.getSpellType();
            int baseSpellLevel = csd.getBaseSpellLevel();
            int casterLevel = csd.getCasterLevel();
            Object[] metamagicFeats = csd.getMetamagicFeats();
            int charges = -1;
            if (eqMod.getMinCharges() > 0) {
                while (true) {
                    InputInterface ii;
                    Object selectedValue;
                    if ((selectedValue = (ii = InputFactory.getInputInstance()).showInputDialog(null, "Enter Number of Charges (" + Integer.toString(eqMod.getMinCharges()) + "-" + Integer.toString(eqMod.getMaxCharges()) + ")", "PCGen", MessageType.INFORMATION, null, Integer.toString(eqMod.getMaxCharges()))) == null) {
                        continue;
                    }
                    try {
                        String aString = ((String)selectedValue).trim();
                        charges = Integer.parseInt(aString);
                        if (charges < eqMod.getMinCharges()) continue;
                        if (charges <= eqMod.getMaxCharges()) break;
                    }
                    catch (Exception exc) {}
                }
            }
            if ((existingEqMod = this.aNewEq.getEqModifierKeyed(eqMod.getKeyName(), true)) != null) {
                existingEqMod.setSpellInfo((PObject)castingClass, theSpell, variant, spellType, baseSpellLevel, casterLevel, metamagicFeats, charges);
            } else {
                eqMod = (EquipmentModifier)eqMod.clone();
                eqMod.setSpellInfo((PObject)castingClass, theSpell, variant, spellType, baseSpellLevel, casterLevel, metamagicFeats, charges);
                this.aNewEq.addEqModifier(eqMod, true, this.aPC);
            }
            this.updateDisplay(true);
        }
    }

    private void jButtonWeightActionPerformed() {
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Enter Item's New Weight", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getWeight(this.aPC).toString());
        if (selectedValue != null) {
            String aString = ((String)selectedValue).trim();
            try {
                BigDecimal newWeight = new BigDecimal(aString);
                if (newWeight.doubleValue() < 0.0) {
                    ShowMessageDelegate.showMessageDialog("Weight cannot be negative!", "PCGen", MessageType.ERROR);
                    return;
                }
                this.aNewEq.setWeightMod("0");
                newWeight = newWeight.subtract(new BigDecimal(this.aNewEq.getWeightAsDouble(this.aPC)));
                this.aNewEq.setWeightMod(newWeight.toString());
                this.showItemInfo(this.aPC);
            }
            catch (Exception e) {
                ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
            }
        }
    }

    private void jButtonDamageActionPerformed() {
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Select the new damage for this weapon", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getDamage(this.aPC).toString());
        if (selectedValue != null) {
            String aString = ((String)selectedValue).trim();
            this.aNewEq.setDamageMod(aString);
            this.showItemInfo(this.aPC);
        }
    }

    private void jComboBoxSizeActionPerformed() {
        if (this.jComboBoxSize.getSelectedIndex() >= 0 && this.aNewEq != null) {
            String aSize = SystemCollections.getSizeAdjustmentAtIndex(this.getItemSize()).getAbbreviation();
            this.aNewEq.resizeItem(this.aPC, aSize);
            this.showItemInfo(this.aPC);
        }
    }

    private void jListAvailableMouseClicked(MouseEvent evt) {
        ListSelectionModel lsm = this.jListAvailable.getSelectionModel();
        int iSelected = lsm.getMinSelectionIndex();
        if (iSelected >= 0) {
            this.jButtonAdd1.setEnabled(sorter.getValueAt(iSelected, 0).equals("Y"));
            this.jButtonAdd2.setEnabled(sorter.getValueAt(iSelected, 1).equals("Y"));
            if (evt.getClickCount() == 2) {
                if (this.jButtonAdd1.isEnabled() && !this.jButtonAdd2.isEnabled()) {
                    this.jButtonAdd1ActionPerformed();
                } else if (!this.jButtonAdd1.isEnabled() && this.jButtonAdd2.isEnabled()) {
                    this.jButtonAdd2ActionPerformed();
                }
            }
        }
    }

    private void jListSelected1MouseClicked(MouseEvent evt) {
        if (this.jListSelected1.getSelectedIndex() != -1) {
            this.jButtonRemove1.setEnabled(true);
            if (evt.getClickCount() == 2) {
                this.jButtonRemove1ActionPerformed();
            }
        }
    }

    private void jListSelected2MouseClicked(MouseEvent evt) {
        if (this.jListSelected2.getSelectedIndex() != -1) {
            this.jButtonRemove2.setEnabled(true);
            if (evt.getClickCount() == 2) {
                this.jButtonRemove2ActionPerformed();
            }
        }
    }

    private void loadScreenInfo() {
        int i;
        String tbl = "EqBuilder" + String.valueOf((char)(65 + this.dataModel.getTableType()));
        int width = 0;
        for (i = this.jListAvailable.getColumnCount(); i > 0; --i) {
            TableColumn col = this.jListAvailable.getColumnModel().getColumn(i - 1);
            width = Globals.getCustColumnWidth(tbl, i - 1);
            if (width == 0) break;
            col.setPreferredWidth(width);
        }
        if (width == 0) {
            int[] cols = new int[i];
            for (i = this.jListAvailable.getColumnCount(); i > 0; --i) {
                cols[i - 1] = i - 1;
            }
            this.jListAvailable.setOptimalColumnWidths(cols);
        }
    }

    private boolean needRebuild(boolean bPrimary) {
        boolean bRebuild = false;
        int idx = bPrimary ? 0 : 1;
        ArrayList newTypes = null;
        ArrayList oldTypes = this.newTypeList[idx];
        EquipmentModifier aEqMod = this.aNewEq.getEqModifierKeyed("ADDTYPE", bPrimary);
        if (aEqMod != null) {
            newTypes = new ArrayList();
            aEqMod.addAssociatedTo(newTypes);
        }
        if (oldTypes == null && aEqMod != null || oldTypes != null && aEqMod == null) {
            bRebuild = true;
        } else if (oldTypes != null && newTypes != null) {
            if (oldTypes.size() != newTypes.size()) {
                bRebuild = true;
            } else {
                for (int i = 0; i < newTypes.size(); ++i) {
                    if (oldTypes.contains(newTypes.get(i))) continue;
                    bRebuild = true;
                    break;
                }
            }
        }
        this.newTypeList[idx] = newTypes != null ? (ArrayList)newTypes.clone() : null;
        return bRebuild;
    }

    private void removeAddedType(String addedType) {
        EquipmentModifier eqMod = this.aNewEq.getEqModifierKeyed("ADDTYPE", true);
        if (eqMod != null && eqMod.removeAssociated(addedType) && eqMod.getAssociatedCount() == 0) {
            this.aNewEq.removeEqModifier(eqMod, true);
        }
    }

    private void removeButton(DefaultListModel lm, int idx, boolean bPrimary) {
        this.removeElement(lm, idx, bPrimary);
    }

    private void removeElement(DefaultListModel lm, int idx, boolean bPrimary) {
        if (idx >= 0 && idx < lm.size()) {
            EquipmentModifier eqMod = (EquipmentModifier)lm.elementAt(idx);
            if (this.baseEquipment.getEqModifierList(bPrimary).contains(eqMod)) {
                ShowMessageDelegate.showMessageDialog("That modifier is part of the base item. You cannot remove it.", "PCGen", MessageType.ERROR);
                return;
            }
            this.aNewEq.setCostMod("0");
            this.aNewEq.removeEqModifier(eqMod, bPrimary);
            this.setEquipment(this.aNewEq, true);
            this.updateDisplay(bPrimary);
            if (this.aNewEq.isDouble() && eqMod.getAssignToAll()) {
                this.aNewEq.removeEqModifier(eqMod, !bPrimary);
                this.updateDisplay(!bPrimary);
            }
            ((EQFrame)this.getRootPane().getParent()).setVisible(true);
            ((EQFrame)this.getRootPane().getParent()).toFront();
        }
    }

    private void saveScreenInfo() {
        String tbl = "EqBuilder" + String.valueOf((char)(65 + this.dataModel.getTableType()));
        SettingsHandler.setCustomizerSplit1(this.jSplitPane2.getDividerLocation());
        SettingsHandler.setCustomizerSplit2(this.jSplitPane3.getDividerLocation());
        for (int i = this.jListAvailable.getColumnCount(); i > 0; --i) {
            TableColumn col = this.jListAvailable.getColumnModel().getColumn(i - 1);
            Globals.setCustColumnWidth(tbl, i - 1, col.getWidth());
        }
    }

    private void showItemInfo(PlayerCharacter aPC) {
        StringBuffer aInfo = new StringBuffer(140);
        aInfo.append("Base Item: ").append(this.baseEquipment.getName()).append(Constants.s_LINE_SEP);
        if (this.customName.length() != 0) {
            aInfo.append("Name: ").append(this.customName).append(Constants.s_LINE_SEP);
        }
        String sprop = "";
        if (this.needRebuild(true) || this.needRebuild(false)) {
            if (this.aNewEq.isContainer()) {
                // empty if block
            }
            if (this.aNewEq.isWeapon() && this.aNewEq.getDamage(aPC).length() == 0) {
                NewWeaponInfoDialog nwid = new NewWeaponInfoDialog((JFrame)Utility.getParentNamed(this.getParent(), "pcgen.gui.EQFrame"));
                nwid.setVisible(true);
                if (!nwid.getWasCancelled()) {
                    StringBuffer modString = new StringBuffer("PCGENi_WEAPON");
                    modString.append("|DAMAGE=").append(nwid.getDamage());
                    modString.append("|CRITRANGE=").append(nwid.getCritRange());
                    modString.append("|CRITMULT=").append(nwid.getCritMultiplier());
                    this.aNewEq.addEqModifiers(modString.toString(), true);
                } else {
                    this.removeAddedType("WEAPON");
                }
            }
            String modString = "PCGENi_WEAPON|RANGE=";
            if (this.aNewEq.isWeapon() && this.aNewEq.isRanged()) {
                while (this.aNewEq.getRange(aPC) == 0) {
                    InputInterface ii = InputFactory.getInputInstance();
                    Object selectedValue = ii.showInputDialog(null, "Enter the range", "PCGen", MessageType.INFORMATION, null, null);
                    if (selectedValue != null) {
                        String aString = ((String)selectedValue).trim();
                        if (Delta.decode(aString) <= 0) continue;
                        this.aNewEq.removeEqModifiers("PCGENi_WEAPON|RANGE=", true);
                        this.aNewEq.addEqModifiers("PCGENi_WEAPON|RANGE=" + aString, true);
                        continue;
                    }
                    this.removeAddedType("RANGED");
                    break;
                }
            }
            if (!this.aNewEq.isWeapon() || !this.aNewEq.isRanged()) {
                this.removeAddedType("RANGED");
                this.aNewEq.removeEqModifiers("PCGENi_WEAPON|RANGE=", true);
            }
            if (!this.aNewEq.isArmor() || this.aNewEq.getMaxDex(aPC) == 100) {
                // empty if block
            }
            if (this.aNewEq.getBaseItemName().toUpperCase().startsWith("Generic Item".toUpperCase())) {
                this.aNewEq.setBaseItem("");
            }
            this.setEquipment(this.aNewEq, true);
            return;
        }
        try {
            if (this.aNewEq != null) {
                int itemPluses = this.aNewEq.calcPlusForCosting();
                aInfo.append("New Item: ").append(this.aNewEq.nameItemFromModifiers(aPC)).append(Constants.s_LINE_SEP);
                aInfo.append("Cost: ").append(this.aNewEq.getCost(aPC).toString());
                if (itemPluses != 0) {
                    aInfo.append(" (plus: ").append(itemPluses).append(')');
                }
                aInfo.append(", Weight: ").append(this.aNewEq.getWeight(aPC).toString());
                if (this.aNewEq.isArmor() || this.aNewEq.isShield()) {
                    aInfo.append(", AC: ").append(this.aNewEq.getACMod(aPC).toString());
                    aInfo.append(", ACCheck: ").append(this.aNewEq.acCheck(aPC).toString());
                    aInfo.append(", Fail: ").append(this.aNewEq.spellFailure(aPC).toString());
                    aInfo.append(", Max Dex: ").append(this.aNewEq.getMaxDex(aPC).toString());
                }
                if (this.aNewEq.isWeapon()) {
                    String altDamage;
                    aInfo.append(", Damage: ").append(this.aNewEq.getDamage(aPC));
                    int i = this.aNewEq.getBonusToDamage(aPC, true);
                    if (i != 0) {
                        aInfo.append(Delta.toString(i));
                    }
                    if ((i = this.aNewEq.getBonusToHit(aPC, true)) != 0) {
                        aInfo.append(" (").append(Delta.toString(i)).append(" to hit)");
                    }
                    if (this.aNewEq.isDouble() && (altDamage = this.aNewEq.getAltDamage(aPC)).length() != 0) {
                        aInfo.append('/').append(altDamage);
                        i = this.aNewEq.getBonusToDamage(aPC, false);
                        if (i != 0) {
                            aInfo.append(Delta.toString(i));
                        }
                        if ((i = this.aNewEq.getBonusToHit(aPC, false)) != 0) {
                            aInfo.append(" (").append(Delta.toString(i)).append(" to hit)");
                        }
                    }
                    int critRange = 21 - Integer.parseInt(this.aNewEq.getCritRange(aPC));
                    aInfo.append(" (").append(String.valueOf(critRange));
                    if (critRange < 20) {
                        aInfo.append("-20");
                    }
                    aInfo.append(' ').append(this.aNewEq.getCritMult());
                    if (this.aNewEq.isDouble()) {
                        aInfo.append('/');
                        int altCritRange = 21;
                        String aCrit = this.aNewEq.getAltCritRange(aPC);
                        if (aCrit.length() > 0) {
                            altCritRange = 21 - Integer.parseInt(aCrit);
                        }
                        if (altCritRange != critRange) {
                            aInfo.append(String.valueOf(altCritRange));
                            if (altCritRange < 20) {
                                aInfo.append("-20");
                            }
                            aInfo.append(' ');
                        }
                        aInfo.append(this.aNewEq.getAltCritMult());
                    }
                    aInfo.append(')');
                    if (this.aNewEq.isRanged()) {
                        aInfo.append(", Range: ").append(this.aNewEq.getRange(aPC).toString());
                    }
                }
                if ((sprop = this.aNewEq.getSpecialProperties(aPC)).length() != 0) {
                    aInfo.append(Constants.s_LINE_SEP).append("SPROP: ").append(sprop);
                }
            }
            this.jItemDesc.setText(aInfo.toString());
        }
        catch (Exception e) {
            String x = "ERROR: Exception type:" + e.getClass().getName() + Constants.s_LINE_SEP + "Message:" + e.getMessage();
            ShowMessageDelegate.showMessageDialog(x, "PCGen", MessageType.ERROR);
            Logging.errorPrint(aInfo.toString(), e);
        }
    }

    private void updateDisplay(boolean bPrimary) {
        this.updateDisplay(bPrimary, true);
    }

    private void updateDisplay(boolean bPrimary, boolean bRedraw) {
        List eqModList = this.aNewEq.getEqModifierList(bPrimary);
        DefaultListModel lm = bPrimary ? this.listModel1 : this.listModel2;
        lm.clear();
        Iterator e = eqModList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            lm.addElement(eqMod);
        }
        if (bRedraw) {
            this.dataModel.fireTableDataChanged();
            this.showItemInfo(this.aPC);
        }
        ((EQFrame)this.getRootPane().getParent()).setVisible(true);
        ((EQFrame)this.getRootPane().getParent()).toFront();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        validEqTypes = new String[]{"potion", "scroll", "wand", "ring"};
    }

    private final class EquipmentModModel
    extends AbstractTableModel {
        static final long serialVersionUID = -369105812700996734L;
        public static final int TABLETYPE_EQMOD2 = 0;
        public static final int TABLETYPE_EQMOD1 = 2;
        private static final int COLUMN_TYPE = 0;
        private static final int COLUMN_NAME = 1;
        private Object[] lastColValue = new Object[6];
        private final Object[][] s_columnTypeNames_eqMod1 = new Object[][]{{class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Q"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Name"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "PreReqs"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Cost"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "SA"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Source"}};
        private final Object[][] s_columnTypeNames_eqMod2 = new Object[][]{{class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Q1"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Q2"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Name"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "PreReqs"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Cost"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "SA"}, {class$java$lang$String == null ? (class$java$lang$String = EqBuilder.class$("java.lang.String")) : class$java$lang$String, "Source"}};
        private int lastRow = -1;
        private int tableType = 2;

        private EquipmentModModel() {
        }

        public Class getColumnClass(int column) {
            switch (this.tableType) {
                case 2: {
                    return (Class)this.s_columnTypeNames_eqMod1[column][0];
                }
                case 0: {
                    return (Class)this.s_columnTypeNames_eqMod2[column][0];
                }
            }
            Logging.errorPrint("In EqBuilder.getColumnClass the table type " + this.tableType + " is not handled.");
            return null;
        }

        public int getColumnCount() {
            switch (this.tableType) {
                case 2: {
                    return this.s_columnTypeNames_eqMod1.length;
                }
                case 0: {
                    return this.s_columnTypeNames_eqMod2.length;
                }
            }
            Logging.errorPrint("In EqBuilder.getColumnCount the table type " + this.tableType + " is not handled.");
            return 0;
        }

        public String getColumnName(int column) {
            switch (this.tableType) {
                case 2: {
                    return (String)this.s_columnTypeNames_eqMod1[column][1];
                }
                case 0: {
                    return (String)this.s_columnTypeNames_eqMod2[column][1];
                }
            }
            Logging.errorPrint("In EqBuilder.getColumnName the table type " + this.tableType + " is not handled.");
            return null;
        }

        public int getRowCount() {
            return EqBuilder.this.displayModifiers.size();
        }

        public Object getValueAt(int row, int column) {
            Object sRet;
            if (column < 0 || column >= this.getColumnCount()) {
                return "Out of Bounds";
            }
            if (row >= this.getRowCount()) {
                return null;
            }
            if (row != this.lastRow) {
                this.lastColValue = new String[this.getColumnCount()];
                this.lastRow = row;
            } else if (this.lastColValue[column] != null) {
                return this.lastColValue[column];
            }
            switch (this.tableType) {
                case 0: {
                    sRet = this.getEqModTableValueAt(EqBuilder.this.aPC, row, column, true);
                    break;
                }
                default: {
                    sRet = this.getEqModTableValueAt(EqBuilder.this.aPC, row, column, false);
                }
            }
            try {
                this.lastColValue[column] = sRet;
            }
            catch (Exception exc) {
                // empty catch block
            }
            return sRet;
        }

        private Object getEqModTableValueAt(PlayerCharacter aPC, int row, int column, boolean twoLists) {
            EquipmentModifier e;
            try {
                e = (EquipmentModifier)EqBuilder.this.displayModifiers.get(row);
            }
            catch (Exception exc) {
                return null;
            }
            if (!twoLists && column > 0) {
                ++column;
            }
            String sRet = "";
            switch (column) {
                case 0: {
                    if (EqBuilder.this.aNewEq != null && EqBuilder.this.aNewEq.canAddModifier(e, true)) {
                        sRet = "Y";
                        break;
                    }
                    sRet = "N";
                    break;
                }
                case 1: {
                    if (EqBuilder.this.aNewEq != null && EqBuilder.this.aNewEq.canAddModifier(e, false)) {
                        sRet = "Y";
                        break;
                    }
                    sRet = "N";
                    break;
                }
                case 2: {
                    sRet = e.getName();
                    if (!e.isType("BaseMaterial")) break;
                    sRet = "*" + sRet;
                    break;
                }
                case 3: {
                    sRet = e.preReqHTMLStrings(aPC, EqBuilder.this.aNewEq);
                    break;
                }
                case 4: {
                    String sCost;
                    int iPlus = e.getPlus();
                    StringBuffer eCost = new StringBuffer(20);
                    if (iPlus != 0) {
                        eCost.append("Plus:").append(iPlus);
                    }
                    if (!"0".equals(sCost = e.getPreCost())) {
                        if (eCost.length() != 0) {
                            eCost.append(", ");
                        }
                        eCost.append("Precost:").append(sCost);
                    }
                    if (!"0".equals(sCost = e.getCost())) {
                        if (eCost.length() != 0) {
                            eCost.append(", ");
                        }
                        eCost.append("Cost:").append(sCost);
                    }
                    sRet = eCost.toString();
                    break;
                }
                case 5: {
                    List aSA = e.getRawSpecialProperties();
                    StringBuffer aBuf = new StringBuffer(aSA.size() * 50);
                    Iterator e2 = aSA.iterator();
                    while (e2.hasNext()) {
                        if (aBuf.length() > 0) {
                            aBuf.append(", ");
                        }
                        aBuf.append((String)e2.next());
                    }
                    sRet = aBuf.toString();
                    break;
                }
                case 6: {
                    sRet = e.getSource();
                    break;
                }
                default: {
                    Logging.errorPrint("In EqBuilder.getEqModTableValueAt the column " + column + " is not handled.");
                }
            }
            return sRet;
        }

        private void setFilter(Equipment anEq, int listCount) {
            List aFilter = anEq.typeList();
            int currentRowCount = this.getRowCount();
            EqBuilder.this.displayModifiers.clear();
            if (currentRowCount > 0) {
                this.fireTableRowsDeleted(0, currentRowCount - 1);
            }
            Iterator it = EquipmentList.getModifierList().iterator();
            block0: while (it.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)it.next();
                if (!anEq.isVisible(aEqMod)) continue;
                if (aEqMod.isType("ALL")) {
                    EqBuilder.this.displayModifiers.add(aEqMod);
                    continue;
                }
                Iterator e = aFilter.iterator();
                while (e.hasNext()) {
                    String aType = (String)e.next();
                    if (!aEqMod.isType(aType)) continue;
                    EqBuilder.this.displayModifiers.add(aEqMod);
                    continue block0;
                }
            }
            Globals.sortPObjectListByName(EqBuilder.this.displayModifiers);
            this.lastRow = -1;
            if (listCount == 2) {
                if (this.tableType != 0) {
                    this.tableType = 0;
                    this.fireTableStructureChanged();
                }
            } else if (this.tableType != 2) {
                this.tableType = 2;
                this.fireTableStructureChanged();
            }
            this.fireTableDataChanged();
        }

        private int getTableType() {
            return this.tableType;
        }
    }
}

