/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.MainSource;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class GameModes
extends JMenu {
    static final long serialVersionUID = -6751569845505079621L;
    private static String in_stdrdCampaign = PropertyFactory.getString("in_stdrdCampaign");
    private AbstractList campaignMenuItems = new ArrayList();
    private AbstractList campaigns = new ArrayList();
    private ButtonGroup gameModeGroup = null;
    private CheckBoxListener checkBoxHandler = new CheckBoxListener();
    private JRadioButtonMenuItem[] gameModeNames = null;
    private String[] in_modeName = null;
    private String[] in_useMode = null;

    GameModes() {
        try {
            this.jbInit();
            this.setText(PropertyFactory.getString("in_mnuSettingsCampaign"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuSettingsCampaign"));
            Utility.setDescription(this, PropertyFactory.getString("in_mnuSettingsCampaignTip"));
            this.updateMenu();
        }
        catch (Exception e) {
            Logging.errorPrint("Exception while initing the form", e);
        }
    }

    private void getMenuInfo(int gameModeCount) {
        this.in_useMode = new String[gameModeCount];
        this.in_modeName = new String[gameModeCount];
        for (int i = 0; i < gameModeCount; ++i) {
            GameMode gameMode = (GameMode)SystemCollections.getUnmodifiableGameModeList().get(i);
            this.in_modeName[i] = gameMode.getMenuEntry();
            this.in_useMode[i] = gameMode.getMenuToolTip();
        }
    }

    private void jbInit() throws Exception {
        int i;
        int gameModeCount = SystemCollections.getUnmodifiableGameModeList().size();
        if (SystemCollections.getUnmodifiableGameModeList().size() == 0) {
            return;
        }
        this.getMenuInfo(gameModeCount);
        this.gameModeNames = new JRadioButtonMenuItem[gameModeCount];
        this.gameModeGroup = new ButtonGroup();
        for (i = 0; i < this.in_modeName.length; ++i) {
            StringTokenizer aTok = new StringTokenizer(this.in_modeName[i], "|", false);
            GameModes mnuLevel = this;
            JMenu firstSubMenu = null;
            while (aTok.hasMoreTokens()) {
                String aName = aTok.nextToken();
                if (aName.charAt(0) == '~') {
                    mnuLevel.addSeparator();
                    aName = aName.substring(1);
                }
                if (aTok.hasMoreTokens()) {
                    JMenu mnu = null;
                    for (int j = 0; j < mnuLevel.getItemCount(); ++j) {
                        JMenuItem anObj = mnuLevel.getItem(j);
                        if (!(anObj instanceof JMenu) || !((JMenu)anObj).getText().equals(aName)) continue;
                        mnu = (JMenu)anObj;
                        break;
                    }
                    if (mnu == null) {
                        mnu = new JMenu(aName);
                        mnuLevel.add(mnu);
                    }
                    if (firstSubMenu == null) {
                        firstSubMenu = mnu;
                    }
                    mnuLevel = mnu;
                    continue;
                }
                this.gameModeNames[i] = new JRadioButtonMenuItem(aName, false);
                this.gameModeGroup.add(mnuLevel.add(this.gameModeNames[i]));
                Utility.setDescription(this.gameModeNames[i], this.in_useMode[i]);
                this.gameModeNames[i].addActionListener(this.checkBoxHandler);
            }
            Iterator campaignIterator = Globals.getCampaignList().iterator();
            boolean firstCampaignEntry = true;
            while (campaignIterator.hasNext()) {
                Campaign aCamp = (Campaign)campaignIterator.next();
                if (!aCamp.canShowInMenu() || !aCamp.isGameMode(((GameMode)SystemCollections.getUnmodifiableGameModeList().get(i)).getName())) continue;
                if (firstSubMenu == null) {
                    firstSubMenu = new JMenu(this.gameModeNames[i].getText());
                    mnuLevel.remove(this.gameModeNames[i]);
                    mnuLevel.add(firstSubMenu);
                    Utility.setTextAndMnemonic(firstSubMenu, firstSubMenu.getText());
                    this.gameModeNames[i].setText(in_stdrdCampaign);
                    firstSubMenu.add(this.gameModeNames[i]);
                }
                if (firstCampaignEntry) {
                    firstCampaignEntry = false;
                    firstSubMenu.addSeparator();
                }
                JRadioButtonMenuItem campaignMenuItem = new JRadioButtonMenuItem(aCamp.getName());
                this.gameModeGroup.add(firstSubMenu.add(campaignMenuItem));
                Utility.setDescription(campaignMenuItem, aCamp.getInfoText());
                this.campaigns.add(aCamp);
                this.campaignMenuItems.add(campaignMenuItem);
                campaignMenuItem.addActionListener(this.checkBoxHandler);
            }
        }
        for (i = 0; i < this.gameModeNames.length; ++i) {
            Utility.setTextAndMnemonic(this.gameModeNames[i], this.gameModeNames[i].getText());
        }
    }

    private void updateMenu() {
        boolean bFound = false;
        while (true) {
            if (this.in_modeName != null) {
                for (int i = 0; i < this.in_modeName.length; ++i) {
                    if (!Globals.isInGameMode(((GameMode)SystemCollections.getUnmodifiableGameModeList().get(i)).getName())) continue;
                    this.gameModeNames[i].setSelected(true);
                    bFound = true;
                    break;
                }
            }
            if (bFound) break;
            SettingsHandler.setGame("3e");
            bFound = true;
        }
        if (Globals.getRootFrame() != null) {
            PCGen_Frame1.getInst().setGameModeTitle();
        }
    }

    private final class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object source = actionEvent.getSource();
            String tempGameMode = "3e";
            int campaignNum = -1;
            if (source == null) {
                return;
            }
            campaignNum = GameModes.this.campaignMenuItems.indexOf(source);
            ((JRadioButtonMenuItem)source).requestFocus();
            for (int i = 0; i < GameModes.this.gameModeNames.length; ++i) {
                if (source != GameModes.this.gameModeNames[i]) continue;
                tempGameMode = ((GameMode)SystemCollections.getUnmodifiableGameModeList().get(i)).getName();
            }
            if (campaignNum >= 0) {
                List gameModeList = ((Campaign)GameModes.this.campaigns.get(campaignNum)).getGameModeList();
                tempGameMode = (String)gameModeList.get(0);
            }
            if (!Globals.isInGameMode(tempGameMode)) {
                SettingsHandler.setGame(tempGameMode);
                Globals.loadAttributeNames();
                GameModes.this.updateMenu();
                ((MainSource)PCGen_Frame1.getBaseTabbedPane().getComponent(0)).changedGameMode();
            }
            if (campaignNum >= 0) {
                ArrayList selectedCampaigns = new ArrayList();
                selectedCampaigns.add(GameModes.this.campaigns.get(campaignNum));
                try {
                    PCGen_Frame1.getInst().closeAllPCs();
                    if (PCGen_Frame1.getBaseTabbedPane().getTabCount() > PCGen_Frame1.FIRST_CHAR_TAB) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_campaignChangeError"), "PCGen", MessageType.INFORMATION);
                        return;
                    }
                    Globals.emptyLists();
                    PersistenceManager pManager = PersistenceManager.getInstance();
                    pManager.emptyLists();
                    pManager.setChosenCampaignSourcefiles(new ArrayList());
                    Iterator it = Globals.getCampaignList().iterator();
                    while (it.hasNext()) {
                        Campaign aCamp = (Campaign)it.next();
                        aCamp.setIsLoaded(false);
                    }
                    pManager.loadCampaigns(selectedCampaigns);
                }
                catch (PersistenceLayerException e) {
                    ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.WARNING);
                }
                Globals.sortCampaigns();
                PCGen_Frame1.getInst().getMainSource().updateLoadedCampaignsUI();
                if (GameModes.this.getParent() != null && Globals.displayListsHappy()) {
                    PCGen_Frame1 parent = PCGen_Frame1.getInst();
                    parent.enableNew(true);
                    parent.enableLstEditors(true);
                }
            }
        }
    }
}

