/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JFrame;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.gui.MainHP;
import pcgen.util.PropertyFactory;

final class HPFrame
extends JFrame {
    private MainHP mainHP = null;

    HPFrame() {
        this.setTitle(HPFrame.myGetTitle());
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif"));
        this.setIconImage(img);
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.setSize(screenWidth >> 1, screenHeight >> 1);
        this.setLocation(screenWidth >> 2, screenHeight >> 2);
        this.setDefaultCloseOperation(2);
        this.mainHP = new MainHP();
        Container contentPane = this.getContentPane();
        contentPane.add(this.mainHP);
        this.setVisible(true);
    }

    public void setCharacter(PlayerCharacter aPC) {
        this.mainHP.setCharacter(aPC);
    }

    public void setPSize() {
        if (this.mainHP != null) {
            this.mainHP.setPSize();
        }
    }

    private static String myGetTitle() {
        String title = PropertyFactory.getString("in_adjustHP");
        int idx = title.indexOf("%s");
        if (idx >= 0) {
            title = title.substring(0, idx) + Globals.getGameModeHitPointText() + title.substring(idx + 2);
        }
        return title;
    }
}

