/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.util.Iterator;
import pcgen.core.Globals;
import pcgen.core.Skill;
import pcgen.gui.InfoSkillsSorter;
import pcgen.gui.tabs.InfoSkills;
import pcgen.gui.utils.PObjectNode;

public final class InfoSkillsSorters {
    private static boolean costsMatch(PObjectNode node, Skill skill, InfoSkills tab) {
        return node.toString().equals(skill.getSkillCostType(tab.getSelectedPCClass(), Globals.getCurrentPC()));
    }

    private static boolean keystatsMatch(PObjectNode node, Skill skill) {
        return node.toString().equals(skill.getMyType(0));
    }

    public static class SubtypeName_Primary
    extends AbstractSubtypeName_Penultimate {
        public SubtypeName_Primary(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return true;
        }
    }

    public static class Name_Primary
    extends FinalSorter {
        public Name_Primary(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return true;
        }
    }

    public static class KeystatSubtypeName_Secondary
    extends AbstractSubtypeName_Penultimate {
        public KeystatSubtypeName_Secondary(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return InfoSkillsSorters.keystatsMatch(node, skill);
        }
    }

    public static class KeystatSubtypeName_Primary
    extends AbstractSorter {
        public KeystatSubtypeName_Primary(InfoSkills tab) {
            super(tab);
        }

        public InfoSkillsSorter nextSorter() {
            return new KeystatSubtypeName_Secondary(this.tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return true;
        }

        public boolean nodeHaveNext() {
            return true;
        }

        public Object whatPart(boolean available, Skill skill) {
            return skill.getMyType(0);
        }
    }

    public static class KeystatName_Secondary
    extends FinalSorter {
        public KeystatName_Secondary(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return InfoSkillsSorters.keystatsMatch(node, skill);
        }
    }

    public static class KeystatName_Primary
    extends KeystatSubtypeName_Primary {
        public KeystatName_Primary(InfoSkills tab) {
            super(tab);
        }

        public InfoSkillsSorter nextSorter() {
            return new KeystatName_Secondary(this.tab);
        }
    }

    public static class GenericSubtypeName_Final
    extends FinalSorter {
        public GenericSubtypeName_Final(InfoSkills tab) {
            super(tab);
        }

        public PObjectNode finalPass(PObjectNode node) {
            PObjectNode it = node;
            while (it.hasNext()) {
                PObjectNode child;
                PObjectNode jt = child = (PObjectNode)it.next();
                while (jt.hasNext()) {
                    PObjectNode gcIt = (PObjectNode)jt.next();
                    while (gcIt.hasNext()) {
                        PObjectNode nodule = (PObjectNode)gcIt.next();
                        if (node.getChildCount() != 1) continue;
                        gcIt.set(node.getChild(0));
                    }
                }
            }
            return node;
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            Iterator it = skill.getSubtypeIterator();
            while (it.hasNext()) {
                if (!node.toString().equals(it.next())) continue;
                return true;
            }
            return false;
        }
    }

    public static class CostSubtypeName_Secondary
    extends AbstractSubtypeName_Penultimate {
        public CostSubtypeName_Secondary(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return InfoSkillsSorters.costsMatch(node, skill, this.tab);
        }
    }

    public static class CostSubtypeName_Primary
    extends CostSorter {
        public CostSubtypeName_Primary(InfoSkills tab) {
            super(tab);
        }

        public InfoSkillsSorter nextSorter() {
            return new CostSubtypeName_Secondary(this.tab);
        }
    }

    public static class CostName_Secondary
    extends FinalSorter {
        public CostName_Secondary(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return InfoSkillsSorters.costsMatch(node, skill, this.tab);
        }
    }

    public static class CostName_Primary
    extends CostSorter {
        public CostName_Primary(InfoSkills tab) {
            super(tab);
        }

        public InfoSkillsSorter nextSorter() {
            return new CostName_Secondary(this.tab);
        }
    }

    public static abstract class FinalSorter
    extends AbstractSorter {
        public FinalSorter(InfoSkills tab) {
            super(tab);
        }

        public InfoSkillsSorter nextSorter() {
            throw new UnsupportedOperationException();
        }

        public boolean nodeHaveNext() {
            return false;
        }

        public Object whatPart(boolean available, Skill skill) {
            return InfoSkills.createSkillWrapper(available, skill, Globals.getCurrentPC());
        }
    }

    public static abstract class CostSorter
    extends AbstractSorter {
        private int n = 0;

        public CostSorter(InfoSkills tab) {
            super(tab);
        }

        public boolean nodeGoHere(PObjectNode node, Skill skill) {
            return this.n < 3;
        }

        public boolean nodeHaveNext() {
            return true;
        }

        public Object whatPart(boolean available, Skill skill) {
            String[] costs = new String[]{"CLASS", "CROSS-CLASS", "EXCLUSIVE"};
            return costs[this.n++];
        }
    }

    public static abstract class AbstractSubtypeName_Penultimate
    extends AbstractSorter {
        public AbstractSubtypeName_Penultimate(InfoSkills tab) {
            super(tab);
        }

        public InfoSkillsSorter nextSorter() {
            return new GenericSubtypeName_Final(this.tab);
        }

        public boolean nodeHaveNext() {
            return true;
        }

        public Object whatPart(boolean available, Skill skill) {
            if (skill.getSubtypeCount() > 0) {
                return skill.getSubtypeIterator();
            }
            return InfoSkills.createSkillWrapper(available, skill, Globals.getCurrentPC());
        }
    }

    public static abstract class AbstractSorter
    implements InfoSkillsSorter {
        InfoSkills tab;

        public AbstractSorter(InfoSkills tab) {
            this.tab = tab;
        }

        public PObjectNode finalPass(PObjectNode node) {
            return node;
        }
    }
}

