/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.KitFeat;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitProf;
import pcgen.core.kit.KitSkill;
import pcgen.core.kit.KitSpells;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;

final class KitSelector
extends JFrame {
    static final long serialVersionUID = -7963863233576905914L;
    private static final int USER_NO = 0;
    private static final int USER_YES = 1;
    private DefaultMutableTreeNode rootNodea;
    private DefaultMutableTreeNode rootNodes;
    private FlippingSplitPane spChoices;
    private FlippingSplitPane spMain;
    private JButton btnAdd;
    private JButton btnOk;
    private JButton btnRemove;
    private JLabel lblAvailable;
    private JLabel lblSelected;
    private JLabelPane txtInfo;
    private JPanel pnlAvailable;
    private JPanel pnlBottom;
    private JPanel pnlFrame;
    private JPanel pnlInfo;
    private JPanel pnlSelected;
    private JScrollPane scpAvailable;
    private JScrollPane scpInfo;
    private JScrollPane scpSelected;
    private JTree lstAvailable;
    private JTree lstSelected;
    private PlayerCharacter aPC = null;
    private String filter = "";
    private int userResponse = 0;

    KitSelector(PlayerCharacter argPC) {
        this.aPC = argPC;
        this.initComponents();
        this.initComponentContents();
        this.setSize(new Dimension(640, 460));
        Utility.centerFrame(this, false);
    }

    public void setFilter(String argFilter) {
        this.setFilter(argFilter, true);
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private static boolean isDoubleClick(MouseEvent evt, JTree lst, JButton btn) {
        if (lst.getSelectionCount() >= 0) {
            switch (evt.getClickCount()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!btn.isEnabled()) break;
                    return true;
                }
            }
        }
        return false;
    }

    private void setFilter(String argFilter, boolean updateTree) {
        this.filter = argFilter.length() == 0 ? "OTHER" : argFilter;
        if (updateTree) {
            this.expandAll(this.lstAvailable, false, 2);
            DefaultMutableTreeNode n = KitSelector.findChild(this.rootNodea, this.filter);
            if (n != null) {
                DefaultMutableTreeNode r;
                String region = this.aPC.getRegion();
                if (region.length() != 0 && !region.equalsIgnoreCase("None") && (r = KitSelector.findChild(n, region)) != null) {
                    n = r;
                }
                if (n.getChildCount() != 0) {
                    n = (DefaultMutableTreeNode)n.getLastChild();
                }
                TreePath tp = new TreePath(n.getPath());
                this.lstAvailable.expandPath(tp);
                this.lstAvailable.scrollPathToVisible(tp);
                this.lstAvailable.updateUI();
            }
        }
    }

    private static String getKitType(Kit aKit) {
        if (aKit.getMyTypeCount() == 1) {
            return aKit.getMyType(0);
        }
        return "OTHER";
    }

    private static DefaultMutableTreeNode findChild(DefaultMutableTreeNode root, Object nodeToFind) {
        if (root != null && root.getChildCount() != 0) {
            Enumeration<TreeNode> en = root.children();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
                Object childObj = childNode.getUserObject();
                if (childObj instanceof String && nodeToFind instanceof String) {
                    if (!((String)nodeToFind).equalsIgnoreCase((String)childObj)) continue;
                    return childNode;
                }
                if (childObj instanceof Kit && !(nodeToFind instanceof Kit)) continue;
            }
        }
        return null;
    }

    private String getPreReqHTMLStrings(Kit theKit) {
        ArrayList<String> prereqList = theKit.getPreReqList();
        String region = theKit.getRegion();
        if (!region.equalsIgnoreCase("None")) {
            String regPre;
            if (prereqList == null) {
                prereqList = new ArrayList<String>();
            }
            if (!prereqList.contains(regPre = "PREREGION:" + region)) {
                prereqList.add(regPre);
            }
        }
        return theKit.preReqHTMLStringsForList(this.aPC, theKit, prereqList, false);
    }

    private void addKit(DefaultMutableTreeNode node, Kit theKit) {
        if (theKit == null || !this.kitPassesPrereqs(theKit)) {
            return;
        }
        ArrayList thingsToAdd = new ArrayList();
        ArrayList warnings = new ArrayList();
        theKit.addKitFeats(this.aPC, thingsToAdd, warnings);
        theKit.addKitProfs(this.aPC, thingsToAdd, warnings);
        theKit.addKitGear(this.aPC, thingsToAdd, warnings);
        theKit.addKitSpells(this.aPC, thingsToAdd, warnings);
        theKit.addKitSkills(this.aPC, thingsToAdd, warnings);
        if (warnings.size() != 0 && this.showWarnings(warnings) == 0) {
            return;
        }
        theKit.processKit(this.aPC, thingsToAdd);
        KitSelector.forceTabUpdate();
        TreeNode[] ptr = node.getPath();
        node.removeFromParent();
        DefaultMutableTreeNode n = this.rootNodes;
        for (int i = 1; i < ptr.length; ++i) {
            Object userObj = ((DefaultMutableTreeNode)ptr[i]).getUserObject();
            DefaultMutableTreeNode child = KitSelector.findChild(n, userObj);
            if (child == null) {
                child = new DefaultMutableTreeNode(userObj);
                n.add(child);
            }
            n = child;
        }
        TreePath tp = new TreePath(n.getPath());
        this.lstSelected.scrollPathToVisible(tp);
        this.lstSelected.setSelectionPath(tp);
        this.lstSelected.updateUI();
        this.lstAvailable.updateUI();
    }

    private void addSelections(JTree lst, List kits, List excluded) {
        if (kits == null || kits.size() == 0) {
            return;
        }
        Iterator e = kits.iterator();
        block0: while (e.hasNext()) {
            Kit aKit = (Kit)e.next();
            if (excluded != null && excluded.contains(aKit)) continue;
            String region = aKit.getRegion();
            boolean hasRegion = false;
            if (region.length() != 0 && !region.equalsIgnoreCase("None")) {
                hasRegion = true;
            }
            String aType = KitSelector.getKitType(aKit);
            int x = lst.getRowCount();
            for (int i = 0; i < x; ++i) {
                DefaultMutableTreeNode child;
                DefaultMutableTreeNode obj = (DefaultMutableTreeNode)lst.getPathForRow(i).getLastPathComponent();
                String thisType = obj.getUserObject().toString();
                if (!aType.equalsIgnoreCase(thisType)) continue;
                if (hasRegion) {
                    child = KitSelector.findChild(obj, region);
                    if (child == null) {
                        child = new DefaultMutableTreeNode(region);
                        obj.add(child);
                    }
                    obj = child;
                }
                child = new DefaultMutableTreeNode(aKit);
                obj.add(child);
                continue block0;
            }
        }
    }

    private void btnAddActionPerformed() {
        Object nodeInfo;
        this.btnAdd.setEnabled(false);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.lstAvailable.getLastSelectedPathComponent();
        if (node != null && (nodeInfo = node.getUserObject()) instanceof Kit) {
            this.addKit(node, (Kit)nodeInfo);
            this.requestFocus();
        }
    }

    private void btnOKActionPerformed() {
        this.closeDialog();
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
    }

    private static void forceTabUpdate() {
        PCGen_Frame1.getInst().updateByKludge();
    }

    private void expandAll(JTree tree, boolean expand, int maxDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand, maxDepth);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand, int maxDepth) {
        if (maxDepth < 0) {
            return;
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand, --maxDepth);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void initComponentContents() {
        IconUtilitities.maybeSetIcon(this, "PcgenIcon.gif");
        ArrayList<String> kitTypes = new ArrayList<String>();
        kitTypes.add("OTHER");
        Iterator e = Globals.getKitInfo().iterator();
        while (e.hasNext()) {
            Kit aKit = (Kit)e.next();
            int x = aKit.getMyTypeCount();
            for (int i = 0; i < x; ++i) {
                String aString = aKit.getMyType(i);
                if (kitTypes.contains(aString)) continue;
                kitTypes.add(aString);
            }
        }
        Collections.sort(kitTypes);
        this.rootNodea = new DefaultMutableTreeNode();
        this.rootNodes = new DefaultMutableTreeNode();
        for (int i = 0; i < kitTypes.size(); ++i) {
            this.rootNodea.add(new DefaultMutableTreeNode(kitTypes.get(i), true));
            this.rootNodes.add(new DefaultMutableTreeNode(kitTypes.get(i), true));
        }
        this.lstAvailable = new JTree(this.rootNodea);
        this.lstAvailable.setCellRenderer(new MyCellRenderer());
        this.lstAvailable.setRootVisible(false);
        this.lstAvailable.getSelectionModel().setSelectionMode(1);
        this.scpAvailable.setViewportView(this.lstAvailable);
        List pcKitInfo = this.aPC.getKitInfo();
        this.addSelections(this.lstAvailable, Globals.getKitInfo(), pcKitInfo);
        this.lstSelected = new JTree(this.rootNodes);
        this.lstSelected.setCellRenderer(new MyCellRenderer());
        this.lstSelected.setRootVisible(false);
        this.lstSelected.getSelectionModel().setSelectionMode(1);
        this.scpSelected.setViewportView(this.lstSelected);
        this.addSelections(this.lstSelected, pcKitInfo, null);
        int x = this.lstAvailable.getRowCount();
        for (int i = 0; i < x; ++i) {
            String thisType;
            Object obj = this.lstAvailable.getPathForRow(i).getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode) || !(thisType = obj.toString()).equalsIgnoreCase(this.filter)) continue;
            this.lstAvailable.expandRow(i);
            break;
        }
        this.lstAvailable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                KitSelector.this.lstAvailableMouseClicked(evt);
            }
        });
        this.lstAvailable.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                KitSelector.this.lstAvailableSelectionChanged();
            }
        });
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                KitSelector.this.lstSelectedMouseClicked(evt);
            }
        });
        this.lstSelected.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                KitSelector.this.lstSelectedSelectionChanged();
            }
        });
        this.lstAvailable.putClientProperty("JTree.lineStyle", "Angled");
        this.lstSelected.putClientProperty("JTree.lineStyle", "Angled");
    }

    private void initComponents() {
        this.pnlFrame = new JPanel();
        this.spMain = new FlippingSplitPane();
        this.spChoices = new FlippingSplitPane();
        this.pnlAvailable = new JPanel();
        this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.lblAvailable = new JLabel();
        this.scpAvailable = new JScrollPane();
        this.pnlSelected = new JPanel();
        this.lblSelected = new JLabel();
        this.scpSelected = new JScrollPane();
        this.pnlBottom = new JPanel();
        this.pnlInfo = new JPanel();
        this.scpInfo = new JScrollPane();
        this.txtInfo = new JLabelPane();
        this.btnOk = new JButton();
        this.setTitle("Kit Selection");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                KitSelector.this.closeDialog();
            }
        });
        this.pnlFrame.setLayout(new BorderLayout());
        this.pnlFrame.setBorder(new EmptyBorder(new Insets(3, 3, 3, 1)));
        this.spMain.setOrientation(0);
        this.spMain.setResizeWeight(0.5);
        this.spMain.setOneTouchExpandable(true);
        this.spMain.setDividerSize(10);
        this.spChoices.setResizeWeight(0.5);
        this.spChoices.setOneTouchExpandable(true);
        this.spChoices.setDividerSize(10);
        this.pnlAvailable.setLayout(new GridBagLayout());
        this.pnlAvailable.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KitSelector.this.btnAddActionPerformed();
            }
        });
        this.pnlAvailable.add((Component)this.btnAdd, new GridBagConstraints());
        this.lblAvailable.setText("Available");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlAvailable.add((Component)this.lblAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAvailable.add((Component)this.scpAvailable, gridBagConstraints);
        this.spChoices.setLeftComponent(this.pnlAvailable);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.pnlSelected.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KitSelector.this.btnRemoveActionPerformed();
            }
        });
        this.pnlSelected.add((Component)this.btnRemove, new GridBagConstraints());
        this.lblSelected.setText("Selected");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.spChoices.setRightComponent(this.pnlSelected);
        this.spMain.setLeftComponent(this.spChoices);
        this.pnlBottom.setLayout(new GridBagLayout());
        this.pnlInfo.setLayout(new BoxLayout(this.pnlInfo, 0));
        this.pnlInfo.setBorder(new TitledBorder("Kit Info"));
        this.txtInfo.setEditable(false);
        this.txtInfo.setBackground(this.pnlInfo.getBackground());
        this.scpInfo.setViewportView(this.txtInfo);
        this.pnlInfo.add(this.scpInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlBottom.add((Component)this.pnlInfo, gridBagConstraints);
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KitSelector.this.btnOKActionPerformed();
            }
        });
        this.pnlBottom.add((Component)this.btnOk, new GridBagConstraints());
        this.spMain.setRightComponent(this.pnlBottom);
        this.pnlFrame.add((Component)this.spMain, "Center");
        this.getContentPane().add((Component)this.pnlFrame, "Center");
    }

    private boolean kitPassesPrereqs(Kit theKit) {
        ArrayList<String> prereqList = theKit.getPreReqList();
        String region = theKit.getRegion();
        if (!region.equalsIgnoreCase("None")) {
            String regPre;
            if (prereqList == null) {
                prereqList = new ArrayList<String>();
            }
            if (!prereqList.contains(regPre = "PREREGION:" + region)) {
                prereqList.add(regPre);
            }
        }
        return PrereqHandler.passesAll(prereqList, this.aPC, null);
    }

    private void lstAvailableMouseClicked(MouseEvent evt) {
        if (KitSelector.isDoubleClick(evt, this.lstAvailable, this.btnAdd)) {
            this.btnAddActionPerformed();
        }
    }

    private void lstAvailableSelectionChanged() {
        Object nodeInfo;
        Kit aKit = null;
        boolean bEnable = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.lstAvailable.getLastSelectedPathComponent();
        if (node != null && (nodeInfo = node.getUserObject()) instanceof Kit && this.kitPassesPrereqs(aKit = (Kit)nodeInfo)) {
            bEnable = true;
        }
        this.showKitInfo(aKit);
        this.btnAdd.setEnabled(bEnable);
    }

    private void lstSelectedMouseClicked(MouseEvent evt) {
        if (KitSelector.isDoubleClick(evt, this.lstSelected, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private void lstSelectedSelectionChanged() {
        Object nodeInfo;
        Kit aKit = null;
        boolean bEnable = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.lstSelected.getLastSelectedPathComponent();
        if (node != null && (nodeInfo = node.getUserObject()) instanceof Kit) {
            aKit = (Kit)nodeInfo;
            bEnable = true;
        }
        this.showKitInfo(aKit);
        this.btnRemove.setEnabled(bEnable);
    }

    private void showKitInfo(Kit theKit) {
        int i;
        int x;
        List aList;
        if (theKit == null) {
            this.txtInfo.setText();
            return;
        }
        StringBuffer info = new StringBuffer(150);
        info.append("<html>");
        info.append("<b>").append(theKit.getName()).append("</b> ");
        String aString = this.getPreReqHTMLStrings(theKit);
        if (aString.length() != 0) {
            info.append("  <b>Requirements</b>: ").append(aString);
        }
        if ((aList = theKit.getFeats()) != null && aList.size() != 0) {
            info.append("  <b>Feats</b>: ");
            x = aList.size();
            for (i = 0; i < x; ++i) {
                KitFeat kFeat = (KitFeat)aList.get(i);
                if (i != 0) {
                    info.append("; ");
                }
                aString = kFeat.toString();
                if (!PrereqHandler.passesAll(kFeat.getPrereqs(), this.aPC, null)) {
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                    info.append(aString);
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
                    continue;
                }
                info.append(aString);
            }
        }
        if ((aList = theKit.getGear()) != null && aList.size() != 0) {
            info.append("  <b>Gear</b>: ");
            x = aList.size();
            for (i = 0; i < x; ++i) {
                KitGear kGear = (KitGear)aList.get(i);
                if (i != 0) {
                    info.append("; ");
                }
                aString = kGear.toString();
                if (!PrereqHandler.passesAll(kGear.getPrereqs(), this.aPC, null)) {
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                    info.append(aString);
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
                    continue;
                }
                info.append(aString);
            }
        }
        if ((aList = theKit.getSpells()) != null && aList.size() != 0) {
            info.append("  <b>Spells</b>: ");
            x = aList.size();
            for (i = 0; i < x; ++i) {
                KitSpells kSpells = (KitSpells)aList.get(i);
                if (i != 0) {
                    info.append("; ");
                }
                aString = kSpells.toString();
                if (!PrereqHandler.passesAll(kSpells.getPrereqs(), this.aPC, null)) {
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                    info.append(aString);
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
                    continue;
                }
                info.append(aString);
            }
        }
        if ((aList = theKit.getSkill()) != null && aList.size() != 0) {
            info.append("  <b>Skills</b>: ");
            x = aList.size();
            for (i = 0; i < x; ++i) {
                KitSkill kSkill = (KitSkill)aList.get(i);
                if (i != 0) {
                    info.append("; ");
                }
                aString = kSkill.toString();
                if (!PrereqHandler.passesAll(kSkill.getPrereqs(), this.aPC, null)) {
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                    info.append(aString);
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
                    continue;
                }
                info.append(aString);
            }
        }
        if ((aList = theKit.getProfs()) != null && aList.size() != 0) {
            info.append("  <b>Proficiencies</b>: ");
            x = aList.size();
            for (i = 0; i < x; ++i) {
                KitProf kProf = (KitProf)aList.get(i);
                if (i != 0) {
                    info.append("; ");
                }
                aString = kProf.toString();
                if (!PrereqHandler.passesAll(kProf.getPrereqs(), this.aPC, null)) {
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                    info.append(aString);
                    info.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
                    continue;
                }
                info.append(aString);
            }
        }
        info.append("  <b>Source</b>: ").append(theKit.getSource());
        info.append("</html>");
        this.txtInfo.setText(info.toString());
    }

    private int showWarnings(List warnings) {
        this.userResponse = 0;
        try {
            final JDialog aFrame = new JDialog(this, "Warnings", true);
            JPanel jPanel1 = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JLabel jLabel1 = new JLabel("The following warnings were encountered");
            JButton jApply = new JButton("Apply");
            JButton jAbort = new JButton("Abort");
            jPanel1.add(jLabel1);
            jPanel2.setLayout(new BorderLayout());
            aFrame.getContentPane().add((Component)jPanel1, "North");
            aFrame.getContentPane().add((Component)jPanel2, "Center");
            aFrame.getContentPane().add((Component)jPanel3, "South");
            StringBuffer warningInfo = new StringBuffer(100);
            warningInfo.append("<html>");
            Iterator e = warnings.iterator();
            while (e.hasNext()) {
                warningInfo.append((String)e.next()).append("<br>");
            }
            warningInfo.append("</html>");
            JEditorPane a = new JEditorPane("text/html", warningInfo.toString());
            a.setEditable(false);
            JScrollPane aPane = new JScrollPane();
            aPane.setViewportView(a);
            jPanel2.add((Component)aPane, "Center");
            jPanel3.add(jAbort);
            jPanel3.add(jApply);
            jApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    KitSelector.this.userResponse = 1;
                    aFrame.dispose();
                }
            });
            jAbort.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    KitSelector.this.userResponse = 0;
                    aFrame.dispose();
                }
            });
            aFrame.setSize(new Dimension(456, 352));
            aFrame.setLocationRelativeTo(this);
            aFrame.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.userResponse;
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private MyCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean argHasFocus) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (obj instanceof Kit && !KitSelector.this.kitPassesPrereqs((Kit)obj)) {
                value = "<html>" + SettingsHandler.getPrereqFailColorAsHtmlStart() + ((Kit)obj).getName() + SettingsHandler.getPrereqFailColorAsHtmlStart() + "</html>";
            }
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, argHasFocus);
            return this;
        }
    }
}

