/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.utils.JComboBoxEditor;
import pcgen.gui.utils.JComboBoxRenderer;
import pcgen.gui.utils.TableSorter;
import pcgen.util.Logging;

final class LstConverter
extends JFrame {
    static final long serialVersionUID = 4822388828239441708L;
    private static final String[] typeTypes = new String[]{"UNKNOWN", "RACE", "CLASS", "SPELL", "DEITY", "DOMAIN", "SKILL", "FEAT", "TEMPLATE"};
    private static final String[] okTypes = new String[]{"NO", "YES"};
    private List doneList = new ArrayList();
    private List lstNameList = new ArrayList();
    private List lstPathList = new ArrayList();
    private List lstTypeList = new ArrayList();
    private List okList = new ArrayList();
    private String basePath = "";
    private TableSorter sorter = new TableSorter();

    LstConverter(String argBasePath) {
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
        this.setTitle("Convert Required fields to tagged format");
        this.basePath = argBasePath;
        try {
            this.loadLSTFilesInDirectory(this.basePath);
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint("Error while initing form", e);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.handleQuit();
        }
    }

    private static String getFormulaFor(int type, String formulaString) {
        String formula = formulaString;
        if (type == 0) {
            if ("G".equals(formulaString)) {
                formula = "CL";
            }
            if ("M".equals(formulaString)) {
                formula = "3*CL/4";
            }
            if ("B".equals(formulaString)) {
                formula = "CL/2";
            }
        } else {
            if ("G".equals(formulaString)) {
                formula = "(CL/2)+2";
            }
            if ("M".equals(formulaString)) {
                formula = "1+((CL/5).INTVAL)+(((CL+3)/5).INTVAL)";
            }
            if ("B".equals(formulaString)) {
                formula = "CL/3";
            }
        }
        if (formula.equals(formulaString)) {
            Logging.errorPrint("bad formula String:" + formulaString);
        }
        return formula;
    }

    private void go() {
        for (int i = 0; i < this.okList.size(); ++i) {
            if ("0".equals(this.okList.get(i).toString())) continue;
            int thisType = Integer.parseInt(this.lstTypeList.get(i).toString());
            if (thisType == 0) {
                Logging.errorPrint(this.lstNameList.get(i).toString() + " is UNKNOWN - not converting");
            }
            File conversionSource = new File(this.lstPathList.get(i).toString() + File.separatorChar + this.lstNameList.get(i).toString());
            try {
                BufferedReader conversionReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(conversionSource), "UTF-8"));
                int length = (int)conversionSource.length();
                char[] sourceInput = new char[length];
                conversionReader.read(sourceInput, 0, length);
                conversionReader.close();
                BufferedWriter conversionWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(conversionSource), "UTF-8"));
                String sourceInputString = new String(sourceInput);
                StringTokenizer sourceTokenizer = new StringTokenizer(sourceInputString, "\r\n", true);
                while (sourceTokenizer.hasMoreTokens()) {
                    String bString;
                    String line = sourceTokenizer.nextToken();
                    if ("\r".equals(line) || "\n".equals(line) || line.trim().length() == 0 || line.length() > 0 && line.charAt(0) == '#') {
                        conversionWriter.write(line);
                        continue;
                    }
                    StringTokenizer lineTokenizer = new StringTokenizer(line, "\t", false);
                    boolean hasTagless = false;
                    lineTokenizer.nextToken();
                    if (lineTokenizer.hasMoreTokens() && (bString = lineTokenizer.nextToken()).indexOf(":") == -1) {
                        hasTagless = true;
                    }
                    lineTokenizer = new StringTokenizer(line, "\t", true);
                    int field = 0;
                    if (!hasTagless) {
                        field = 100;
                    }
                    block19: while (lineTokenizer.hasMoreTokens()) {
                        String bString2;
                        block109: {
                            String q;
                            bString2 = lineTokenizer.nextToken();
                            if ("\t".equals(bString2)) {
                                conversionWriter.write(bString2);
                                continue;
                            }
                            if (field++ == 0) {
                                conversionWriter.write(bString2);
                                continue;
                            }
                            if (bString2.startsWith("PREFORT:")) {
                                conversionWriter.write("PRECHECK:1," + SettingsHandler.getGame().getUnmodifiableCheckList().get(0).toString().toUpperCase() + "=" + bString2.substring(8));
                                continue;
                            }
                            if (bString2.startsWith("PREREFLEX:")) {
                                conversionWriter.write("PRECHECK:1," + SettingsHandler.getGame().getUnmodifiableCheckList().get(1).toString().toUpperCase() + "=" + bString2.substring(10));
                                continue;
                            }
                            if (bString2.startsWith("PREWILL:")) {
                                conversionWriter.write("PRECHECK:1," + SettingsHandler.getGame().getUnmodifiableCheckList().get(2).toString().toUpperCase() + "=" + bString2.substring(8));
                                continue;
                            }
                            if (bString2.startsWith("PREFORTBASE:")) {
                                conversionWriter.write("PRECHECKBASE:1," + SettingsHandler.getGame().getUnmodifiableCheckList().get(0).toString().toUpperCase() + "=" + bString2.substring(12));
                                continue;
                            }
                            if (bString2.startsWith("PREREFLEXBASE:")) {
                                conversionWriter.write("PRECHECKBASE:1," + SettingsHandler.getGame().getUnmodifiableCheckList().get(1).toString().toUpperCase() + "=" + bString2.substring(14));
                                continue;
                            }
                            if (bString2.startsWith("PREWILLBASE:")) {
                                conversionWriter.write("PRECHECKBASE:1," + SettingsHandler.getGame().getUnmodifiableCheckList().get(2).toString().toUpperCase() + "=" + bString2.substring(12));
                                continue;
                            }
                            if (bString2.startsWith("PRESTAT:") && bString2.indexOf(",") == -1) {
                                conversionWriter.write("PRESTAT:1," + bString2.substring(8));
                                continue;
                            }
                            if (bString2.startsWith("PRECLASS:")) {
                                StringTokenizer p = new StringTokenizer(bString2.substring(9), ",", false);
                                q = p.nextToken();
                                try {
                                    Integer.parseInt(q);
                                    break block109;
                                }
                                catch (Exception exc) {
                                    conversionWriter.write("PRECLASS:1," + bString2.substring(9));
                                    continue;
                                }
                            }
                            if (bString2.startsWith("!PRECLASS:")) {
                                StringTokenizer p = new StringTokenizer(bString2.substring(10), ",", false);
                                q = p.nextToken();
                                try {
                                    Integer.parseInt(q);
                                    break block109;
                                }
                                catch (Exception exc) {
                                    conversionWriter.write("!PRECLASS:1," + bString2.substring(10));
                                    continue;
                                }
                            }
                            if (bString2.startsWith("PREWEAPONPROF:")) {
                                StringTokenizer p = new StringTokenizer(bString2.substring(14), ",", false);
                                q = p.nextToken();
                                try {
                                    Integer.parseInt(q);
                                }
                                catch (Exception exc) {
                                    conversionWriter.write("PREWEAPONPROF:" + Integer.toString(p.countTokens() + 1) + "," + bString2.substring(14));
                                    continue;
                                }
                            }
                        }
                        switch (thisType) {
                            case 1: {
                                if (!hasTagless && bString2.startsWith("STATADJ") || field > 1 && field < 8) {
                                    int statNum = field - 2;
                                    if (!hasTagless) {
                                        statNum = Integer.parseInt(bString2.substring(7, 8));
                                        bString2 = bString2.substring(9);
                                    }
                                    if ("0".equals(bString2)) continue block19;
                                    bString2 = "BONUS:STAT|" + ((PCStat)SettingsHandler.getGame().getUnmodifiableStatList().get(statNum)).getAbb() + "|" + bString2;
                                    conversionWriter.write(bString2);
                                    break;
                                }
                                if (field == 8) {
                                    bString2 = "FAVCLASS:" + bString2;
                                    conversionWriter.write(bString2);
                                    break;
                                }
                                if (field == 9) {
                                    if ("0".equals(bString2)) continue block19;
                                    bString2 = "XTRASKILLPTSPERLVL:" + bString2;
                                    conversionWriter.write(bString2);
                                    break;
                                }
                                if (field == 10) {
                                    if ("0".equals(bString2)) continue block19;
                                    bString2 = "STARTFEATS:" + bString2;
                                    conversionWriter.write(bString2);
                                    break;
                                }
                                conversionWriter.write(bString2);
                                break;
                            }
                            case 2: {
                                if (bString2.startsWith("INTMODTOSKILLS")) {
                                    bString2 = bString2.substring(3);
                                } else if (bString2.startsWith("GOLD:") || bString2.startsWith("AGESET:")) {
                                    bString2 = "";
                                } else {
                                    if (field == 2) continue block19;
                                    if (field == 3) {
                                        bString2 = "HD:" + bString2;
                                    } else if (field == 4) {
                                        bString2 = "STARTSKILLPTS:" + bString2;
                                    } else if (field == 5) {
                                        bString2 = "XTRAFEATS:" + bString2;
                                    } else if (field == 6) {
                                        bString2 = "SPELLSTAT:" + bString2;
                                    } else if (field == 7) {
                                        bString2 = "SPELLTYPE:" + bString2;
                                    } else if (field == 8 || bString2.startsWith("BAB:")) {
                                        if (bString2.startsWith("BAB:")) {
                                            bString2 = bString2.substring(4);
                                        }
                                        bString2 = LstConverter.getFormulaFor(0, bString2);
                                        bString2 = "BONUS:COMBAT|BAB|" + bString2;
                                    } else if (field == 9 || !hasTagless && bString2.startsWith("FORTITUDECHECK:") || !hasTagless && bString2.startsWith("CHECK1:")) {
                                        if (bString2.startsWith("FORT")) {
                                            bString2 = bString2.substring(15);
                                        }
                                        if (bString2.startsWith("CHECK1")) {
                                            bString2 = bString2.substring(7);
                                        }
                                        bString2 = LstConverter.getFormulaFor(1, bString2);
                                        bString2 = "BONUS:CHECKS|BASE." + SettingsHandler.getGame().getUnmodifiableCheckList().get(0).toString().toUpperCase() + "|" + bString2;
                                    } else if (field == 10 || !hasTagless && bString2.startsWith("REFLEXCHECK:") || !hasTagless && bString2.startsWith("CHECK2:")) {
                                        if (!hasTagless) {
                                            bString2 = bString2.substring(12);
                                        }
                                        if (bString2.startsWith("CHECK2")) {
                                            bString2 = bString2.substring(7);
                                        }
                                        bString2 = LstConverter.getFormulaFor(1, bString2);
                                        bString2 = "BONUS:CHECKS|BASE." + SettingsHandler.getGame().getUnmodifiableCheckList().get(1).toString().toUpperCase() + "|" + bString2;
                                    } else if (field == 11 || !hasTagless && bString2.startsWith("WILLPOWERCHECK:") || !hasTagless && bString2.startsWith("CHECK3:")) {
                                        if (!hasTagless) {
                                            bString2 = bString2.substring(15);
                                        }
                                        if (bString2.startsWith("CHECK3")) {
                                            bString2 = bString2.substring(7);
                                        }
                                        bString2 = LstConverter.getFormulaFor(1, bString2);
                                        bString2 = "BONUS:CHECKS|BASE." + SettingsHandler.getGame().getUnmodifiableCheckList().get(2).toString().toUpperCase() + "|" + bString2;
                                    }
                                }
                                conversionWriter.write(bString2);
                                break;
                            }
                            case 3: {
                                if (bString2.startsWith("EFFECTS:")) {
                                    bString2 = "DESC:" + bString2.substring(8);
                                } else if (bString2.startsWith("EFFECTTYPE:")) {
                                    bString2 = "TARGETAREA:" + bString2.substring(11);
                                } else if (field == 2) {
                                    bString2 = "SCHOOL:" + bString2;
                                } else if (field == 3) {
                                    bString2 = "SUBSCHOOL:" + bString2;
                                } else if (field == 4) {
                                    bString2 = "COMPS:" + bString2;
                                } else if (field == 5) {
                                    bString2 = "CASTTIME:" + bString2;
                                } else if (field == 6) {
                                    bString2 = "RANGE:" + bString2;
                                } else if (field == 7) {
                                    bString2 = "DESC:" + bString2;
                                } else if (field == 8) {
                                    bString2 = "TARGETAREA:" + bString2;
                                } else if (field == 9) {
                                    bString2 = "DURATION:" + bString2;
                                } else if (field == 10) {
                                    bString2 = "SAVEINFO:" + bString2;
                                } else if (field == 11) {
                                    bString2 = "SPELLRES:" + bString2;
                                }
                                conversionWriter.write(bString2);
                                break;
                            }
                            case 4: {
                                if (field == 2) {
                                    bString2 = "DOMAINS:" + bString2;
                                } else if (field == 3) {
                                    bString2 = "FOLLOWERALIGN:" + bString2;
                                } else if (field == 4) {
                                    bString2 = "DESC:" + bString2;
                                } else if (field == 5) {
                                    bString2 = "SYMBOL:" + bString2;
                                } else if (field == 6) {
                                    bString2 = "DEITYWEAP:" + bString2;
                                }
                                conversionWriter.write(bString2);
                                break;
                            }
                            case 5: {
                                if (field == 2) {
                                    bString2 = "DESC:" + bString2;
                                }
                                conversionWriter.write(bString2);
                                break;
                            }
                            case 6: {
                                if (field == 2) {
                                    bString2 = "KEYSTAT:" + bString2;
                                } else if (field == 3) {
                                    bString2 = "EXCLUSIVE:" + bString2;
                                } else if (field == 4) {
                                    bString2 = "USEUNTRAINED:" + bString2;
                                } else if (bString2.startsWith("SYNERGY:")) {
                                    String skillX = line.substring(0, line.indexOf("\t"));
                                    String skillY = bString2.substring(8, bString2.indexOf("="));
                                    String ranksY = bString2.substring(bString2.indexOf("=") + 1, bString2.lastIndexOf("="));
                                    String bonusToX = bString2.substring(bString2.lastIndexOf("=") + 1);
                                    bString2 = "BONUS:SKILL|" + skillX + "|" + bonusToX + "|PRESKILL:1," + skillY + "=" + ranksY + "|TYPE=Synergy.STACK";
                                }
                                conversionWriter.write(bString2);
                                break;
                            }
                            case 7: 
                            case 8: {
                                conversionWriter.write(bString2);
                                break;
                            }
                            default: {
                                Logging.errorPrint("In LstConverter.go the type " + thisType + " is not handled.");
                            }
                        }
                    }
                }
                this.okList.set(i, "0");
                this.doneList.set(i, "1");
                conversionWriter.close();
                continue;
            }
            catch (Exception e) {
                Logging.errorPrint("", e);
            }
        }
    }

    private void handleQuit() {
        this.dispose();
    }

    private void jbInit() throws Exception {
        JScrollPane lstScrollPane = new JScrollPane();
        final JTable lstTable = new JTable();
        LstTableModel lstTableModel = new LstTableModel();
        this.sorter.setModel(lstTableModel);
        this.sorter.addMouseListenerToHeaderInTable(lstTable);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)lstScrollPane, "Center");
        this.setSize(new Dimension(700, 500));
        lstTable.setModel(this.sorter);
        lstTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        lstTable.getColumnModel().getColumn(1).setPreferredWidth(160);
        lstTable.getColumnModel().getColumn(2).setCellRenderer(new TypeRenderer(typeTypes));
        lstTable.getColumnModel().getColumn(2).setCellEditor(new TypeEditor(typeTypes));
        lstTable.getColumnModel().getColumn(3).setCellRenderer(new OkRenderer(okTypes));
        lstTable.getColumnModel().getColumn(3).setCellEditor(new OkEditor(okTypes));
        lstTable.getColumnModel().getColumn(4).setCellRenderer(new DoneRenderer(okTypes));
        lstTable.getColumnModel().getColumn(4).setCellEditor(new DoneEditor(okTypes));
        lstTable.setAutoResizeMode(0);
        lstTable.setSelectionMode(0);
        lstScrollPane.setViewportView(lstTable);
        JPanel aPanel = new JPanel();
        this.getContentPane().add((Component)aPanel, "South");
        final JButton rButton = new JButton("Race");
        final JButton cButton = new JButton("Class");
        final JButton sButton = new JButton("Spell");
        final JButton dButton = new JButton("Deity");
        final JButton oButton = new JButton("Domain");
        final JButton kButton = new JButton("Skill");
        final JButton fButton = new JButton("Feat");
        final JButton tButton = new JButton("Template");
        final JButton aButton = new JButton("All");
        final JButton goButton = new JButton("Run!");
        aPanel.add(goButton);
        aPanel.add(new JLabel("Toggle:"));
        aPanel.add(aButton);
        aPanel.add(rButton);
        aPanel.add(cButton);
        aPanel.add(sButton);
        aPanel.add(dButton);
        aPanel.add(oButton);
        aPanel.add(kButton);
        aPanel.add(fButton);
        aPanel.add(tButton);
        aButton.setToolTipText("Toggle convert-me status of all known file types");
        rButton.setToolTipText("Toggle convert-me status of all race files");
        cButton.setToolTipText("Toggle convert-me status of all class files");
        sButton.setToolTipText("Toggle convert-me status of all spell/power files");
        dButton.setToolTipText("Toggle convert-me status of all deity files");
        oButton.setToolTipText("Toggle convert-me status of all domain files");
        kButton.setToolTipText("Toggle convert-me status of all skill files");
        fButton.setToolTipText("Toggle convert-me status of all feat files");
        tButton.setToolTipText("Toggle convert-me status of all template files");
        goButton.setToolTipText("Convert files from using required fields to use tagged format");
        ActionListener eventListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == goButton) {
                    LstConverter.this.go();
                    lstTable.updateUI();
                }
                if (evt.getSource() == rButton) {
                    LstConverter.this.toggleType(1);
                    lstTable.updateUI();
                }
                if (evt.getSource() == cButton) {
                    LstConverter.this.toggleType(2);
                    lstTable.updateUI();
                }
                if (evt.getSource() == sButton) {
                    LstConverter.this.toggleType(3);
                    lstTable.updateUI();
                }
                if (evt.getSource() == dButton) {
                    LstConverter.this.toggleType(4);
                    lstTable.updateUI();
                }
                if (evt.getSource() == oButton) {
                    LstConverter.this.toggleType(5);
                    lstTable.updateUI();
                }
                if (evt.getSource() == kButton) {
                    LstConverter.this.toggleType(6);
                    lstTable.updateUI();
                }
                if (evt.getSource() == fButton) {
                    LstConverter.this.toggleType(7);
                    lstTable.updateUI();
                }
                if (evt.getSource() == tButton) {
                    LstConverter.this.toggleType(8);
                    lstTable.updateUI();
                }
                if (evt.getSource() == aButton) {
                    for (int i = 1; i < 9; ++i) {
                        LstConverter.this.toggleType(i);
                    }
                    lstTable.updateUI();
                }
            }
        };
        rButton.addActionListener(eventListener);
        cButton.addActionListener(eventListener);
        sButton.addActionListener(eventListener);
        dButton.addActionListener(eventListener);
        oButton.addActionListener(eventListener);
        kButton.addActionListener(eventListener);
        fButton.addActionListener(eventListener);
        tButton.addActionListener(eventListener);
        aButton.addActionListener(eventListener);
        goButton.addActionListener(eventListener);
    }

    private boolean loadLSTFilesInDirectory(String aDirectory) {
        new File(aDirectory).list(new FilenameFilter(){

            public boolean accept(File aFile, String aString) {
                try {
                    aString = aString.toLowerCase();
                    if (aString.endsWith(".lst")) {
                        LstConverter.this.lstNameList.add(aString);
                        LstConverter.this.lstPathList.add(aFile.getPath());
                        int ok = 1;
                        if (aString.endsWith("race.lst") || aString.endsWith("races.lst")) {
                            LstConverter.this.lstTypeList.add("1");
                        } else if (aString.endsWith("class.lst") || aString.endsWith("classes.lst")) {
                            LstConverter.this.lstTypeList.add("2");
                        } else if ((aString.endsWith("spell.lst") || aString.endsWith("spells.lst") || aString.endsWith("power.lst") || aString.endsWith("powers.lst")) && aString.indexOf("classspell") == -1 && aString.indexOf("classpowers") == -1) {
                            LstConverter.this.lstTypeList.add("3");
                        } else if (aString.endsWith("deity.lst") || aString.endsWith("deities.lst")) {
                            LstConverter.this.lstTypeList.add("4");
                        } else if (aString.endsWith("domain.lst") || aString.endsWith("domains.lst")) {
                            LstConverter.this.lstTypeList.add("5");
                        } else if ((aString.endsWith("skill.lst") || aString.endsWith("skills.lst")) && aString.indexOf("classskill") == -1) {
                            LstConverter.this.lstTypeList.add("6");
                        } else if (aString.endsWith("feat.lst") || aString.endsWith("feats.lst")) {
                            LstConverter.this.lstTypeList.add("7");
                        } else if (aString.endsWith("template.lst") || aString.endsWith("templates.lst")) {
                            LstConverter.this.lstTypeList.add("8");
                        } else {
                            ok = 0;
                            LstConverter.this.lstTypeList.add("0");
                        }
                        if (ok > 0) {
                            LstConverter.this.okList.add("1");
                        } else {
                            LstConverter.this.okList.add("0");
                        }
                        LstConverter.this.doneList.add("0");
                    } else if (aFile.isDirectory()) {
                        LstConverter.this.loadLSTFilesInDirectory(aFile.getPath() + File.separator + aString);
                    }
                }
                catch (Exception e) {
                    Logging.errorPrint("LstConverter", e);
                }
                return false;
            }
        });
        return false;
    }

    private void toggleType(int x) {
        for (int i = 0; i < this.okList.size(); ++i) {
            int y = Integer.parseInt(this.lstTypeList.get(i).toString());
            if (x != y) continue;
            y = Integer.parseInt(this.okList.get(i).toString());
            if (y == 0) {
                this.okList.set(i, "1");
                continue;
            }
            this.okList.set(i, "0");
        }
    }

    private static final class TypeRenderer
    extends JComboBoxRenderer {
        private TypeRenderer(String[] choices) {
            super(choices);
        }
    }

    private static final class TypeEditor
    extends JComboBoxEditor {
        private TypeEditor(String[] choices) {
            super(choices);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ TypeEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.stopCellEditing();
                }
            });
        }
    }

    private static final class OkRenderer
    extends JComboBoxRenderer {
        private OkRenderer(String[] choices) {
            super(choices);
        }
    }

    private static final class OkEditor
    extends JComboBoxEditor {
        private OkEditor(String[] choices) {
            super(choices);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ OkEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.stopCellEditing();
                }
            });
        }
    }

    private final class LstTableModel
    extends AbstractTableModel {
        private LstTableModel() {
        }

        public boolean isCellEditable(int row, int column) {
            return column == 2 || column == 3;
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "File Name";
                }
                case 1: {
                    return "Path";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Convert Me";
                }
                case 4: {
                    return "Converted";
                }
            }
            Logging.errorPrint("In LstConverter.LstTableModel.getColumnName the column " + columnIndex + " is not handled.");
            return "Out Of Bounds";
        }

        public int getRowCount() {
            return LstConverter.this.lstNameList.size();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null || columnIndex < 1 || columnIndex > 4) {
                return;
            }
            Integer i = new Integer(aValue.toString());
            switch (columnIndex) {
                case 2: {
                    LstConverter.this.lstTypeList.set(rowIndex, i);
                    if (i != 0) break;
                    LstConverter.this.okList.set(rowIndex, i);
                    break;
                }
                case 3: {
                    int j;
                    if (i == 1 && (j = Integer.parseInt(LstConverter.this.lstTypeList.get(rowIndex).toString())) == 0) {
                        ShowMessageDelegate.showMessageDialog("Set type to a known type before marking it to be converted.", "Oops!", MessageType.ERROR);
                        return;
                    }
                    LstConverter.this.okList.set(rowIndex, i);
                    break;
                }
                default: {
                    Logging.errorPrint("In LstConverter.LstTableModel.setValueAt the column " + columnIndex + " is not handled.");
                }
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (LstConverter.this.lstNameList.size() <= rowIndex || columnIndex > 4) {
                return "Out of Bounds";
            }
            switch (columnIndex) {
                case 0: {
                    return LstConverter.this.lstNameList.get(rowIndex);
                }
                case 1: {
                    return LstConverter.this.lstPathList.get(rowIndex);
                }
                case 2: {
                    int x = Integer.parseInt(LstConverter.this.lstTypeList.get(rowIndex).toString());
                    return new Integer(x);
                }
                case 3: {
                    int ok = Integer.parseInt(LstConverter.this.okList.get(rowIndex).toString());
                    return new Integer(ok);
                }
                case 4: {
                    int ok = Integer.parseInt(LstConverter.this.doneList.get(rowIndex).toString());
                    return new Integer(ok);
                }
            }
            Logging.errorPrint("In LstConverter.LstTableModel.getValueAt the column " + columnIndex + " is not handled.");
            return null;
        }

        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }
    }

    private static final class DoneRenderer
    extends JComboBoxRenderer {
        private DoneRenderer(String[] choices) {
            super(choices);
        }
    }

    private static final class DoneEditor
    extends JComboBoxEditor {
        private DoneEditor(String[] choices) {
            super(choices);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ DoneEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.stopCellEditing();
                }
            });
        }
    }
}

